/*
 * Decompiled with CFR 0.152.
 */
package io.laniakia.algo;

import io.laniakia.algo.GlitchAlgorithm;
import io.laniakia.util.GlitchTypes;
import io.laniakia.util.ImageUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class BitSort
extends GlitchAlgorithm {
    public BitSort() {
        this.setName(GlitchTypes.BIT_SORT);
        this.setDescription("Sort Pixels by randomly shifting bits");
    }

    @Override
    public byte[] glitchPixels(byte[] inputImageBytes) throws Exception {
        int bitSortVerticalInterval = (Integer)this.getPixelGlitchParameters().get("bitSortVerticalInterval");
        int bitSortHorizontalInterval = (Integer)this.getPixelGlitchParameters().get("bitSortHorizontalInterval");
        int bitSortDistortion = (Integer)this.getPixelGlitchParameters().get("bitSortDistortion");
        BufferedImage inputImage = ImageUtil.getImageFromBytes(inputImageBytes);
        BufferedImage outputImage = ImageUtil.getImageFromBytes(inputImageBytes);
        int offsetHeight = inputImage.getHeight() - bitSortVerticalInterval;
        int offsetWidth = inputImage.getWidth() - bitSortHorizontalInterval;
        for (int i = 0; i < offsetHeight; ++i) {
            for (int j = 0; j < offsetWidth; ++j) {
                if (j + bitSortHorizontalInterval >= inputImage.getWidth() || i + bitSortVerticalInterval >= inputImage.getHeight() || i + bitSortVerticalInterval < 0 || j + bitSortHorizontalInterval < 0 || j < 0 || i < 0 || j >= inputImage.getWidth() || i >= inputImage.getHeight()) continue;
                Color currentPixel = new Color(inputImage.getRGB(j, i));
                Color nextPixel = new Color(inputImage.getRGB(j + bitSortHorizontalInterval, i + bitSortVerticalInterval));
                if (!(this.getHue(currentPixel) > (float)bitSortDistortion + this.getHue(nextPixel))) continue;
                outputImage.setRGB(j + bitSortHorizontalInterval, i + bitSortVerticalInterval, currentPixel.getRGB());
                outputImage.setRGB(j, i, nextPixel.getRGB());
            }
        }
        return ImageUtil.getImageBytes(outputImage);
    }

    public float getHue(Color inputPixel) {
        if (inputPixel.getRed() == inputPixel.getGreen() && inputPixel.getGreen() == inputPixel.getBlue()) {
            return 0.0f;
        }
        float r = (float)inputPixel.getRed() / 255.0f;
        float g = (float)inputPixel.getGreen() / 255.0f;
        float b = (float)inputPixel.getBlue() / 255.0f;
        float hue = 0.0f;
        float max = r;
        float min = r;
        if (g > max) {
            max = g;
        }
        if (b > max) {
            max = b;
        }
        if (g < min) {
            min = g;
        }
        if (b < min) {
            min = b;
        }
        float delta = max - min;
        if (r == max) {
            hue = (g - b) / delta;
        } else if (g == max) {
            hue = 2.0f + (b - r) / delta;
        } else if (b == max) {
            hue = 4.0f + (r - g) / delta;
        }
        hue *= 60.0f;
        if (hue < 0.0f) {
            hue += 360.0f;
        }
        return hue;
    }
}

