/*
 * Decompiled with CFR 0.152.
 */
package io.laniakia.algo;

import io.laniakia.algo.GlitchAlgorithm;
import io.laniakia.util.GlitchTypes;
import io.laniakia.util.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.ThreadLocalRandom;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class DataAsSound
extends GlitchAlgorithm {
    public DataAsSound() {
        this.setName(GlitchTypes.DATA_AS_SOUND);
        this.setDescription("Glitch pixels by reading playing and reading through back through distorted WAV audio stream");
    }

    @Override
    public byte[] glitchPixels(byte[] inputImageBytes) throws Exception {
        int audioBitRate = (Integer)this.getPixelGlitchParameters().get("bitRateBlend");
        float bitRateBlend = (float)audioBitRate / 10.0f;
        if (bitRateBlend < 0.1f || bitRateBlend > 0.9f) {
            return null;
        }
        BufferedImage inputImage = ImageUtil.getImageFromBytes(inputImageBytes);
        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(inputImageBytes);
        AudioInputStream distortionAudioStream = new AudioInputStream(imageInputStream, new AudioFormat(AudioFormat.Encoding.ULAW, ThreadLocalRandom.current().nextInt(8000, 20000), 8, 5, 9, ThreadLocalRandom.current().nextInt(8000, 20000), true), inputImageBytes.length);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AudioSystem.write(distortionAudioStream, AudioFileFormat.Type.WAVE, outputStream);
        BufferedImage outputImage = new BufferedImage(inputImage.getWidth(), inputImage.getHeight(), 6);
        byte[] imageData = ((DataBufferByte)outputImage.getRaster().getDataBuffer()).getData();
        System.arraycopy(outputStream.toByteArray(), 0, imageData, 0, outputStream.toByteArray().length);
        int[] abgrOffsets = new int[]{3, 2, 1, 0};
        DataBufferByte outputBuffer = new DataBufferByte(imageData, imageData.length);
        WritableRaster raster = Raster.createInterleavedRaster(outputBuffer, inputImage.getWidth(), inputImage.getHeight(), 4 * inputImage.getWidth(), 4, abgrOffsets, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        BufferedImage rasterizedImage = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        rasterizedImage = this.resizeImage(rasterizedImage, inputImage.getWidth() * 4, inputImage.getHeight() * 4);
        Graphics2D g2d = rasterizedImage.createGraphics();
        g2d.setComposite(AlphaComposite.SrcOver.derive(bitRateBlend));
        g2d.drawImage((Image)inputImage, 0, 0, null);
        g2d.dispose();
        rasterizedImage = rasterizedImage.getSubimage(0, 0, inputImage.getWidth(), inputImage.getHeight());
        return ImageUtil.getImageBytes(rasterizedImage);
    }

    public BufferedImage resizeImage(BufferedImage inputImage, int width, int height) {
        Image outputImage = inputImage.getScaledInstance(width, height, 16);
        BufferedImage bi = new BufferedImage(width, height, 6);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(outputImage, 0, 0, null);
        g2d.dispose();
        return bi;
    }
}

