/*
 * Decompiled with CFR 0.152.
 */
package io.laniakia.algo;

import io.laniakia.algo.GlitchAlgorithm;
import io.laniakia.util.ImageUtil;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.util.concurrent.ThreadLocalRandom;

public class DataBend
extends GlitchAlgorithm {
    public DataBend() {
        this.setDescription("Sort pixels in a random order by iterations");
    }

    @Override
    public byte[] glitchPixels(byte[] inputImageBytes) throws Exception {
        int i;
        int randomizationPercent = (Integer)this.getPixelGlitchParameters().get("randomizationPercent");
        int pixelBlockSize = (Integer)this.getPixelGlitchParameters().get("pixelBlockSize");
        BufferedImage outputImage = ImageUtil.getImageFromBytes(inputImageBytes);
        Color[][] pixelArray = new Color[outputImage.getWidth()][outputImage.getHeight()];
        for (i = 0; i < outputImage.getWidth(); ++i) {
            for (int j = 0; j < outputImage.getHeight(); ++j) {
                int byteCorruptProbability = ThreadLocalRandom.current().nextInt(0, 101);
                if (byteCorruptProbability <= randomizationPercent && i > pixelBlockSize && j > pixelBlockSize && outputImage.getWidth() - i > pixelBlockSize && outputImage.getHeight() - j > pixelBlockSize) {
                    int a;
                    int b;
                    Color randPixel;
                    int y;
                    int x;
                    int expansionDirection = ThreadLocalRandom.current().nextInt(0, 2);
                    if (expansionDirection == 0) {
                        x = ThreadLocalRandom.current().nextInt(pixelBlockSize, outputImage.getWidth() - pixelBlockSize);
                        y = ThreadLocalRandom.current().nextInt(pixelBlockSize, outputImage.getHeight() - pixelBlockSize);
                        pixelArray[i][j] = randPixel = new Color(outputImage.getRGB(x, y));
                        for (b = 0; b < pixelBlockSize; ++b) {
                            a = 0;
                            while (a < pixelBlockSize) {
                                if (i - b >= 0 && j - a >= 0) {
                                    pixelArray[i - b][j - a] = new Color(outputImage.getRGB(x - b, y - a));
                                }
                                ++b;
                            }
                        }
                        continue;
                    }
                    x = ThreadLocalRandom.current().nextInt(pixelBlockSize, outputImage.getWidth() - pixelBlockSize);
                    y = ThreadLocalRandom.current().nextInt(pixelBlockSize, outputImage.getHeight() - pixelBlockSize);
                    pixelArray[i][j] = randPixel = new Color(outputImage.getRGB(x, y));
                    for (b = 0; b < pixelBlockSize; ++b) {
                        a = 0;
                        while (a < pixelBlockSize) {
                            pixelArray[i + b][j + a] = new Color(outputImage.getRGB(x + b, y + a));
                            ++b;
                        }
                    }
                    continue;
                }
                pixelArray[i][j] = new Color(outputImage.getRGB(i, j));
            }
        }
        for (i = 0; i < outputImage.getWidth(); ++i) {
            for (int e = 0; e < outputImage.getHeight(); ++e) {
                outputImage.setRGB(i, e, pixelArray[i][e].getRed() << 16 | pixelArray[i][e].getGreen() << 8 | pixelArray[i][e].getBlue());
            }
        }
        return ImageUtil.getImageBytes(outputImage);
    }

    private static BufferedImage createRGBImage(byte[] bytes, int width, int height) {
        DataBufferByte buffer = new DataBufferByte(bytes, bytes.length);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        return new BufferedImage(cm, Raster.createInterleavedRaster(buffer, width, height, width * 3, 3, new int[]{0, 1, 2}, null), false, null);
    }
}

