/*
 * Decompiled with CFR 0.152.
 */
package io.laniakia.algo;

import io.laniakia.algo.GlitchAlgorithm;
import io.laniakia.util.GlitchTypes;
import io.laniakia.util.ImageUtil;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;

public class HorizontalPixelSort
extends GlitchAlgorithm {
    public HorizontalPixelSort() {
        this.setName(GlitchTypes.HORIZONTAL_PIXEL_SORT);
        this.setDescription("Horizontal pixel displacement.");
    }

    @Override
    public byte[] glitchPixels(byte[] inputImageBytes) throws Exception {
        int interval = (Integer)this.getPixelGlitchParameters().get("interval");
        BufferedImage inputImage = ImageUtil.getImageFromBytes(inputImageBytes);
        int[] bufferedImageOutputRGBArray = ImageUtil.getCanvasFormatPixels(inputImage);
        int j = ThreadLocalRandom.current().nextInt(1, interval);
        for (int i = 0; i < j; ++i) {
            int pixelEndOffset = Double.valueOf(Math.floor(Math.random() * (double)(inputImage.getWidth() * inputImage.getHeight() * 4))).intValue();
            int pixelStartOffset = Double.valueOf((long)pixelEndOffset - (Math.round(Math.random() * 1000.0) + 5100L)).intValue();
            int[] pixelSubArray = Arrays.copyOfRange(bufferedImageOutputRGBArray, pixelStartOffset, pixelEndOffset);
            System.arraycopy(pixelSubArray, 0, bufferedImageOutputRGBArray, Double.valueOf(Math.floor(Math.random() * (double)(inputImage.getWidth() * inputImage.getHeight() * 4 - pixelSubArray.length))).intValue(), pixelSubArray.length);
        }
        return ImageUtil.getImageBytes(ImageUtil.getImageFromCanvasPixelArray(bufferedImageOutputRGBArray, inputImage));
    }
}

