/*
 * Decompiled with CFR 0.152.
 */
package io.laniakia.algo;

import io.laniakia.algo.GlitchAlgorithm;
import io.laniakia.util.GlitchTypes;
import io.laniakia.util.ImageUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;

public class PixelSort
extends GlitchAlgorithm {
    public PixelSort() {
        this.setName(GlitchTypes.GENERIC_PIXEL_SORT_V1);
        this.setDescription("Sort pixels in a random order by color displacement");
    }

    @Override
    public byte[] glitchPixels(byte[] inputImageBytes) throws Exception {
        int j;
        int i;
        int distortion = (Integer)this.getPixelGlitchParameters().get("brightness");
        double distortionLength = (Double)this.getPixelGlitchParameters().get("distortionLength");
        distortion = ThreadLocalRandom.current().nextInt(distortion, 100);
        boolean pixelBrightnessChoice = false;
        distortionLength = ThreadLocalRandom.current().nextDouble(distortionLength, 11.0);
        double brightnessModification = 0.0;
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(inputImageBytes));
        int[][] pixel2DArray = new int[image.getWidth()][image.getHeight()];
        int displacedVerticalRow = 0;
        int maximumLuminosity = 0;
        int maximumVerticalDithering = 1;
        int nextPixelIndex = 0;
        for (i = 0; i < image.getWidth(); ++i) {
            for (j = 0; j < image.getHeight(); ++j) {
                Color currentPixel = new Color(image.getRGB(i, j));
                int red = currentPixel.getRed();
                int green = currentPixel.getGreen();
                int blue = currentPixel.getBlue();
                if (j != 0) {
                    if (!pixelBrightnessChoice) {
                        int meanColorRGB;
                        if (nextPixelIndex != i) {
                            displacedVerticalRow = 0;
                        }
                        Color nextPixelColor = null;
                        nextPixelColor = displacedVerticalRow == 0 ? new Color(image.getRGB(i, j - 1)) : new Color(image.getRGB(i, j - (1 + displacedVerticalRow)));
                        if (displacedVerticalRow != 0) {
                            ++displacedVerticalRow;
                        }
                        if ((meanColorRGB = Math.round((nextPixelColor.getRed() + nextPixelColor.getGreen() + nextPixelColor.getBlue()) / 3)) >= distortion && displacedVerticalRow == 0) {
                            displacedVerticalRow = 1;
                            nextPixelIndex = i;
                            maximumLuminosity = meanColorRGB - distortion;
                            maximumVerticalDithering = (int)Math.round((double)maximumLuminosity * distortionLength);
                        }
                        if (displacedVerticalRow > 0 && displacedVerticalRow < maximumVerticalDithering) {
                            red = nextPixelColor.getRed();
                            green = nextPixelColor.getGreen();
                            blue = nextPixelColor.getBlue();
                        } else {
                            displacedVerticalRow = 0;
                        }
                    } else if (i != 0) {
                        int meanColorRGB = 0;
                        Color previousPixelColumnColor = new Color(image.getRGB(i - 1, j));
                        meanColorRGB = Math.round((previousPixelColumnColor.getRed() + previousPixelColumnColor.getGreen() + previousPixelColumnColor.getBlue()) / 3);
                        if (meanColorRGB >= distortion && displacedVerticalRow == 0) {
                            displacedVerticalRow = 1;
                            maximumLuminosity = meanColorRGB - distortion;
                            maximumVerticalDithering = (int)Math.round((double)maximumLuminosity * distortionLength);
                            if (brightnessModification > 0.0) {
                                maximumLuminosity = (int)Math.round((double)maximumLuminosity * brightnessModification);
                            }
                        }
                        if (displacedVerticalRow > 0 && displacedVerticalRow < maximumVerticalDithering) {
                            red = red + maximumLuminosity <= 255 ? (red += maximumLuminosity) : 255;
                            green = green + maximumLuminosity <= 255 ? (green += maximumLuminosity) : 255;
                            blue = blue + maximumLuminosity <= 255 ? (blue += maximumLuminosity) : 255;
                            ++displacedVerticalRow;
                        } else {
                            displacedVerticalRow = 0;
                        }
                    }
                }
                Color nextPixelColorOutput = new Color(red, green, blue);
                pixel2DArray[i][j] = nextPixelColorOutput.getRGB();
            }
        }
        for (i = 0; i < image.getWidth(); ++i) {
            for (j = 0; j < image.getHeight(); ++j) {
                image.setRGB(i, j, pixel2DArray[i][j]);
            }
        }
        return ImageUtil.getImageBytes(image);
    }
}

