/*
 * Decompiled with CFR 0.152.
 */
package io.laniakia.algo;

import io.laniakia.algo.GlitchAlgorithm;
import io.laniakia.util.GlitchTypes;
import io.laniakia.util.ImageUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class VerticalPixelGlitch
extends GlitchAlgorithm {
    public VerticalPixelGlitch() {
        this.setName(GlitchTypes.VERTICAL_PIXEL_GLITCH);
        this.setDescription("Glitch RGB value of pixels in a simple vertical fashion");
    }

    @Override
    public byte[] glitchPixels(byte[] inputImageBytes) throws Exception {
        int distortion = (Integer)this.getPixelGlitchParameters().get("distortionAmount");
        BufferedImage inputImage = ImageUtil.getImageFromBytes(inputImageBytes);
        BufferedImage outputImage = new BufferedImage(inputImage.getWidth(), inputImage.getHeight(), 1);
        boolean newVerticalPixelColumn = false;
        int currentPixelPosition = -1;
        int currentPixelRowIndex = -1;
        float distortionAmount = (float)distortion / 100.0f;
        for (int w = 0; w < inputImage.getWidth(); ++w) {
            newVerticalPixelColumn = true;
            Color[] verticalPixelArray = new Color[inputImage.getHeight()];
            currentPixelRowIndex = 0;
            for (int h = 0; h < inputImage.getHeight(); ++h) {
                Color currentPixel = new Color(inputImage.getRGB(w, h));
                if (this.GetBrightness(currentPixel) > distortionAmount) {
                    outputImage.setRGB(w, h, currentPixel.getRGB());
                    if (newVerticalPixelColumn) continue;
                    this.sortPixelsInColumn(verticalPixelArray, 0, currentPixelRowIndex - 1);
                    for (int j = 0; j < currentPixelRowIndex; ++j) {
                        outputImage.setRGB(w, j + currentPixelPosition, verticalPixelArray[j].getRGB());
                    }
                    verticalPixelArray = new Color[inputImage.getHeight()];
                    currentPixelRowIndex = 0;
                    newVerticalPixelColumn = true;
                    continue;
                }
                if (!(this.GetBrightness(currentPixel) <= distortionAmount)) continue;
                if (newVerticalPixelColumn) {
                    currentPixelPosition = h;
                    newVerticalPixelColumn = false;
                }
                verticalPixelArray[currentPixelRowIndex++] = currentPixel;
            }
            if (newVerticalPixelColumn) continue;
            this.sortPixelsInColumn(verticalPixelArray, 0, currentPixelRowIndex - 1);
            for (int i = 0; i < currentPixelRowIndex; ++i) {
                outputImage.setRGB(w, i + currentPixelPosition, verticalPixelArray[i].getRGB());
            }
        }
        return ImageUtil.getImageBytes(outputImage);
    }

    private void sortPixelsInColumn(Color[] pixelArray, int leftPixel, int rightPixel) {
        int leftSidePixel = leftPixel;
        int rightSidePixel = rightPixel;
        float halfBrightness = this.GetBrightness(pixelArray[(leftPixel + rightPixel) / 2]);
        while (leftSidePixel <= rightSidePixel) {
            while (this.GetBrightness(pixelArray[leftSidePixel]) < halfBrightness) {
                ++leftSidePixel;
            }
            while (this.GetBrightness(pixelArray[rightSidePixel]) > halfBrightness) {
                --rightSidePixel;
            }
            if (leftSidePixel > rightSidePixel) continue;
            Color currentPixel = pixelArray[leftSidePixel];
            pixelArray[leftSidePixel] = pixelArray[rightSidePixel];
            pixelArray[rightSidePixel] = currentPixel;
            --rightSidePixel;
            ++leftSidePixel;
        }
        if (leftPixel < rightSidePixel) {
            this.sortPixelsInColumn(pixelArray, leftPixel, rightSidePixel);
        }
        if (leftSidePixel < rightPixel) {
            this.sortPixelsInColumn(pixelArray, leftSidePixel, rightPixel);
        }
    }

    private float GetBrightness(Color inputColor) {
        float r = (float)inputColor.getRed() / 255.0f;
        float g = (float)inputColor.getGreen() / 255.0f;
        float b = (float)inputColor.getBlue() / 255.0f;
        float max = r;
        float min = r;
        if (g > max) {
            max = g;
        }
        if (b > max) {
            max = b;
        }
        if (g < min) {
            min = g;
        }
        if (b < min) {
            min = b;
        }
        return (max + min) / 2.0f;
    }
}

