/*
 * Decompiled with CFR 0.152.
 */
package io.laniakia.filter;

import io.laniakia.algo.GlitchAlgorithm;
import io.laniakia.util.GlitchTypes;
import io.laniakia.util.ImageUtil;
import java.awt.image.BufferedImage;

public class BrightnessFilter
extends GlitchAlgorithm {
    public BrightnessFilter() {
        this.setName(GlitchTypes.BRIGHTNESS_FILTER);
        this.setDescription("Increase or Decrease brightness by RGB shifts.");
    }

    @Override
    public byte[] glitchPixels(byte[] inputImageBytes) throws Exception {
        int renderBrightness = (Integer)this.getPixelGlitchParameters().get("renderBrightness");
        if (renderBrightness < -10 || renderBrightness > 10) {
            return null;
        }
        float brightnessValue = 1.0f + (float)renderBrightness / 10.0f;
        BufferedImage outputImage = ImageUtil.changeBrightness(ImageUtil.getImageFromBytes(inputImageBytes), brightnessValue);
        return ImageUtil.getImageBytes(outputImage);
    }
}

