/*
 * Decompiled with CFR 0.152.
 */
package io.laniakia.ui;

import io.laniakia.algo.GlitchAlgorithm;
import io.laniakia.ui.GlitchUIManager;
import io.laniakia.ui.SelectionPointManager;
import io.laniakia.util.GlitchTypes;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GlitchArt
extends JFrame {
    public JPanel contentPane;
    public JButton btnOpen;
    public JTextField txtPath;
    public JButton btnExport;
    public JPanel imagePreviewPanel;
    public JLabel lblImageRender;
    public JLayeredPane layeredPane;
    public JLabel label_1;
    public JButton button_2;
    public JComboBox jAlgorithmSelection;
    public JButton button_3;
    public JButton button_4;
    public JList<GlitchAlgorithm> jAlgorithmList;
    public JButton button_5;
    public JButton button_6;
    public JPanel pixelSortPanel;
    public JLabel lblDistortion;
    public JSlider pixelSortBrightness;
    public JLabel lblDistortionLength;
    public JSlider pixelSortLength;
    public JPanel fractalSortPanel;
    public JLabel lblDistortionAmount;
    public JSlider fractalSortDistortionAmount;
    public JPanel pixelSlicePanel;
    public JLabel lblDistortionAmount_1;
    public JSlider pixelSliceAmount;
    public JPanel randomPixelPanel;
    public JLabel lblRandomization;
    public JSlider randomRandomization;
    public JLabel lblNewLabel;
    public JSlider randomDistortionAmount;
    public JPanel dataAsSoundPanel;
    public JLabel lblBitrateDistort;
    public JSlider dataAsSoundBitRate;
    public JPanel rgbShiftPanel;
    public JLabel lblEffect;
    public JComboBox rgbShiftColor;
    public JLabel lblShiftAmount;
    public JSlider rgbShiftAmount;
    public JPanel brightnessPanel;
    public JLabel lblBrightness;
    public JSlider brightnessSlider;
    public JPanel offsetSortPanel;
    public JLabel lblDistortionAmount_2;
    public JSlider offsetDistortionAmount;
    public JLabel lblDistortionBrightness;
    public JSlider offsetBrightness;
    public JLabel lblScanlines;
    public JComboBox offsetScanLines;
    public JPanel verticalPixelSortPanel;
    public JLabel lblInterval;
    public JSlider verticalInterval;
    public JButton btnClearSelection;
    public JPanel randomPixelGlitchPanel;
    public JLabel lblDistortionAmount_3;
    public JSlider randomGlitchDistortion;
    public JPanel bitSortPanel;
    public JLabel lblNewLabel_1;
    public JLabel lblNewLabel_3;
    public JLabel lblVerticalIncrement;
    public JSlider bitSortDistortion;
    public JSlider bitSortVerticalInterval;
    public JSlider bitSortHorizontalInterval;
    public GlitchUIManager glitchUIManager;
    public SelectionPointManager selectionPointManager;
    public int resizedHeight;
    public int resizedWidth;
    public int realHeight;
    public int realWidth;
    public JButton btnReset;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel("com.jtattoo.plaf.hifi.HiFiLookAndFeel");
                    GlitchArt frame = new GlitchArt();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public GlitchArt() {
        this.setResizable(false);
        this.setTitle("Glitch Kernel");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 957, 482);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.glitchUIManager = new GlitchUIManager(this);
        this.selectionPointManager = new SelectionPointManager(this.glitchUIManager.getGlitchController(), this);
        this.btnOpen = new JButton("Open");
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlitchArt.this.glitchUIManager.openFile();
            }
        });
        this.txtPath = new JTextField();
        this.txtPath.setEditable(false);
        this.txtPath.setColumns(10);
        this.btnExport = new JButton("Export");
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlitchArt.this.glitchUIManager.exportFile();
            }
        });
        this.imagePreviewPanel = new JPanel();
        this.lblImageRender = new JLabel(""){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                GlitchArt.this.selectionPointManager.processImageRenderPaint(g);
            }
        };
        this.lblImageRender.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                GlitchArt.this.selectionPointManager.processMouseRelease(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GlitchArt.this.selectionPointManager.processMousePress(e);
            }
        });
        this.lblImageRender.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                GlitchArt.this.selectionPointManager.processMouseDrag(e);
            }
        });
        this.lblImageRender.setBackground(Color.ORANGE);
        GroupLayout gl_imagePreviewPanel = new GroupLayout(this.imagePreviewPanel);
        gl_imagePreviewPanel.setHorizontalGroup(gl_imagePreviewPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 511, Short.MAX_VALUE).addComponent(this.lblImageRender, -1, 511, Short.MAX_VALUE));
        gl_imagePreviewPanel.setVerticalGroup(gl_imagePreviewPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGap(0, 390, Short.MAX_VALUE).addComponent(this.lblImageRender, GroupLayout.Alignment.LEADING, -1, 390, Short.MAX_VALUE));
        this.imagePreviewPanel.setLayout(gl_imagePreviewPanel);
        this.layeredPane = new JLayeredPane();
        GroupLayout gl_contentPane = new GroupLayout(this.contentPane);
        gl_contentPane.setHorizontalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addGap(21).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addComponent(this.btnOpen, -2, 126, -2).addGap(18).addComponent(this.txtPath, -1, 629, Short.MAX_VALUE).addGap(18).addComponent(this.btnExport, -2, 109, -2)).addGroup(GroupLayout.Alignment.TRAILING, gl_contentPane.createSequentialGroup().addComponent(this.layeredPane, -2, 383, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.imagePreviewPanel, -2, 511, -2))).addContainerGap()));
        gl_contentPane.setVerticalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addContainerGap().addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOpen).addComponent(this.txtPath, -2, -1, -2).addComponent(this.btnExport)).addGap(19).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imagePreviewPanel, -2, 390, -2).addComponent(this.layeredPane, -2, 1010, -2)).addContainerGap()));
        this.label_1 = new JLabel("Algorithm:");
        this.button_2 = new JButton("Regenerate");
        this.button_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlitchArt.this.glitchUIManager.refreshPreviewImage();
            }
        });
        this.jAlgorithmSelection = new JComboBox();
        this.jAlgorithmSelection.setModel(new DefaultComboBoxModel<GlitchTypes>(GlitchTypes.values()));
        this.button_3 = new JButton("Add");
        this.button_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlitchArt.this.glitchUIManager.addAlgorithm();
            }
        });
        this.button_4 = new JButton("Remove");
        this.button_4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlitchArt.this.glitchUIManager.removeAlgorithm();
            }
        });
        this.jAlgorithmList = new JList();
        this.jAlgorithmList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GlitchArt.this.glitchUIManager.changeAlgorithmSelection();
                    GlitchArt.this.selectionPointManager.drawSelectedRectangle();
                }
            }
        });
        this.jAlgorithmList.setFont(new Font("Tahoma", 0, 10));
        this.button_5 = new JButton("\u2191");
        this.button_5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlitchArt.this.glitchUIManager.changeAlgorithmOrder(true);
            }
        });
        this.button_6 = new JButton("\u2193");
        this.button_6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlitchArt.this.glitchUIManager.changeAlgorithmOrder(false);
            }
        });
        this.pixelSortPanel = new JPanel();
        this.pixelSortPanel.setVisible(false);
        this.fractalSortPanel = new JPanel();
        this.fractalSortPanel.setVisible(false);
        this.pixelSlicePanel = new JPanel();
        this.pixelSlicePanel.setVisible(false);
        this.randomPixelPanel = new JPanel();
        this.randomPixelPanel.setVisible(false);
        this.dataAsSoundPanel = new JPanel();
        this.dataAsSoundPanel.setVisible(false);
        this.rgbShiftPanel = new JPanel();
        this.rgbShiftPanel.setVisible(false);
        this.brightnessPanel = new JPanel();
        this.brightnessPanel.setVisible(false);
        this.offsetSortPanel = new JPanel();
        this.offsetSortPanel.setVisible(false);
        this.verticalPixelSortPanel = new JPanel();
        this.verticalPixelSortPanel.setVisible(false);
        this.btnClearSelection = new JButton("Clear Selection");
        this.btnClearSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlitchArt.this.selectionPointManager.clearSelectionPoint();
                GlitchArt.this.glitchUIManager.refreshPreviewImage();
            }
        });
        this.randomPixelGlitchPanel = new JPanel();
        this.randomPixelGlitchPanel.setVisible(false);
        GridBagLayout gbl_randomPixelGlitchPanel = new GridBagLayout();
        gbl_randomPixelGlitchPanel.columnWidths = new int[]{0, 0, 0};
        gbl_randomPixelGlitchPanel.rowHeights = new int[]{0, 0};
        gbl_randomPixelGlitchPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_randomPixelGlitchPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.randomPixelGlitchPanel.setLayout(gbl_randomPixelGlitchPanel);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.VERTICAL_PIXEL_GLITCH, this.randomPixelGlitchPanel);
        this.lblDistortionAmount_3 = new JLabel("Distortion Amount:");
        GridBagConstraints gbc_lblDistortionAmount_3 = new GridBagConstraints();
        gbc_lblDistortionAmount_3.anchor = 17;
        gbc_lblDistortionAmount_3.insets = new Insets(0, 0, 0, 5);
        gbc_lblDistortionAmount_3.gridx = 0;
        gbc_lblDistortionAmount_3.gridy = 0;
        this.randomPixelGlitchPanel.add((Component)this.lblDistortionAmount_3, gbc_lblDistortionAmount_3);
        this.randomGlitchDistortion = new JSlider();
        this.randomGlitchDistortion.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.randomGlitchDistortion);
            }
        });
        this.randomGlitchDistortion.setValue(1);
        this.randomGlitchDistortion.setMinimum(1);
        GridBagConstraints gbc_randomGlitchDistortion = new GridBagConstraints();
        gbc_randomGlitchDistortion.anchor = 17;
        gbc_randomGlitchDistortion.gridx = 1;
        gbc_randomGlitchDistortion.gridy = 0;
        this.randomPixelGlitchPanel.add((Component)this.randomGlitchDistortion, gbc_randomGlitchDistortion);
        this.bitSortPanel = new JPanel();
        this.bitSortPanel.setVisible(false);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.GENERIC_PIXEL_SORT_V1, this.pixelSortPanel);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.PIXEL_SLICE, this.pixelSlicePanel);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.OFFSET_PIXEL_SORT, this.offsetSortPanel);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.FRACTAL_PIXEL_DISPERSE, this.fractalSortPanel);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.DATA_AS_SOUND, this.dataAsSoundPanel);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.RGB_SHIFT_FILTER, this.rgbShiftPanel);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.BRIGHTNESS_FILTER, this.brightnessPanel);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.BIT_SORT, this.bitSortPanel);
        this.glitchUIManager.getjPanelMapping().put(GlitchTypes.HORIZONTAL_PIXEL_SORT, this.verticalPixelSortPanel);
        this.btnReset = new JButton("Reset");
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlitchArt.this.glitchUIManager.resetUI();
            }
        });
        GroupLayout gl_layeredPane = new GroupLayout(this.layeredPane);
        gl_layeredPane.setHorizontalGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_layeredPane.createSequentialGroup().addContainerGap().addGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bitSortPanel, -1, 373, Short.MAX_VALUE).addComponent(this.verticalPixelSortPanel, -1, 373, Short.MAX_VALUE).addComponent(this.offsetSortPanel, -1, 373, Short.MAX_VALUE).addComponent(this.rgbShiftPanel, -1, 373, Short.MAX_VALUE).addComponent(this.dataAsSoundPanel, -1, 373, Short.MAX_VALUE).addComponent(this.randomPixelPanel, -1, 373, Short.MAX_VALUE).addComponent(this.pixelSlicePanel, -1, 373, Short.MAX_VALUE).addComponent(this.pixelSortPanel, -1, 373, Short.MAX_VALUE).addGroup(gl_layeredPane.createSequentialGroup().addGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_layeredPane.createSequentialGroup().addComponent(this.jAlgorithmList, -2, 232, -2).addGap(18).addGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.button_6, -2, 39, -2).addComponent(this.button_5, -2, 39, -2).addComponent(this.btnReset, -2, 103, -2))).addGroup(gl_layeredPane.createSequentialGroup().addGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(gl_layeredPane.createSequentialGroup().addComponent(this.label_1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.button_2, -2, 103, -2)).addComponent(this.jAlgorithmSelection, GroupLayout.Alignment.LEADING, -2, 175, -2)).addGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(gl_layeredPane.createSequentialGroup().addGap(6).addComponent(this.button_3, -2, 51, -2).addGap(6).addComponent(this.button_4, -2, 71, -2)).addGroup(gl_layeredPane.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnClearSelection, -1, -1, Short.MAX_VALUE))))).addContainerGap(20, Short.MAX_VALUE)).addComponent(this.fractalSortPanel, -1, 373, Short.MAX_VALUE).addComponent(this.brightnessPanel, -1, 373, Short.MAX_VALUE).addComponent(this.randomPixelGlitchPanel, -1, 373, Short.MAX_VALUE))));
        gl_layeredPane.setVerticalGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_layeredPane.createSequentialGroup().addGap(15).addGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label_1).addComponent(this.button_2).addComponent(this.btnClearSelection)).addGap(22).addGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_layeredPane.createSequentialGroup().addGap(1).addComponent(this.jAlgorithmSelection, -2, -1, -2)).addComponent(this.button_3).addComponent(this.button_4)).addGap(18).addGroup(gl_layeredPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAlgorithmList, -2, 147, -2).addGroup(gl_layeredPane.createSequentialGroup().addComponent(this.button_5).addGap(10).addComponent(this.button_6).addGap(11).addComponent(this.btnReset))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pixelSortPanel, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fractalSortPanel, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pixelSlicePanel, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.randomPixelPanel, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dataAsSoundPanel, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rgbShiftPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.brightnessPanel, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offsetSortPanel, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verticalPixelSortPanel, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.randomPixelGlitchPanel, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bitSortPanel, -2, -1, -2).addContainerGap(46, Short.MAX_VALUE)));
        GridBagLayout gbl_bitSortPanel = new GridBagLayout();
        gbl_bitSortPanel.columnWidths = new int[]{0, 0, 0};
        gbl_bitSortPanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_bitSortPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_bitSortPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.bitSortPanel.setLayout(gbl_bitSortPanel);
        this.lblNewLabel_1 = new JLabel("Distortion:");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_1.anchor = 17;
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 0;
        this.bitSortPanel.add((Component)this.lblNewLabel_1, gbc_lblNewLabel_1);
        this.bitSortDistortion = new JSlider();
        this.bitSortDistortion.setMinorTickSpacing(5);
        this.bitSortDistortion.setInverted(true);
        this.bitSortDistortion.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.bitSortDistortion);
            }
        });
        this.bitSortDistortion.setValue(300);
        this.bitSortDistortion.setMaximum(600);
        GridBagConstraints gbc_bitSortThreshHold = new GridBagConstraints();
        gbc_bitSortThreshHold.anchor = 17;
        gbc_bitSortThreshHold.insets = new Insets(0, 0, 5, 0);
        gbc_bitSortThreshHold.gridx = 1;
        gbc_bitSortThreshHold.gridy = 0;
        this.bitSortPanel.add((Component)this.bitSortDistortion, gbc_bitSortThreshHold);
        this.lblNewLabel_3 = new JLabel("Horizontal Increment:");
        GridBagConstraints gbc_lblNewLabel_3 = new GridBagConstraints();
        gbc_lblNewLabel_3.anchor = 17;
        gbc_lblNewLabel_3.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_3.gridx = 0;
        gbc_lblNewLabel_3.gridy = 1;
        this.bitSortPanel.add((Component)this.lblNewLabel_3, gbc_lblNewLabel_3);
        this.bitSortVerticalInterval = new JSlider();
        this.bitSortVerticalInterval.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.bitSortVerticalInterval);
            }
        });
        this.bitSortVerticalInterval.setValue(0);
        this.bitSortVerticalInterval.setMinimum(-100);
        GridBagConstraints gbc_bitSortVerticalIncrement = new GridBagConstraints();
        gbc_bitSortVerticalIncrement.insets = new Insets(0, 0, 5, 0);
        gbc_bitSortVerticalIncrement.gridx = 1;
        gbc_bitSortVerticalIncrement.gridy = 1;
        this.bitSortPanel.add((Component)this.bitSortVerticalInterval, gbc_bitSortVerticalIncrement);
        this.lblVerticalIncrement = new JLabel("Vertical Increment:");
        GridBagConstraints gbc_lblVerticalIncrement = new GridBagConstraints();
        gbc_lblVerticalIncrement.insets = new Insets(0, 0, 5, 5);
        gbc_lblVerticalIncrement.anchor = 17;
        gbc_lblVerticalIncrement.gridx = 0;
        gbc_lblVerticalIncrement.gridy = 2;
        this.bitSortPanel.add((Component)this.lblVerticalIncrement, gbc_lblVerticalIncrement);
        this.bitSortHorizontalInterval = new JSlider();
        this.bitSortHorizontalInterval.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.bitSortHorizontalInterval);
            }
        });
        this.bitSortHorizontalInterval.setValue(0);
        this.bitSortHorizontalInterval.setMinimum(-100);
        GridBagConstraints gbc_bitSortHorizontalIncrement = new GridBagConstraints();
        gbc_bitSortHorizontalIncrement.insets = new Insets(0, 0, 5, 0);
        gbc_bitSortHorizontalIncrement.gridx = 1;
        gbc_bitSortHorizontalIncrement.gridy = 2;
        this.bitSortPanel.add((Component)this.bitSortHorizontalInterval, gbc_bitSortHorizontalIncrement);
        GridBagLayout gbl_verticalPixelSortPanel = new GridBagLayout();
        gbl_verticalPixelSortPanel.columnWidths = new int[]{0, 0, 0};
        gbl_verticalPixelSortPanel.rowHeights = new int[]{0, 0};
        gbl_verticalPixelSortPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_verticalPixelSortPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.verticalPixelSortPanel.setLayout(gbl_verticalPixelSortPanel);
        this.lblInterval = new JLabel("Interval:");
        GridBagConstraints gbc_lblInterval = new GridBagConstraints();
        gbc_lblInterval.insets = new Insets(0, 0, 0, 5);
        gbc_lblInterval.gridx = 0;
        gbc_lblInterval.gridy = 0;
        this.verticalPixelSortPanel.add((Component)this.lblInterval, gbc_lblInterval);
        this.verticalInterval = new JSlider();
        this.verticalInterval.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.verticalInterval);
            }
        });
        this.verticalInterval.setValue(75);
        this.verticalInterval.setMaximum(150);
        this.verticalInterval.setMinimum(1);
        GridBagConstraints gbc_verticalInterval = new GridBagConstraints();
        gbc_verticalInterval.gridx = 1;
        gbc_verticalInterval.gridy = 0;
        this.verticalPixelSortPanel.add((Component)this.verticalInterval, gbc_verticalInterval);
        GridBagLayout gbl_offsetSortPanel = new GridBagLayout();
        gbl_offsetSortPanel.columnWidths = new int[]{0, 0, 0};
        gbl_offsetSortPanel.rowHeights = new int[]{0, 0, 0, 0};
        gbl_offsetSortPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_offsetSortPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.offsetSortPanel.setLayout(gbl_offsetSortPanel);
        this.lblDistortionAmount_2 = new JLabel("Distortion Amount:");
        GridBagConstraints gbc_lblDistortionAmount_2 = new GridBagConstraints();
        gbc_lblDistortionAmount_2.anchor = 17;
        gbc_lblDistortionAmount_2.insets = new Insets(0, 0, 5, 5);
        gbc_lblDistortionAmount_2.gridx = 0;
        gbc_lblDistortionAmount_2.gridy = 0;
        this.offsetSortPanel.add((Component)this.lblDistortionAmount_2, gbc_lblDistortionAmount_2);
        this.offsetDistortionAmount = new JSlider();
        this.offsetDistortionAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.offsetDistortionAmount);
            }
        });
        this.offsetDistortionAmount.setValue(6);
        this.offsetDistortionAmount.setMaximum(10);
        this.offsetDistortionAmount.setMinimum(1);
        GridBagConstraints gbc_offsetDistortionAmount = new GridBagConstraints();
        gbc_offsetDistortionAmount.anchor = 17;
        gbc_offsetDistortionAmount.insets = new Insets(0, 0, 5, 0);
        gbc_offsetDistortionAmount.gridx = 1;
        gbc_offsetDistortionAmount.gridy = 0;
        this.offsetSortPanel.add((Component)this.offsetDistortionAmount, gbc_offsetDistortionAmount);
        this.lblDistortionBrightness = new JLabel("Distortion Brightness:");
        GridBagConstraints gbc_lblDistortionBrightness = new GridBagConstraints();
        gbc_lblDistortionBrightness.anchor = 17;
        gbc_lblDistortionBrightness.insets = new Insets(0, 0, 5, 5);
        gbc_lblDistortionBrightness.gridx = 0;
        gbc_lblDistortionBrightness.gridy = 1;
        this.offsetSortPanel.add((Component)this.lblDistortionBrightness, gbc_lblDistortionBrightness);
        this.offsetBrightness = new JSlider();
        this.offsetBrightness.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.offsetBrightness);
            }
        });
        this.offsetBrightness.setValue(5);
        this.offsetBrightness.setMaximum(10);
        this.offsetBrightness.setMinimum(1);
        GridBagConstraints gbc_offsetBrightness = new GridBagConstraints();
        gbc_offsetBrightness.anchor = 17;
        gbc_offsetBrightness.insets = new Insets(0, 0, 5, 0);
        gbc_offsetBrightness.gridx = 1;
        gbc_offsetBrightness.gridy = 1;
        this.offsetSortPanel.add((Component)this.offsetBrightness, gbc_offsetBrightness);
        this.lblScanlines = new JLabel("Scanlines:");
        GridBagConstraints gbc_lblScanlines = new GridBagConstraints();
        gbc_lblScanlines.anchor = 17;
        gbc_lblScanlines.insets = new Insets(0, 0, 0, 5);
        gbc_lblScanlines.gridx = 0;
        gbc_lblScanlines.gridy = 2;
        this.offsetSortPanel.add((Component)this.lblScanlines, gbc_lblScanlines);
        this.offsetScanLines = new JComboBox();
        this.offsetScanLines.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.offsetScanLines);
            }
        });
        this.offsetScanLines.setModel(new DefaultComboBoxModel<String>(new String[]{"NO", "YES"}));
        GridBagConstraints gbc_offsetScanLines = new GridBagConstraints();
        gbc_offsetScanLines.anchor = 17;
        gbc_offsetScanLines.gridx = 1;
        gbc_offsetScanLines.gridy = 2;
        this.offsetSortPanel.add((Component)this.offsetScanLines, gbc_offsetScanLines);
        GridBagLayout gbl_brightnessPanel = new GridBagLayout();
        gbl_brightnessPanel.columnWidths = new int[]{0, 0, 0};
        gbl_brightnessPanel.rowHeights = new int[]{0, 0};
        gbl_brightnessPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_brightnessPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.brightnessPanel.setLayout(gbl_brightnessPanel);
        this.lblBrightness = new JLabel("Brightness:");
        GridBagConstraints gbc_lblBrightness = new GridBagConstraints();
        gbc_lblBrightness.anchor = 17;
        gbc_lblBrightness.insets = new Insets(0, 0, 0, 5);
        gbc_lblBrightness.gridx = 0;
        gbc_lblBrightness.gridy = 0;
        this.brightnessPanel.add((Component)this.lblBrightness, gbc_lblBrightness);
        this.brightnessSlider = new JSlider();
        this.brightnessSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.brightnessSlider);
            }
        });
        this.brightnessSlider.setMaximum(10);
        this.brightnessSlider.setValue(0);
        this.brightnessSlider.setMinimum(-10);
        GridBagConstraints gbc_brightnessSlider = new GridBagConstraints();
        gbc_brightnessSlider.gridx = 1;
        gbc_brightnessSlider.gridy = 0;
        this.brightnessPanel.add((Component)this.brightnessSlider, gbc_brightnessSlider);
        GridBagLayout gbl_rgbShiftPanel = new GridBagLayout();
        gbl_rgbShiftPanel.columnWidths = new int[]{0, 0, 0};
        gbl_rgbShiftPanel.rowHeights = new int[]{0, 0, 0};
        gbl_rgbShiftPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_rgbShiftPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.rgbShiftPanel.setLayout(gbl_rgbShiftPanel);
        this.lblEffect = new JLabel("Effect:");
        GridBagConstraints gbc_lblEffect = new GridBagConstraints();
        gbc_lblEffect.insets = new Insets(0, 0, 5, 5);
        gbc_lblEffect.anchor = 17;
        gbc_lblEffect.gridx = 0;
        gbc_lblEffect.gridy = 0;
        this.rgbShiftPanel.add((Component)this.lblEffect, gbc_lblEffect);
        this.rgbShiftColor = new JComboBox();
        this.rgbShiftColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.rgbShiftColor);
            }
        });
        this.rgbShiftColor.setModel(new DefaultComboBoxModel<String>(new String[]{"RED", "GREEN", "BLUE", "VIBRANCE"}));
        GridBagConstraints gbc_rgbShiftColor = new GridBagConstraints();
        gbc_rgbShiftColor.insets = new Insets(0, 0, 5, 0);
        gbc_rgbShiftColor.fill = 2;
        gbc_rgbShiftColor.gridx = 1;
        gbc_rgbShiftColor.gridy = 0;
        this.rgbShiftPanel.add((Component)this.rgbShiftColor, gbc_rgbShiftColor);
        this.lblShiftAmount = new JLabel("Shift Amount:");
        GridBagConstraints gbc_lblShiftAmount = new GridBagConstraints();
        gbc_lblShiftAmount.anchor = 17;
        gbc_lblShiftAmount.insets = new Insets(0, 0, 0, 5);
        gbc_lblShiftAmount.gridx = 0;
        gbc_lblShiftAmount.gridy = 1;
        this.rgbShiftPanel.add((Component)this.lblShiftAmount, gbc_lblShiftAmount);
        this.rgbShiftAmount = new JSlider();
        this.rgbShiftAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.rgbShiftAmount);
            }
        });
        this.rgbShiftAmount.setValue(5);
        this.rgbShiftAmount.setMinimum(1);
        GridBagConstraints gbc_rgbShiftAmount = new GridBagConstraints();
        gbc_rgbShiftAmount.anchor = 17;
        gbc_rgbShiftAmount.gridx = 1;
        gbc_rgbShiftAmount.gridy = 1;
        this.rgbShiftPanel.add((Component)this.rgbShiftAmount, gbc_rgbShiftAmount);
        GridBagLayout gbl_dataAsSoundPanel = new GridBagLayout();
        gbl_dataAsSoundPanel.columnWidths = new int[]{0, 0, 0};
        gbl_dataAsSoundPanel.rowHeights = new int[]{0, 0};
        gbl_dataAsSoundPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_dataAsSoundPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.dataAsSoundPanel.setLayout(gbl_dataAsSoundPanel);
        this.lblBitrateDistort = new JLabel("Bitrate Distort:");
        GridBagConstraints gbc_lblBitrateDistort = new GridBagConstraints();
        gbc_lblBitrateDistort.anchor = 17;
        gbc_lblBitrateDistort.insets = new Insets(0, 0, 0, 5);
        gbc_lblBitrateDistort.gridx = 0;
        gbc_lblBitrateDistort.gridy = 0;
        this.dataAsSoundPanel.add((Component)this.lblBitrateDistort, gbc_lblBitrateDistort);
        this.dataAsSoundBitRate = new JSlider();
        this.dataAsSoundBitRate.setInverted(true);
        this.dataAsSoundBitRate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.dataAsSoundBitRate);
            }
        });
        this.dataAsSoundBitRate.setMaximum(9);
        this.dataAsSoundBitRate.setMinimum(1);
        this.dataAsSoundBitRate.setValue(5);
        GridBagConstraints gbc_dataAsSoundBitRate = new GridBagConstraints();
        gbc_dataAsSoundBitRate.gridx = 1;
        gbc_dataAsSoundBitRate.gridy = 0;
        this.dataAsSoundPanel.add((Component)this.dataAsSoundBitRate, gbc_dataAsSoundBitRate);
        GridBagLayout gbl_randomPixelPanel = new GridBagLayout();
        gbl_randomPixelPanel.columnWidths = new int[]{0, 0, 0};
        gbl_randomPixelPanel.rowHeights = new int[]{0, 0, 0};
        gbl_randomPixelPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_randomPixelPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.randomPixelPanel.setLayout(gbl_randomPixelPanel);
        this.lblRandomization = new JLabel("Randomization:");
        GridBagConstraints gbc_lblRandomization = new GridBagConstraints();
        gbc_lblRandomization.anchor = 17;
        gbc_lblRandomization.insets = new Insets(0, 0, 5, 5);
        gbc_lblRandomization.gridx = 0;
        gbc_lblRandomization.gridy = 0;
        this.randomPixelPanel.add((Component)this.lblRandomization, gbc_lblRandomization);
        this.randomRandomization = new JSlider();
        this.randomRandomization.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.randomRandomization);
            }
        });
        this.randomRandomization.setMinimum(5);
        GridBagConstraints gbc_randomRandomization = new GridBagConstraints();
        gbc_randomRandomization.insets = new Insets(0, 0, 5, 0);
        gbc_randomRandomization.gridx = 1;
        gbc_randomRandomization.gridy = 0;
        this.randomPixelPanel.add((Component)this.randomRandomization, gbc_randomRandomization);
        this.lblNewLabel = new JLabel("Distortion Amount:");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 1;
        this.randomPixelPanel.add((Component)this.lblNewLabel, gbc_lblNewLabel);
        this.randomDistortionAmount = new JSlider();
        this.randomDistortionAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.randomDistortionAmount);
            }
        });
        this.randomDistortionAmount.setMinimum(1);
        GridBagConstraints gbc_randomDistortionAmount = new GridBagConstraints();
        gbc_randomDistortionAmount.gridx = 1;
        gbc_randomDistortionAmount.gridy = 1;
        this.randomPixelPanel.add((Component)this.randomDistortionAmount, gbc_randomDistortionAmount);
        GridBagLayout gbl_pixelSlicePanel = new GridBagLayout();
        gbl_pixelSlicePanel.columnWidths = new int[]{0, 0, 0};
        gbl_pixelSlicePanel.rowHeights = new int[]{0, 0};
        gbl_pixelSlicePanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_pixelSlicePanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.pixelSlicePanel.setLayout(gbl_pixelSlicePanel);
        this.lblDistortionAmount_1 = new JLabel("Distortion Amount:");
        GridBagConstraints gbc_lblDistortionAmount_1 = new GridBagConstraints();
        gbc_lblDistortionAmount_1.anchor = 17;
        gbc_lblDistortionAmount_1.insets = new Insets(0, 0, 0, 5);
        gbc_lblDistortionAmount_1.gridx = 0;
        gbc_lblDistortionAmount_1.gridy = 0;
        this.pixelSlicePanel.add((Component)this.lblDistortionAmount_1, gbc_lblDistortionAmount_1);
        this.pixelSliceAmount = new JSlider();
        this.pixelSliceAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.pixelSliceAmount);
            }
        });
        this.pixelSliceAmount.setMaximum(9);
        this.pixelSliceAmount.setMinimum(1);
        this.pixelSliceAmount.setValue(6);
        GridBagConstraints gbc_pixelSliceAmount = new GridBagConstraints();
        gbc_pixelSliceAmount.gridx = 1;
        gbc_pixelSliceAmount.gridy = 0;
        this.pixelSlicePanel.add((Component)this.pixelSliceAmount, gbc_pixelSliceAmount);
        GridBagLayout gbl_fractalSortPanel = new GridBagLayout();
        gbl_fractalSortPanel.columnWidths = new int[]{0, 0, 0};
        gbl_fractalSortPanel.rowHeights = new int[]{0, 0};
        gbl_fractalSortPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_fractalSortPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.fractalSortPanel.setLayout(gbl_fractalSortPanel);
        this.lblDistortionAmount = new JLabel("Distortion Amount:");
        GridBagConstraints gbc_lblDistortionAmount = new GridBagConstraints();
        gbc_lblDistortionAmount.anchor = 17;
        gbc_lblDistortionAmount.insets = new Insets(0, 0, 0, 5);
        gbc_lblDistortionAmount.gridx = 0;
        gbc_lblDistortionAmount.gridy = 0;
        this.fractalSortPanel.add((Component)this.lblDistortionAmount, gbc_lblDistortionAmount);
        this.fractalSortDistortionAmount = new JSlider();
        this.fractalSortDistortionAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.fractalSortDistortionAmount);
            }
        });
        this.fractalSortDistortionAmount.setMaximum(12);
        this.fractalSortDistortionAmount.setMinimum(2);
        this.fractalSortDistortionAmount.setValue(6);
        GridBagConstraints gbc_fractalSortDistortionAmount = new GridBagConstraints();
        gbc_fractalSortDistortionAmount.gridx = 1;
        gbc_fractalSortDistortionAmount.gridy = 0;
        this.fractalSortPanel.add((Component)this.fractalSortDistortionAmount, gbc_fractalSortDistortionAmount);
        GridBagLayout gbl_pixelSortPanel = new GridBagLayout();
        gbl_pixelSortPanel.columnWidths = new int[]{0, 0, 0};
        gbl_pixelSortPanel.rowHeights = new int[]{0, 0, 0};
        gbl_pixelSortPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_pixelSortPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.pixelSortPanel.setLayout(gbl_pixelSortPanel);
        this.lblDistortion = new JLabel("Distortion:");
        GridBagConstraints gbc_lblDistortion = new GridBagConstraints();
        gbc_lblDistortion.anchor = 17;
        gbc_lblDistortion.insets = new Insets(0, 0, 5, 5);
        gbc_lblDistortion.gridx = 0;
        gbc_lblDistortion.gridy = 0;
        this.pixelSortPanel.add((Component)this.lblDistortion, gbc_lblDistortion);
        this.pixelSortBrightness = new JSlider();
        this.pixelSortBrightness.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.pixelSortBrightness);
            }
        });
        this.pixelSortBrightness.setMinimum(1);
        GridBagConstraints gbc_pixelSortBrightness = new GridBagConstraints();
        gbc_pixelSortBrightness.insets = new Insets(0, 0, 5, 0);
        gbc_pixelSortBrightness.gridx = 1;
        gbc_pixelSortBrightness.gridy = 0;
        this.pixelSortPanel.add((Component)this.pixelSortBrightness, gbc_pixelSortBrightness);
        this.lblDistortionLength = new JLabel("Distortion Length:");
        GridBagConstraints gbc_lblDistortionLength = new GridBagConstraints();
        gbc_lblDistortionLength.insets = new Insets(0, 0, 0, 5);
        gbc_lblDistortionLength.gridx = 0;
        gbc_lblDistortionLength.gridy = 1;
        this.pixelSortPanel.add((Component)this.lblDistortionLength, gbc_lblDistortionLength);
        this.pixelSortLength = new JSlider();
        this.pixelSortLength.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlitchArt.this.glitchUIManager.changeSliderValue(GlitchArt.this.pixelSortLength);
            }
        });
        this.pixelSortLength.setValue(5);
        this.pixelSortLength.setMaximum(10);
        this.pixelSortLength.setMinimum(1);
        GridBagConstraints gbc_pixelSortLength = new GridBagConstraints();
        gbc_pixelSortLength.gridx = 1;
        gbc_pixelSortLength.gridy = 1;
        this.pixelSortPanel.add((Component)this.pixelSortLength, gbc_pixelSortLength);
        this.layeredPane.setLayout(gl_layeredPane);
        this.contentPane.setLayout(gl_contentPane);
    }
}

