/*
 * Decompiled with CFR 0.152.
 */
package io.laniakia.ui;

import io.laniakia.ui.GlitchArt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class StretchIcon
extends ImageIcon {
    private GlitchArt glitchArt;
    private static final long serialVersionUID = 1L;
    protected boolean proportionate = true;

    public StretchIcon(byte[] imageData) {
        super(imageData);
    }

    public StretchIcon(byte[] imageData, boolean proportionate) {
        super(imageData);
        this.proportionate = proportionate;
    }

    public StretchIcon(byte[] imageData, String description) {
        super(imageData, description);
    }

    public StretchIcon(byte[] imageData, String description, boolean proportionate) {
        super(imageData, description);
        this.proportionate = proportionate;
    }

    public StretchIcon(Image image) {
        super(image);
    }

    public StretchIcon(Image image, GlitchArt glitchArt) {
        super(image);
        this.glitchArt = glitchArt;
        this.glitchArt.realHeight = ((BufferedImage)image).getHeight();
        this.glitchArt.realWidth = ((BufferedImage)image).getWidth();
    }

    public StretchIcon(Image image, boolean proportionate) {
        super(image);
        this.proportionate = proportionate;
    }

    public StretchIcon(Image image, String description) {
        super(image, description);
    }

    public StretchIcon(Image image, String description, boolean proportionate) {
        super(image, description);
        this.proportionate = proportionate;
    }

    public StretchIcon(String filename) {
        super(filename);
    }

    public StretchIcon(String filename, boolean proportionate) {
        super(filename);
        this.proportionate = proportionate;
    }

    public StretchIcon(String filename, String description) {
        super(filename, description);
    }

    public StretchIcon(String filename, String description, boolean proportionate) {
        super(filename, description);
        this.proportionate = proportionate;
    }

    public StretchIcon(URL location) {
        super(location);
    }

    public StretchIcon(URL location, boolean proportionate) {
        super(location);
        this.proportionate = proportionate;
    }

    public StretchIcon(URL location, String description) {
        super(location, description);
    }

    public StretchIcon(URL location, String description, boolean proportionate) {
        super(location, description);
        this.proportionate = proportionate;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        Image image = this.getImage();
        if (image == null) {
            return;
        }
        Insets insets = ((Container)c).getInsets();
        x = insets.left;
        y = insets.top;
        int w = c.getWidth() - x - insets.right;
        int h = c.getHeight() - y - insets.bottom;
        this.glitchArt.lblImageRender.setSize(w, h);
        if (this.proportionate && w >= 510) {
            int ih;
            int iw = image.getWidth(c);
            if (iw * h < (ih = image.getHeight(c)) * w) {
                iw = h * iw / ih;
                x += (w - iw) / 2;
                w = iw;
            } else {
                ih = w * ih / iw;
                y += (h - ih) / 2;
                h = ih;
            }
        }
        ImageObserver io = this.getImageObserver();
        this.glitchArt.resizedHeight = h;
        this.glitchArt.resizedWidth = w;
        this.glitchArt.lblImageRender.setSize(w, h);
        BufferedImage bi = new BufferedImage(w, h, 6);
        Graphics2D g2d = bi.createGraphics();
        g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2d.drawImage(image, 0, 0, w, h, io == null ? c : io);
        g2d.dispose();
        g.drawImage(bi, x, y, w, h, io == null ? c : io);
    }

    @Override
    public int getIconWidth() {
        return 0;
    }

    @Override
    public int getIconHeight() {
        return 0;
    }
}

