/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import com.google.common.collect.ImmutableMap;
import io.linguarobot.aws.cdk.Artifact;
import io.linguarobot.aws.cdk.ArtifactType;
import io.linguarobot.aws.cdk.AssetMetadata;
import io.linguarobot.aws.cdk.CloudManifest;
import io.linguarobot.aws.cdk.MetadataType;
import io.linguarobot.aws.cdk.StackArtifact;
import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.ParameterDefinition;
import io.linguarobot.aws.cdk.maven.StackDefinition;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class CloudDefinition {
    private final List<StackDefinition> stacks;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JSR353Module());

    private CloudDefinition(List<StackDefinition> stacks) {
        this.stacks = stacks;
    }

    @Nonnull
    public List<StackDefinition> getStacks() {
        return this.stacks;
    }

    public String toString() {
        return "CloudDefinition{stacks=" + this.stacks + '}';
    }

    public static CloudDefinition create(Path cloudAssemblyDirectory) {
        CloudManifest manifest;
        try {
            manifest = CloudManifest.create((Path)cloudAssemblyDirectory);
        }
        catch (IOException e) {
            throw new CdkPluginException("Failed to read the cloud manifest", e);
        }
        return manifest.getArtifacts().entrySet().stream().filter(artifact -> ((Artifact)artifact.getValue()).getType() == ArtifactType.STACK).map(artifact -> {
            String artifactId = (String)artifact.getKey();
            StackArtifact stackArtifact = (StackArtifact)artifact.getValue();
            String stackName = (String)ObjectUtils.firstNonNull((Object[])new String[]{stackArtifact.getProperties().getStackName(), artifactId});
            Path templateFile = cloudAssemblyDirectory.resolve(stackArtifact.getProperties().getTemplateFile());
            Integer requiredToolkitStackVersion = Optional.ofNullable(stackArtifact.getProperties().getRequiredToolkitStackVersion()).map(Number::intValue).orElse(null);
            Map<String, Object> template = CloudDefinition.readTemplate(templateFile);
            Map<String, ParameterDefinition> parameters = CloudDefinition.getParameterDefinitions(template);
            List<AssetMetadata> assets = stackArtifact.getMetadata().values().stream().flatMap(Collection::stream).filter(metadata -> metadata.getType() == MetadataType.ASSET).map(metadata -> (AssetMetadata)metadata).collect(Collectors.toList());
            Map resources = (Map)template.getOrDefault("Resources", ImmutableMap.of());
            return StackDefinition.builder().withStackName(stackName).withTemplateFile(templateFile).withEnvironment(stackArtifact.getEnvironment()).withRequiredToolkitStackVersion(requiredToolkitStackVersion).withParameters(parameters).withParameterValues(stackArtifact.getProperties().getParameters()).withAssets(assets).withResources(resources).build();
        }).collect(Collectors.collectingAndThen(Collectors.toList(), stacks -> new CloudDefinition(Collections.unmodifiableList(stacks))));
    }

    private static Map<String, Object> readTemplate(Path template) {
        try {
            return (Map)OBJECT_MAPPER.readValue(template.toFile(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new CdkPluginException("Failed to read the stack template: " + template);
        }
    }

    private static Map<String, ParameterDefinition> getParameterDefinitions(Map<String, Object> template) {
        Map parameters = template.getOrDefault("Parameters", Collections.emptyMap());
        return parameters.entrySet().stream().map(parameter -> {
            String name = (String)parameter.getKey();
            String defaultValue = (String)((Map)parameter.getValue()).get("Default");
            return new ParameterDefinition(name, defaultValue);
        }).collect(Collectors.toMap(ParameterDefinition::getName, Function.identity()));
    }
}

