/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import io.linguarobot.aws.cdk.maven.AbstractCdkMojo;
import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.CloudDefinition;
import io.linguarobot.aws.cdk.maven.DockerImageAssetPublisher;
import io.linguarobot.aws.cdk.maven.EnvironmentResolver;
import io.linguarobot.aws.cdk.maven.FileAssetPublisher;
import io.linguarobot.aws.cdk.maven.ResolvedEnvironment;
import io.linguarobot.aws.cdk.maven.StackDefinition;
import io.linguarobot.aws.cdk.maven.StackDeployer;
import io.linguarobot.aws.cdk.maven.ToolkitConfiguration;
import io.linguarobot.aws.cdk.maven.process.DefaultProcessRunner;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractCdkMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="CDKToolkit")
    private String toolkitStackName;

    @Override
    public void execute(Path cloudAssemblyDirectory, EnvironmentResolver environmentResolver) {
        if (!Files.exists(cloudAssemblyDirectory, new LinkOption[0])) {
            throw new CdkPluginException("The cloud assembly directory " + cloudAssemblyDirectory + " doesn't exist. Did you forget to add 'synth' goal to the execution?");
        }
        CloudDefinition cloudDefinition = CloudDefinition.create(cloudAssemblyDirectory);
        Map<String, List<StackDefinition>> stacks = cloudDefinition.getStacks().stream().collect(Collectors.groupingBy(StackDefinition::getEnvironment));
        DefaultProcessRunner processRunner = new DefaultProcessRunner(this.project.getBasedir());
        stacks.forEach((environment, environmentStacks) -> {
            ResolvedEnvironment resolvedEnvironment = environmentResolver.resolve((String)environment);
            DockerImageAssetPublisher dockerImagePublisher = new DockerImageAssetPublisher(resolvedEnvironment, processRunner);
            FileAssetPublisher filePublisher = new FileAssetPublisher(resolvedEnvironment);
            ToolkitConfiguration toolkitConfiguration = new ToolkitConfiguration(this.toolkitStackName);
            StackDeployer stackDeployer = new StackDeployer(cloudAssemblyDirectory, resolvedEnvironment, toolkitConfiguration, filePublisher, dockerImagePublisher);
            environmentStacks.forEach(stack -> {
                if (!stack.getResources().isEmpty()) {
                    stackDeployer.deploy((StackDefinition)stack);
                } else {
                    stackDeployer.destroy((StackDefinition)stack);
                }
            });
        });
    }
}

