/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.linguarobot.aws.cdk.maven.text.Ansi;
import io.linguarobot.aws.cdk.maven.text.table.Cell;
import io.linguarobot.aws.cdk.maven.text.table.Column;
import io.linguarobot.aws.cdk.maven.text.table.TableWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;

public class LoggingStackEventListener
implements Consumer<StackEvent> {
    private static final Set<ResourceStatus> FAILED_RESOURCE_STATUSES = ImmutableSet.of((Object)ResourceStatus.CREATE_FAILED, (Object)ResourceStatus.DELETE_FAILED, (Object)ResourceStatus.UPDATE_FAILED, (Object)ResourceStatus.IMPORT_FAILED, (Object)ResourceStatus.IMPORT_ROLLBACK_FAILED, (Object)ResourceStatus.UNKNOWN_TO_SDK_VERSION, (Object[])new ResourceStatus[0]);
    private static final Set<ResourceStatus> IN_PROGRESS_STATUSES = ImmutableSet.of((Object)ResourceStatus.CREATE_IN_PROGRESS, (Object)ResourceStatus.DELETE_IN_PROGRESS, (Object)ResourceStatus.UPDATE_IN_PROGRESS, (Object)ResourceStatus.IMPORT_IN_PROGRESS, (Object)ResourceStatus.IMPORT_ROLLBACK_IN_PROGRESS);
    private static final Logger logger = LoggerFactory.getLogger(LoggingStackEventListener.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final List<Column> COLUMNS = ImmutableList.of((Object)Column.of("Timestamp", 20, new Ansi.Parameter[0]), (Object)Column.of("Logical ID", 32, new Ansi.Parameter[0]), (Object)Column.of("Status", 32, new Ansi.Parameter[0]), (Object)Column.of("Status Reason", 64, new Ansi.Parameter[0]));
    private final TableWriter tableWriter = TableWriter.of(line -> logger.info(line.trim()), COLUMNS);

    @Override
    public void accept(StackEvent event) {
        Ansi.Color color = IN_PROGRESS_STATUSES.contains(event.resourceStatus()) ? Ansi.Color.BLUE : (FAILED_RESOURCE_STATUSES.contains(event.resourceStatus()) ? Ansi.Color.RED : Ansi.Color.GREEN);
        Cell statusReason = Optional.ofNullable(event.resourceStatusReason()).map(reason -> Cell.of(reason, color)).orElse(Cell.blank());
        ImmutableList row = ImmutableList.of((Object)Cell.of(ZonedDateTime.from(event.timestamp().atZone(ZoneId.systemDefault())).format(DATE_TIME_FORMATTER), new Ansi.Parameter[0]), (Object)Cell.of(event.logicalResourceId(), new Ansi.Parameter[0]), (Object)Cell.of(event.resourceStatusAsString(), color), (Object)statusReason);
        this.tableWriter.print((List<Cell>)row);
    }
}

