/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.linguarobot.aws.cdk.CloudManifest;
import io.linguarobot.aws.cdk.maven.AbstractCdkMojo;
import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.DeployMojo;
import io.linguarobot.aws.cdk.maven.EnvironmentResolver;
import io.linguarobot.aws.cdk.maven.ResolvedEnvironment;
import io.linguarobot.aws.cdk.maven.context.AmiContextProvider;
import io.linguarobot.aws.cdk.maven.context.AvailabilityZonesContextProvider;
import io.linguarobot.aws.cdk.maven.context.AwsClientProvider;
import io.linguarobot.aws.cdk.maven.context.AwsClientProviderBuilder;
import io.linguarobot.aws.cdk.maven.context.ContextProvider;
import io.linguarobot.aws.cdk.maven.context.HostedZoneContextProvider;
import io.linguarobot.aws.cdk.maven.context.SsmContextProvider;
import io.linguarobot.aws.cdk.maven.context.VpcNetworkContextProvider;
import io.linguarobot.aws.cdk.maven.node.AbstractNodeInstaller;
import io.linguarobot.aws.cdk.maven.node.LinuxNodeInstaller;
import io.linguarobot.aws.cdk.maven.node.NodeClient;
import io.linguarobot.aws.cdk.maven.node.NodeInstallationException;
import io.linguarobot.aws.cdk.maven.node.NodeInstaller;
import io.linguarobot.aws.cdk.maven.node.NodeVersion;
import io.linguarobot.aws.cdk.maven.node.UnixNodeInstaller;
import io.linguarobot.aws.cdk.maven.node.WindowsNodeInstaller;
import io.linguarobot.aws.cdk.maven.process.DefaultProcessRunner;
import io.linguarobot.aws.cdk.maven.process.ProcessContext;
import io.linguarobot.aws.cdk.maven.process.ProcessExecutionException;
import io.linguarobot.aws.cdk.maven.process.ProcessRunner;
import io.linguarobot.aws.cdk.maven.runtime.Synthesizer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.Route53ClientBuilder;
import software.amazon.awssdk.services.ssm.SsmClient;

@Mojo(name="synth", instantiationStrategy=InstantiationStrategy.PER_LOOKUP, defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SynthMojo
extends AbstractCdkMojo
implements ContextEnabled {
    private static final Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    private static final String CDK_CONTEXT_FILE_NAME = "cdk.context.json";
    private static final NodeVersion MINIMUM_REQUIRED_NODE_VERSION = NodeVersion.of(10, 3, 0);
    private static final NodeVersion INSTALLED_NODE_VERSION = NodeVersion.of(12, 17, 0);
    private static final String OUTPUT_DIRECTORY_VARIABLE_NAME = "CDK_OUTDIR";
    private static final String DEFAULT_ACCOUNT_VARIABLE_NAME = "CDK_DEFAULT_ACCOUNT";
    private static final String DEFAULT_REGION_VARIABLE_NAME = "CDK_DEFAULT_REGION";
    private static final String CONTEXT_VARIABLE_NAME = "CDK_CONTEXT_JSON";
    private static final String PATH_VARIABLE_NAME = "PATH";
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${settings.localRepository}", readonly=true)
    private File localRepositoryDirectory;
    @Parameter(required=true)
    private String app;
    private ProcessRunner processRunner;
    private Map<String, ContextProvider> contextProviders;

    @Override
    public void execute(Path cloudAssemblyDirectory, EnvironmentResolver environmentResolver) {
        this.processRunner = new DefaultProcessRunner(this.project.getBasedir());
        this.contextProviders = this.initContextProviders(environmentResolver);
        this.synthesize(this.app, cloudAssemblyDirectory, environmentResolver);
    }

    private Map<String, ContextProvider> initContextProviders(EnvironmentResolver environmentResolver) {
        AwsClientProvider awsClientProvider = new AwsClientProviderBuilder().withClientFactory(Ec2Client.class, env -> (Ec2Client)this.buildClient(Ec2Client.builder(), environmentResolver.resolve((String)env))).withClientFactory(SsmClient.class, env -> (SsmClient)this.buildClient(SsmClient.builder(), environmentResolver.resolve((String)env))).withClientFactory(Route53Client.class, env -> {
            ResolvedEnvironment resolvedEnvironment = environmentResolver.resolve((String)env);
            return (Route53Client)((Route53ClientBuilder)((Route53ClientBuilder)Route53Client.builder().region(Region.AWS_GLOBAL)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)resolvedEnvironment.getCredentials()))).build();
        }).build();
        HashMap<String, ContextProvider> contextProviders = new HashMap<String, ContextProvider>();
        contextProviders.put("availability-zones", new AvailabilityZonesContextProvider(awsClientProvider));
        contextProviders.put("ssm", new SsmContextProvider(awsClientProvider));
        contextProviders.put("hosted-zone", new HostedZoneContextProvider(awsClientProvider));
        contextProviders.put("vpc-provider", new VpcNetworkContextProvider(awsClientProvider));
        contextProviders.put("ami", new AmiContextProvider(awsClientProvider));
        return contextProviders;
    }

    private <B extends AwsClientBuilder<B, C>, C> C buildClient(B builder, ResolvedEnvironment environment) {
        return (C)builder.region(environment.getRegion()).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)environment.getCredentials())).build();
    }

    protected CloudManifest synthesize(String app, Path outputDirectory, EnvironmentResolver environmentResolver) {
        Map<String, String> environment = SystemUtils.IS_OS_WINDOWS ? System.getenv().entrySet().stream().map(variable -> Pair.of((Object)((String)variable.getKey()).toUpperCase(), variable.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : new HashMap<String, String>(System.getenv());
        NodeVersion nodeVersion = this.getInstalledNodeVersion().orElse(null);
        if (nodeVersion == null || nodeVersion.compareTo(MINIMUM_REQUIRED_NODE_VERSION) < 0) {
            if (nodeVersion == null) {
                logger.info("Node.js is not installed. Using the Node.js from the local Maven repository");
            } else {
                logger.info("The minimum required version of Node.js is {}, however {} is installed. Using the Node.js from the local Maven repository", (Object)MINIMUM_REQUIRED_NODE_VERSION, (Object)nodeVersion);
            }
            NodeClient node = this.getNodeInstaller().install(INSTALLED_NODE_VERSION);
            environment.compute(PATH_VARIABLE_NAME, (name, path) -> Stream.of(node.getPath().toString(), path).filter(Objects::nonNull).collect(Collectors.joining(File.pathSeparator)));
        }
        environment.computeIfAbsent(OUTPUT_DIRECTORY_VARIABLE_NAME, v -> outputDirectory.toString());
        environment.computeIfAbsent(DEFAULT_REGION_VARIABLE_NAME, v -> environmentResolver.getDefaultRegion().id());
        if (environmentResolver.getDefaultAccount() != null) {
            environment.computeIfAbsent(DEFAULT_ACCOUNT_VARIABLE_NAME, v -> environmentResolver.getDefaultAccount());
        }
        JsonObject context = this.readContext();
        logger.info("Synthesizing the cloud assembly for the '{}' application", (Object)app);
        CloudManifest cloudManifest = this.synthesize(app, outputDirectory, environment, context);
        while (!cloudManifest.getMissingContexts().isEmpty()) {
            JsonObjectBuilder contextBuilder = Json.createObjectBuilder((JsonObject)context);
            cloudManifest.getMissingContexts().forEach(missingContext -> {
                JsonValue contextValue;
                String provider = missingContext.getProvider();
                String key = missingContext.getKey();
                ContextProvider contextProvider = this.contextProviders.get(provider);
                if (contextProvider == null) {
                    throw new CdkPluginException("Unable to find a context provider for '" + provider + "'. Please consider updating the version of the plugin");
                }
                JsonObject properties = (JsonObject)OBJECT_MAPPER.convertValue((Object)missingContext.getProperties(), JsonObject.class);
                try {
                    contextValue = contextProvider.getContextValue(properties);
                }
                catch (Exception e) {
                    throw new CdkPluginException("An error occurred while resolving context value for the key '" + key + "' using '" + provider + "' provider: " + e.getMessage());
                }
                if (contextValue == null) {
                    throw new CdkPluginException("Unable to resolve context value for the key '" + key + "' using '" + provider + "' provider");
                }
                contextBuilder.add(key, contextValue);
            });
            context = contextBuilder.build();
            cloudManifest = this.synthesize(app, outputDirectory, environment, context);
        }
        if (!context.isEmpty()) {
            JsonWriterFactory writerFactory = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
            File effectiveContextFile = outputDirectory.resolve(CDK_CONTEXT_FILE_NAME).toFile();
            try (JsonWriter jsonWriter = writerFactory.createWriter((Writer)new BufferedWriter(new FileWriter(effectiveContextFile)));){
                jsonWriter.write((JsonStructure)context);
            }
            catch (IOException e) {
                throw new CdkPluginException("Unable to write effective context file to the " + outputDirectory);
            }
        }
        logger.info("The cloud assembly has been successfully synthesized to {}", (Object)outputDirectory);
        return cloudManifest;
    }

    private JsonObject readContext() {
        JsonObject context;
        File contextFile = new File(this.project.getBasedir(), CDK_CONTEXT_FILE_NAME);
        if (contextFile.exists()) {
            try {
                context = (JsonObject)OBJECT_MAPPER.readValue(contextFile, JsonObject.class);
            }
            catch (IOException e) {
                throw new CdkPluginException("Unable to read the runtime context from the " + contextFile);
            }
        } else {
            context = JsonValue.EMPTY_JSON_OBJECT;
        }
        return context;
    }

    private CloudManifest synthesize(String app, Path outputDirectory, Map<String, String> environment, JsonObject context) {
        int exitCode;
        ImmutableMap appEnvironment = context.isEmpty() ? environment : ImmutableMap.builder().putAll(environment).put((Object)CONTEXT_VARIABLE_NAME, (Object)this.toString(context)).build();
        List<String> appExecutionCommand = this.buildAppExecutionCommand(app);
        ProcessContext processContext = ProcessContext.builder().withEnvironment((Map<String, String>)appEnvironment).build();
        try {
            exitCode = this.processRunner.run(appExecutionCommand, processContext);
        }
        catch (ProcessExecutionException e) {
            throw new CdkPluginException("The synthesis has failed", e);
        }
        if (exitCode != 0 || !Files.exists(outputDirectory, new LinkOption[0])) {
            throw new CdkPluginException("The synthesis has failed: the output directory doesn't exist");
        }
        try {
            return CloudManifest.create((Path)outputDirectory);
        }
        catch (IOException e) {
            throw new CdkPluginException("Failed to read the cloud manifest", e);
        }
    }

    private String toString(JsonObject context) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)context);
        }
        catch (JsonProcessingException e) {
            throw new CdkPluginException("Failed to serialize the runtime context", e);
        }
    }

    private List<String> buildAppExecutionCommand(String app) {
        String java = Optional.ofNullable(this.toolchainManager.getToolchainFromBuildContext("jdk", this.session)).map(toolchain -> toolchain.findTool("java")).orElseGet(() -> System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        String classpath = Streams.concat((Stream[])new Stream[]{this.project.getArtifacts().stream().map(Artifact::getFile).map(File::toString), Stream.of(this.project.getBuild().getOutputDirectory()), this.project.getResources().stream().map(FileSet::getDirectory), Stream.of(Synthesizer.class.getProtectionDomain().getCodeSource().getLocation().getFile())}).collect(Collectors.joining(File.pathSeparator));
        return ImmutableList.of((Object)java, (Object)"-cp", (Object)classpath, (Object)Synthesizer.class.getName(), (Object)app);
    }

    private Optional<NodeVersion> getInstalledNodeVersion() {
        try {
            return Optional.of(this.processRunner.run((List<String>)ImmutableList.of((Object)"node", (Object)"--version"))).flatMap(NodeVersion::parse);
        }
        catch (ProcessExecutionException e) {
            return Optional.empty();
        }
    }

    private NodeInstaller getNodeInstaller() {
        AbstractNodeInstaller nodeInstaller;
        String osName = System.getProperty("os.name");
        Path localRepositoryDirectory = this.localRepositoryDirectory.toPath();
        if (osName.startsWith("Windows")) {
            nodeInstaller = new WindowsNodeInstaller(this.processRunner, localRepositoryDirectory);
        } else if (osName.startsWith("Mac")) {
            nodeInstaller = new UnixNodeInstaller(this.processRunner, localRepositoryDirectory, "darwin", "x64");
        } else if (osName.startsWith("SunOS")) {
            nodeInstaller = new UnixNodeInstaller(this.processRunner, localRepositoryDirectory, "sunos", "x64");
        } else if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
            nodeInstaller = new LinuxNodeInstaller(this.processRunner, localRepositoryDirectory);
        } else if (osName.startsWith("AIX")) {
            nodeInstaller = new UnixNodeInstaller(this.processRunner, localRepositoryDirectory, "aix", "ppc64");
        } else {
            throw new NodeInstallationException("The platform is not supported: " + osName);
        }
        return nodeInstaller;
    }

    private Optional<Region> getDefaultRegion(@Nullable String profile) {
        AwsRegionProvider regionProvider = (AwsRegionProvider)Optional.ofNullable(profile).map(profileName -> DefaultAwsRegionProviderChain.builder().profileName(profileName).build()).orElseGet(DefaultAwsRegionProviderChain::new);
        try {
            return Optional.of(regionProvider.getRegion());
        }
        catch (SdkClientException e) {
            return Optional.empty();
        }
    }

    private Optional<AwsCredentials> getDefaultCredentials(@Nullable String profile) {
        AwsCredentialsProvider credentialsProvider = (AwsCredentialsProvider)Optional.ofNullable(profile).map(profileName -> DefaultCredentialsProvider.builder().profileName(profileName).build()).orElseGet(DefaultCredentialsProvider::create);
        try {
            return Optional.of(credentialsProvider.resolveCredentials());
        }
        catch (SdkClientException e) {
            return Optional.empty();
        }
    }
}

