/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import io.linguarobot.aws.cdk.maven.AccountCredentialsProviderChain;
import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.EnvironmentResolver;
import io.linguarobot.aws.cdk.maven.api.AccountCredentialsProvider;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsProfileRegionProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

public abstract class AbstractCdkMojo
extends AbstractMojo {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JSR353Module());
    @Parameter
    private String profile;
    @Parameter(defaultValue="${project.build.directory}/cdk.out")
    private File cloudAssemblyDirectory;

    public void execute() throws MojoExecutionException {
        try {
            this.execute(this.cloudAssemblyDirectory.toPath(), this.createEnvironmentResolver());
        }
        catch (CdkPluginException e) {
            throw new MojoExecutionException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public abstract void execute(Path var1, EnvironmentResolver var2);

    private EnvironmentResolver createEnvironmentResolver() {
        Region defaultRegion = this.getDefaultRegion().orElse(Region.US_EAST_1);
        AwsCredentials defaultCredentials = this.getDefaultCredentials().orElse(null);
        String defaultAccount = defaultCredentials != null ? this.getAccount(defaultRegion, defaultCredentials) : null;
        ArrayList<AccountCredentialsProvider> credentialsProviders = new ArrayList<AccountCredentialsProvider>();
        if (defaultCredentials != null) {
            credentialsProviders.add(accountId -> {
                if (accountId.equals(defaultAccount)) {
                    return Optional.of(defaultCredentials);
                }
                return Optional.empty();
            });
        }
        AccountCredentialsProviderChain credentialsProvider = new AccountCredentialsProviderChain(credentialsProviders);
        return new EnvironmentResolver(defaultRegion, defaultAccount, credentialsProvider);
    }

    private String getAccount(Region region, AwsCredentials credentials) {
        StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(region)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials))).build();
        return stsClient.getCallerIdentity().account();
    }

    private Optional<Region> getDefaultRegion() {
        Object regionProvider = this.profile != null ? new AwsRegionProviderChain(new AwsRegionProvider[]{new AwsProfileRegionProvider(null, this.profile), new DefaultAwsRegionProviderChain()}) : new DefaultAwsRegionProviderChain();
        try {
            return Optional.of(regionProvider.getRegion());
        }
        catch (SdkClientException e) {
            return Optional.empty();
        }
    }

    private Optional<AwsCredentials> getDefaultCredentials() {
        DefaultCredentialsProvider credentialsProvider;
        if (this.profile != null) {
            ProfileCredentialsProvider profileCredentialsProvider = ProfileCredentialsProvider.builder().profileName(this.profile).build();
            credentialsProvider = AwsCredentialsProviderChain.builder().credentialsProviders(new AwsCredentialsProvider[]{profileCredentialsProvider, DefaultCredentialsProvider.create()}).build();
        } else {
            credentialsProvider = DefaultCredentialsProvider.create();
        }
        try {
            return Optional.of(credentialsProvider.resolveCredentials());
        }
        catch (SdkClientException e) {
            return Optional.empty();
        }
    }
}

