/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.google.common.collect.ImmutableMap;
import io.linguarobot.aws.cdk.maven.AbstractCdkMojo;
import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.CloudDefinition;
import io.linguarobot.aws.cdk.maven.DockerImageAssetPublisher;
import io.linguarobot.aws.cdk.maven.EnvironmentResolver;
import io.linguarobot.aws.cdk.maven.FileAssetPublisher;
import io.linguarobot.aws.cdk.maven.ResolvedEnvironment;
import io.linguarobot.aws.cdk.maven.StackDefinition;
import io.linguarobot.aws.cdk.maven.StackDeployer;
import io.linguarobot.aws.cdk.maven.ToolkitConfiguration;
import io.linguarobot.aws.cdk.maven.process.DefaultProcessRunner;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractCdkMojo {
    private static final Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="CDKToolkit")
    private String toolkitStackName;
    @Parameter
    private Set<String> stacks;
    @Parameter
    private Map<String, String> parameters;

    @Override
    public void execute(Path cloudAssemblyDirectory, EnvironmentResolver environmentResolver) {
        if (!Files.exists(cloudAssemblyDirectory, new LinkOption[0])) {
            throw new CdkPluginException("The cloud assembly directory " + cloudAssemblyDirectory + " doesn't exist. Did you forget to add 'synth' goal to the execution?");
        }
        CloudDefinition cloudDefinition = CloudDefinition.create(cloudAssemblyDirectory);
        if (this.stacks != null && logger.isWarnEnabled()) {
            Set stackNames = cloudDefinition.getStacks().stream().map(StackDefinition::getStackName).collect(Collectors.toSet());
            this.stacks.stream().filter(s -> !stackNames.contains(s)).forEach(missingStack -> logger.warn("The stack '{}' can't be deployed as there's no stack with such name defined in your CDK application", missingStack));
        }
        Map<String, List<StackDefinition>> stacks = cloudDefinition.getStacks().stream().filter(stack -> this.stacks == null || this.stacks.contains(stack.getStackName())).collect(Collectors.groupingBy(StackDefinition::getEnvironment));
        DefaultProcessRunner processRunner = new DefaultProcessRunner(this.project.getBasedir());
        stacks.forEach((environment, environmentStacks) -> {
            ResolvedEnvironment resolvedEnvironment = environmentResolver.resolve((String)environment);
            DockerImageAssetPublisher dockerImagePublisher = new DockerImageAssetPublisher(resolvedEnvironment, processRunner);
            FileAssetPublisher filePublisher = new FileAssetPublisher(resolvedEnvironment);
            ToolkitConfiguration toolkitConfiguration = new ToolkitConfiguration(this.toolkitStackName);
            StackDeployer stackDeployer = new StackDeployer(cloudAssemblyDirectory, resolvedEnvironment, toolkitConfiguration, filePublisher, dockerImagePublisher);
            environmentStacks.forEach(stack -> {
                if (!stack.getResources().isEmpty()) {
                    stackDeployer.deploy((StackDefinition)stack, this.parameters != null ? this.parameters : ImmutableMap.of());
                } else {
                    stackDeployer.destroy((StackDefinition)stack);
                }
            });
        });
    }
}

