/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.ResolvedEnvironment;
import javax.annotation.Nullable;

public class StackDeploymentException
extends CdkPluginException {
    private final String stackName;
    private final ResolvedEnvironment environment;

    protected StackDeploymentException(String stackName, ResolvedEnvironment environment, String message, @Nullable Throwable cause) {
        super(StackDeploymentException.formatErrorMessage(stackName, environment, message), cause);
        this.stackName = stackName;
        this.environment = environment;
    }

    private static String formatErrorMessage(String stackName, ResolvedEnvironment environment, @Nullable String message) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("The stack '").append(stackName).append("' cannot be deployed in ").append(environment.getName()).append(" environment");
        if (message != null) {
            errorMessage.append(". ").append(message);
        }
        return errorMessage.toString();
    }

    public String getStackName() {
        return this.stackName;
    }

    public ResolvedEnvironment getEnvironment() {
        return this.environment;
    }

    public static Builder builder(String stackName, ResolvedEnvironment environment) {
        return new Builder(stackName, environment);
    }

    public static class Builder {
        private final String stackName;
        private final ResolvedEnvironment environment;
        private String message;
        private Throwable cause;

        private Builder(String stackName, ResolvedEnvironment environment) {
            this.stackName = stackName;
            this.environment = environment;
        }

        public Builder withCause(String cause) {
            this.message = cause;
            return this;
        }

        public Builder withCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public StackDeploymentException build() {
            return new StackDeploymentException(this.stackName, this.environment, this.message, this.cause);
        }
    }
}

