/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.google.common.collect.ImmutableSet;
import io.linguarobot.aws.cdk.maven.ParameterValue;
import io.linguarobot.aws.cdk.maven.TemplateRef;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationException;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;

public class Stacks {
    private static final ScheduledExecutorService SCHEDULER = new ScheduledThreadPoolExecutor(0);
    private static final Set<StackStatus> IN_PROGRESS_STATUSES = ImmutableSet.builder().add((Object)StackStatus.CREATE_IN_PROGRESS).add((Object)StackStatus.DELETE_IN_PROGRESS).add((Object)StackStatus.REVIEW_IN_PROGRESS).add((Object)StackStatus.ROLLBACK_IN_PROGRESS).add((Object)StackStatus.UPDATE_COMPLETE_CLEANUP_IN_PROGRESS).add((Object)StackStatus.UPDATE_IN_PROGRESS).add((Object)StackStatus.UPDATE_ROLLBACK_IN_PROGRESS).add((Object)StackStatus.IMPORT_IN_PROGRESS).add((Object)StackStatus.IMPORT_ROLLBACK_IN_PROGRESS).build();
    private static final Set<StackStatus> FAILED_STATUSES = ImmutableSet.builder().add((Object)StackStatus.CREATE_FAILED).add((Object)StackStatus.DELETE_FAILED).add((Object)StackStatus.ROLLBACK_FAILED).add((Object)StackStatus.UPDATE_ROLLBACK_FAILED).add((Object)StackStatus.IMPORT_ROLLBACK_FAILED).build();
    private static final Set<StackStatus> ROLLED_BACK_STATUSES = ImmutableSet.builder().add((Object)StackStatus.ROLLBACK_COMPLETE).add((Object)StackStatus.UPDATE_ROLLBACK_COMPLETE).add((Object)StackStatus.IMPORT_ROLLBACK_COMPLETE).build();
    private static final Capability[] CAPABILITIES = new Capability[]{Capability.CAPABILITY_IAM, Capability.CAPABILITY_NAMED_IAM, Capability.CAPABILITY_AUTO_EXPAND};

    public static Optional<Stack> findStack(CloudFormationClient client, String stackName) {
        Objects.requireNonNull(client, "CloudFormation client can't be null");
        Objects.requireNonNull(stackName, "stack name can't be null");
        try {
            return Optional.of(Stacks.getStack(client, stackName));
        }
        catch (CloudFormationException e) {
            return Optional.empty();
        }
    }

    public static Stack createStack(CloudFormationClient client, String stackName, TemplateRef template) {
        return Stacks.createStack(client, stackName, template, Collections.emptyMap());
    }

    public static Stack createStack(CloudFormationClient client, String stackName, TemplateRef template, Map<String, ParameterValue> parameters) {
        Objects.requireNonNull(client, "CloudFormation client can't be null");
        Objects.requireNonNull(stackName, "stack name can't be null");
        Objects.requireNonNull(template, "template reference can't be null");
        CreateStackRequest request = (CreateStackRequest)CreateStackRequest.builder().stackName(stackName).templateBody(template.getBody()).templateURL(template.getUrl()).parameters(parameters != null ? Stacks.buildParameters(parameters) : Collections.emptyList()).capabilities(CAPABILITIES).build();
        CreateStackResponse response = client.createStack(request);
        return Stacks.getStack(client, response.stackId());
    }

    public static Stack updateStack(CloudFormationClient client, String stackName, TemplateRef template, Map<String, ParameterValue> parameters) {
        Objects.requireNonNull(client, "CloudFormation client can't be null");
        Objects.requireNonNull(stackName, "stack name can't be null");
        Objects.requireNonNull(template, "template reference can't be null");
        UpdateStackRequest request = (UpdateStackRequest)UpdateStackRequest.builder().stackName(stackName).templateBody(template.getBody()).templateURL(template.getUrl()).parameters(parameters != null ? Stacks.buildParameters(parameters) : Collections.emptyList()).capabilities(CAPABILITIES).build();
        UpdateStackResponse response = client.updateStack(request);
        return Stacks.getStack(client, response.stackId());
    }

    private static List<Parameter> buildParameters(Map<String, ParameterValue> parameters) {
        return parameters.entrySet().stream().map(parameter -> (Parameter)Parameter.builder().parameterKey((String)parameter.getKey()).parameterValue(((ParameterValue)parameter.getValue()).get()).usePreviousValue(Boolean.valueOf(!((ParameterValue)parameter.getValue()).isUpdated())).build()).collect(Collectors.toList());
    }

    public static Stack deleteStack(CloudFormationClient client, String stackName) {
        Objects.requireNonNull(client, "CloudFormation client can't be null");
        Objects.requireNonNull(stackName, "stack name can't be null");
        Stack stack = Stacks.getStack(client, stackName);
        DeleteStackRequest request = (DeleteStackRequest)DeleteStackRequest.builder().stackName(stack.stackId()).build();
        client.deleteStack(request);
        return Stacks.getStack(client, stackName);
    }

    public static Optional<Output> findOutput(Stack stack, String outputKey) {
        Objects.requireNonNull(stack, "stack can't be null");
        Objects.requireNonNull(outputKey, "output key can't be null");
        return Stream.of(stack).filter(Stack::hasOutputs).flatMap(s -> s.outputs().stream()).filter(output -> output.outputKey().equals(outputKey)).findAny();
    }

    public static boolean isCompleted(Stack stack) {
        return !Stacks.isInProgress(stack);
    }

    public static boolean isInProgress(Stack stack) {
        return IN_PROGRESS_STATUSES.contains(stack.stackStatus());
    }

    public static boolean isFailed(Stack stack) {
        return FAILED_STATUSES.contains(stack.stackStatus());
    }

    public static boolean isRolledBack(Stack stack) {
        return ROLLED_BACK_STATUSES.contains(stack.stackStatus());
    }

    public static Stack awaitCompletion(CloudFormationClient client, Stack stack) {
        return Stacks.awaitCompletion(client, stack, ForkJoinPool.commonPool(), null).join();
    }

    public static Stack awaitCompletion(CloudFormationClient client, Stack stack, @Nullable Consumer<StackEvent> eventListener) {
        StackEventListener stackEventListener = eventListener != null ? new StackEventListener(eventListener) : null;
        return Stacks.awaitCompletion(client, stack, ForkJoinPool.commonPool(), stackEventListener).join();
    }

    private static CompletableFuture<Stack> awaitCompletion(CloudFormationClient client, Stack initialStack, Executor executor, @Nullable StackEventListener eventListener) {
        CompletionStage<Object> stackFuture = eventListener != null ? CompletableFuture.runAsync(() -> Stacks.consumeEvents(client, initialStack.stackId(), eventListener), executor).thenCompose(r -> CompletableFuture.completedFuture(initialStack)) : CompletableFuture.completedFuture(initialStack);
        return stackFuture.thenCompose(stack -> {
            if (Stacks.isCompleted(stack)) {
                return CompletableFuture.completedFuture(stack);
            }
            Supplier<Stack> statusRequest = () -> {
                Stack nextStack = Stacks.getStack(client, stack.stackId());
                if (eventListener != null) {
                    Stacks.consumeEvents(client, nextStack.stackId(), eventListener);
                }
                return nextStack;
            };
            return Stacks.awaitCompletion(statusRequest, Duration.ZERO, Duration.ofSeconds(5L), executor);
        });
    }

    private static CompletableFuture<Stack> awaitCompletion(Supplier<Stack> request, Duration initialDelay, Duration period, Executor executor) {
        if (initialDelay.isNegative() || period.isNegative()) {
            throw new IllegalArgumentException("The initial delay and period must be equal or greater than zero");
        }
        Executor effectiveExecutor = initialDelay.isZero() ? executor : Stacks.delayedExecutor(executor, initialDelay);
        return CompletableFuture.supplyAsync(request, effectiveExecutor).thenCompose(stack -> {
            if (Stacks.isCompleted(stack)) {
                return CompletableFuture.completedFuture(stack);
            }
            return Stacks.awaitCompletion(request, period, period, executor);
        });
    }

    private static Executor delayedExecutor(Executor executor, Duration delay) {
        return command -> SCHEDULER.schedule(() -> executor.execute(command), delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    private static void consumeEvents(CloudFormationClient client, String stackId, StackEventListener eventListener) {
        ArrayDeque<StackEvent> events = new ArrayDeque<StackEvent>();
        String token = null;
        block0: do {
            DescribeStackEventsRequest eventsRequest = (DescribeStackEventsRequest)DescribeStackEventsRequest.builder().stackName(stackId).nextToken(token).build();
            DescribeStackEventsResponse eventsResponse = client.describeStackEvents(eventsRequest);
            token = eventsResponse.nextToken();
            for (StackEvent event : eventsResponse.stackEvents()) {
                if (eventListener.isConsumed(event)) {
                    token = null;
                    continue block0;
                }
                events.add(event);
            }
        } while (token != null);
        events.descendingIterator().forEachRemaining(eventListener::onEvent);
    }

    private static Stack getStack(CloudFormationClient client, String stackName) {
        DescribeStacksRequest request = (DescribeStacksRequest)DescribeStacksRequest.builder().stackName(stackName).build();
        return (Stack)client.describeStacks(request).stacks().get(0);
    }

    private static class StackEventListener {
        private final Consumer<StackEvent> consumer;
        private final Set<String> consumed;

        public StackEventListener(Consumer<StackEvent> consumer) {
            this.consumer = consumer;
            this.consumed = new HashSet<String>();
        }

        public boolean onEvent(StackEvent event) {
            if (this.isConsumed(event)) {
                return false;
            }
            this.consumed.add(event.eventId());
            this.consumer.accept(event);
            return true;
        }

        public boolean isConsumed(StackEvent event) {
            return this.consumed.contains(event.eventId());
        }
    }
}

