/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven.node;

import io.linguarobot.aws.cdk.maven.node.NodeInstallationException;
import io.linguarobot.aws.cdk.maven.node.UnixNodeInstaller;
import io.linguarobot.aws.cdk.maven.process.ProcessRunner;
import java.nio.file.Path;

public class LinuxNodeInstaller
extends UnixNodeInstaller {
    public LinuxNodeInstaller(ProcessRunner processRunner, Path localRepositoryPath) {
        super(processRunner, localRepositoryPath, "linux", LinuxNodeInstaller.getArch());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getArch() {
        String arch = System.getProperty("os.arch");
        if (arch.equals("arm")) {
            String osVersion = System.getProperty("os.version");
            if (!osVersion.contains("v7")) throw new NodeInstallationException("The architecture is not supported: " + arch);
            return "armv7l";
        }
        if (arch.equals("aarch64")) {
            return "arm64";
        }
        if (arch.equals("ppc64le")) return arch;
        if (arch.equals("s390x")) return arch;
        if (!arch.contains("64")) throw new NodeInstallationException("The architecture is not supported: " + arch);
        return "x64";
    }
}

