/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven.text.table;

import com.google.common.collect.ImmutableList;
import io.linguarobot.aws.cdk.maven.text.Ansi;
import io.linguarobot.aws.cdk.maven.text.table.Alignment;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class Cell {
    private static final Cell BLANK_CELL = new Cell("", null, (List<Ansi.Parameter>)ImmutableList.of());
    private final String value;
    private final Alignment alignment;
    private final List<Ansi.Parameter> ansiParameters;

    protected Cell(String value, @Nullable Alignment alignment, List<Ansi.Parameter> ansiParameters) {
        this.value = value;
        this.alignment = alignment;
        this.ansiParameters = ansiParameters;
    }

    public String getValue() {
        return this.value;
    }

    public Optional<Alignment> getAlignment() {
        return Optional.ofNullable(this.alignment);
    }

    public List<Ansi.Parameter> getAnsiParameters() {
        return this.ansiParameters;
    }

    public String toString() {
        return "Cell{value='" + this.value + '\'' + ", alignment=" + (Object)((Object)this.alignment) + ", ansiParameters=" + this.ansiParameters + '}';
    }

    public static Cell of(String value, Ansi.Parameter ... parameters) {
        return Cell.of(value, null, parameters);
    }

    public static Cell of(String value, @Nullable Alignment alignment, Ansi.Parameter ... parameters) {
        return new Cell(value, alignment, (List<Ansi.Parameter>)ImmutableList.copyOf((Object[])parameters));
    }

    public static Cell blank() {
        return BLANK_CELL;
    }
}

