/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import io.linguarobot.aws.cdk.maven.AbstractCdkMojo;
import io.linguarobot.aws.cdk.maven.BootstrapException;
import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.CloudDefinition;
import io.linguarobot.aws.cdk.maven.EnvironmentResolver;
import io.linguarobot.aws.cdk.maven.LoggingStackEventListener;
import io.linguarobot.aws.cdk.maven.ParameterValue;
import io.linguarobot.aws.cdk.maven.ResolvedEnvironment;
import io.linguarobot.aws.cdk.maven.StackDefinition;
import io.linguarobot.aws.cdk.maven.Stacks;
import io.linguarobot.aws.cdk.maven.TemplateRef;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.CloudFormationClientBuilder;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;

@Mojo(name="bootstrap", defaultPhase=LifecyclePhase.DEPLOY)
public class BootstrapMojo
extends AbstractCdkMojo {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapMojo.class);
    private static final int MAX_TEMPLATE_SIZE = 51200;
    private static final int MAX_TOOLKIT_STACK_VERSION = 1;
    private static final int DEFAULT_BOOTSTRAP_STACK_VERSION = BootstrapMojo.getDefaultBootstrapStackVersion();
    private static final String BOOTSTRAP_VERSION_OUTPUT = "BootstrapVersion";
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="CDKToolkit")
    private String toolkitStackName;
    @org.apache.maven.plugins.annotations.Parameter
    private Set<String> stacks;

    @Override
    public void execute(Path cloudAssemblyDirectory, EnvironmentResolver environmentResolver) {
        if (!Files.exists(cloudAssemblyDirectory, new LinkOption[0])) {
            throw new CdkPluginException("The cloud assembly directory " + cloudAssemblyDirectory + " doesn't exist. Did you forget to add 'synth' goal to the execution?");
        }
        CloudDefinition cloudDefinition = CloudDefinition.create(cloudAssemblyDirectory);
        Map<String, Integer> environments = cloudDefinition.getStacks().stream().filter(stack -> this.stacks == null || this.stacks.contains(stack.getStackName())).filter(this::isBootstrapRequired).collect(Collectors.groupingBy(StackDefinition::getEnvironment, Collectors.reducing(DEFAULT_BOOTSTRAP_STACK_VERSION, stack -> (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{stack.getRequiredToolkitStackVersion(), DEFAULT_BOOTSTRAP_STACK_VERSION}), Math::max)));
        environments.forEach((environment, version) -> {
            ResolvedEnvironment resolvedEnvironment = environmentResolver.resolve((String)environment);
            if (version > 1) {
                throw BootstrapException.deploymentError(this.toolkitStackName, resolvedEnvironment).withCause("One of the stacks requires toolkit stack version " + version + " which is not supported by the plugin. Please try to update the plugin version in order to fix the problem").build();
            }
            this.bootstrap(resolvedEnvironment, (int)version);
        });
    }

    private boolean isBootstrapRequired(StackDefinition stack) {
        if (this.hasFileAssets(stack)) {
            return true;
        }
        try {
            return Files.size(stack.getTemplateFile()) > 51200L;
        }
        catch (IOException e) {
            throw new CdkPluginException("Failed to determine template file size", e);
        }
    }

    private boolean hasFileAssets(StackDefinition stack) {
        return stack.getAssets().stream().anyMatch(assetMetadata -> {
            String packaging = assetMetadata.getPackaging();
            return packaging.equals("zip") || packaging.equals("file");
        });
    }

    private void bootstrap(ResolvedEnvironment environment, int version) {
        int toolkitStackVersion;
        CloudFormationClient client = (CloudFormationClient)((CloudFormationClientBuilder)((CloudFormationClientBuilder)CloudFormationClient.builder().region(environment.getRegion())).credentialsProvider(environment.getCredentialsProvider())).build();
        Stack toolkitStack = Stacks.findStack(client, this.toolkitStackName).orElse(null);
        if (toolkitStack != null) {
            if (Stacks.isInProgress(toolkitStack)) {
                logger.info("Waiting until toolkit stack reaches stable state, environment={}, stackName={}", (Object)environment, (Object)this.toolkitStackName);
                toolkitStack = this.awaitCompletion(client, toolkitStack);
            }
            if (toolkitStack.stackStatus() == StackStatus.ROLLBACK_COMPLETE || toolkitStack.stackStatus() == StackStatus.ROLLBACK_FAILED) {
                logger.warn("The toolkit stack is in {} state. The stack will be deleted and a new one will be created, environment={}, stackName={}", new Object[]{StackStatus.ROLLBACK_COMPLETE, environment, this.toolkitStackName});
                toolkitStack = this.awaitCompletion(client, Stacks.deleteStack(client, toolkitStack.stackId()));
            }
            if (Stacks.isFailed(toolkitStack)) {
                throw BootstrapException.deploymentError(this.toolkitStackName, environment).withCause("The toolkit stack is in failed state: " + toolkitStack.stackStatus()).build();
            }
        }
        if ((toolkitStackVersion = Stream.of(toolkitStack).filter(stack -> stack != null && stack.stackStatus() != StackStatus.DELETE_COMPLETE).filter(Stack::hasOutputs).flatMap(stack -> stack.outputs().stream()).filter(output -> output.outputKey().equals(BOOTSTRAP_VERSION_OUTPUT)).map(Output::outputValue).map(Integer::parseInt).findAny().orElse(version).intValue()) > 1) {
            throw BootstrapException.invalidStateError(this.toolkitStackName, environment).withCause("The deployed toolkit stack version is newer than the latest supported by the plugin. Please try to update the plugin version in order to fix the problem").build();
        }
        if (toolkitStack == null || toolkitStack.stackStatus() == StackStatus.DELETE_COMPLETE || toolkitStackVersion < version) {
            TemplateRef toolkitTemplate;
            try {
                toolkitTemplate = this.getToolkitTemplateRef(version).orElseThrow(() -> BootstrapException.deploymentError(this.toolkitStackName, environment).withCause("The required bootstrap stack version " + version + " is not supported by the plugin. Please try to update the plugin version in order to fix the problem").build());
            }
            catch (IOException e) {
                throw BootstrapException.deploymentError(this.toolkitStackName, environment).withCause("Unable to load a template for the toolkit stack").withCause(e).build();
            }
            if (toolkitStack != null && toolkitStack.stackStatus() != StackStatus.DELETE_COMPLETE) {
                logger.info("Deploying a newer version of the toolkit stack (updating from {} to {}), environment={}, stackName={}", new Object[]{toolkitStackVersion, version, environment, this.toolkitStackName});
                Map<String, ParameterValue> parameters = Stream.of(toolkitStack).filter(Stack::hasParameters).flatMap(s -> s.parameters().stream()).collect(Collectors.toMap(Parameter::parameterKey, p -> ParameterValue.unchanged()));
                toolkitStack = Stacks.updateStack(client, this.toolkitStackName, toolkitTemplate, parameters);
            } else {
                logger.info("The toolkit stack doesn't exist. Deploying a new one, environment={}, stackName={}", (Object)environment, (Object)this.toolkitStackName);
                toolkitStack = Stacks.createStack(client, this.toolkitStackName, toolkitTemplate);
            }
            if (!Stacks.isCompleted(toolkitStack)) {
                logger.info("Waiting until the toolkit stack reaches stable state, environment={}, stackName={}", (Object)environment, (Object)this.toolkitStackName);
                toolkitStack = this.awaitCompletion(client, toolkitStack);
            }
            if (Stacks.isFailed(toolkitStack)) {
                throw BootstrapException.deploymentError(this.toolkitStackName, environment).withCause("The deployment has failed: " + toolkitStack.stackStatus()).build();
            }
            if (Stacks.isRolledBack(toolkitStack)) {
                throw BootstrapException.deploymentError(this.toolkitStackName, environment).withCause("The deployment has been unsuccessful, the stack has been rolled back to its previous state").build();
            }
            logger.info("The toolkit stack has been successfully deployed, stackName={}", (Object)this.toolkitStackName);
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<TemplateRef> getToolkitTemplateRef(int version) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Stack awaitCompletion(CloudFormationClient client, Stack stack) {
        Stack completedStack = logger.isInfoEnabled() ? Stacks.awaitCompletion(client, stack, new LoggingStackEventListener()) : Stacks.awaitCompletion(client, stack);
        return completedStack;
    }

    private static Integer getDefaultBootstrapStackVersion() {
        String newBootstrapEnabled = System.getenv("CDK_NEW_BOOTSTRAP");
        return newBootstrapEnabled != null && !newBootstrapEnabled.isEmpty() ? 1 : 0;
    }
}

