/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class ResolvedEnvironment {
    private final String name;
    private final Region region;
    private final String account;
    private final AwsCredentialsProvider credentialsProvider;

    public ResolvedEnvironment(Region region, String account, AwsCredentials credentials) {
        this.name = "aws://" + account + "/" + region;
        this.region = region;
        this.account = account;
        this.credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
    }

    public String getName() {
        return this.name;
    }

    public Region getRegion() {
        return this.region;
    }

    public String getAccount() {
        return this.account;
    }

    public AwsCredentials getCredentials() {
        return this.credentialsProvider.resolveCredentials();
    }

    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public String toString() {
        return this.getName();
    }
}

