/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.linguarobot.aws.cdk.Artifact;
import io.linguarobot.aws.cdk.ArtifactType;
import io.linguarobot.aws.cdk.AssetMetadata;
import io.linguarobot.aws.cdk.CloudManifest;
import io.linguarobot.aws.cdk.StackArtifact;
import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.ParameterDefinition;
import io.linguarobot.aws.cdk.maven.StackDefinition;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class CloudDefinition {
    private final Path cloudAssemblyDirectory;
    private final List<StackDefinition> stacks;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JSR353Module());

    private CloudDefinition(Path cloudAssemblyDirectory, List<StackDefinition> stacks) {
        this.cloudAssemblyDirectory = cloudAssemblyDirectory;
        this.stacks = ImmutableList.copyOf(stacks);
    }

    @Nonnull
    public List<StackDefinition> getStacks() {
        return this.stacks;
    }

    @Nonnull
    public Path getCloudAssemblyDirectory() {
        return this.cloudAssemblyDirectory;
    }

    public String toString() {
        return "CloudDefinition{stacks=" + this.stacks + '}';
    }

    public static CloudDefinition create(Path cloudAssemblyDirectory) {
        CloudManifest manifest;
        try {
            manifest = CloudManifest.create((Path)cloudAssemblyDirectory);
        }
        catch (IOException e) {
            throw new CdkPluginException("Failed to read the cloud manifest", e);
        }
        Map stacks = manifest.getArtifacts().entrySet().stream().filter(artifact -> ((Artifact)artifact.getValue()).getType() == ArtifactType.STACK).map(artifact -> {
            String artifactId = (String)artifact.getKey();
            StackArtifact stackArtifact = (StackArtifact)artifact.getValue();
            String stackName = (String)ObjectUtils.firstNonNull((Object[])new String[]{stackArtifact.getProperties().getStackName(), artifactId});
            Path templateFile = cloudAssemblyDirectory.resolve(stackArtifact.getProperties().getTemplateFile());
            Integer requiredToolkitStackVersion = Optional.ofNullable(stackArtifact.getProperties().getRequiredToolkitStackVersion()).map(Number::intValue).orElse(null);
            Map<String, Object> template = CloudDefinition.readTemplate(templateFile);
            Map<String, ParameterDefinition> parameters = CloudDefinition.getParameterDefinitions(template);
            List<AssetMetadata> assets = stackArtifact.getMetadata().values().stream().flatMap(Collection::stream).filter(metadata -> "aws:cdk:asset".equals(metadata.getType())).map(metadata -> (AssetMetadata)metadata).collect(Collectors.toList());
            Map resources = (Map)template.getOrDefault("Resources", ImmutableMap.of());
            return StackDefinition.builder().withStackName(stackName).withTemplateFile(templateFile).withEnvironment(stackArtifact.getEnvironment()).withRequiredToolkitStackVersion(requiredToolkitStackVersion).withParameters(parameters).withParameterValues(stackArtifact.getProperties().getParameters()).withAssets(assets).withResources(resources).withDependencies(stackArtifact.getDependencies()).build();
        }).collect(Collectors.toMap(StackDefinition::getStackName, Function.identity()));
        HashSet visited = new HashSet();
        ArrayList<StackDefinition> sortedStacks = new ArrayList<StackDefinition>();
        stacks.keySet().forEach(stackName -> CloudDefinition.sortTopologically(stackName, stacks, visited, sortedStacks::add));
        return new CloudDefinition(cloudAssemblyDirectory, sortedStacks);
    }

    private static void sortTopologically(String stackName, Map<String, StackDefinition> stacks, Set<String> visited, Consumer<StackDefinition> consumer) {
        if (!visited.contains(stackName)) {
            visited.add(stackName);
            StackDefinition definition = stacks.get(stackName);
            if (definition != null) {
                for (String dependency : definition.getDependencies()) {
                    CloudDefinition.sortTopologically(dependency, stacks, visited, consumer);
                }
                consumer.accept(definition);
            }
        }
    }

    private static Map<String, Object> readTemplate(Path template) {
        try {
            return (Map)OBJECT_MAPPER.readValue(template.toFile(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new CdkPluginException("Failed to read the stack template: " + template);
        }
    }

    private static Map<String, ParameterDefinition> getParameterDefinitions(Map<String, Object> template) {
        Map parameters = template.getOrDefault("Parameters", Collections.emptyMap());
        return parameters.entrySet().stream().map(parameter -> {
            String name = (String)parameter.getKey();
            Object defaultValue = ((Map)parameter.getValue()).get("Default");
            return new ParameterDefinition(name, defaultValue);
        }).collect(Collectors.toMap(ParameterDefinition::getName, Function.identity()));
    }
}

