/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.google.common.collect.ImmutableMap;
import io.linguarobot.aws.cdk.maven.AbstractCloudActionMojo;
import io.linguarobot.aws.cdk.maven.CloudDefinition;
import io.linguarobot.aws.cdk.maven.DockerImageAssetPublisher;
import io.linguarobot.aws.cdk.maven.EnvironmentResolver;
import io.linguarobot.aws.cdk.maven.FileAssetPublisher;
import io.linguarobot.aws.cdk.maven.ResolvedEnvironment;
import io.linguarobot.aws.cdk.maven.StackDefinition;
import io.linguarobot.aws.cdk.maven.StackDeployer;
import io.linguarobot.aws.cdk.maven.ToolkitConfiguration;
import io.linguarobot.aws.cdk.maven.process.DefaultProcessRunner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractCloudActionMojo {
    private static final Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="aws.cdk.toolkit.stack.name", defaultValue="CDKToolkit")
    private String toolkitStackName;
    @Parameter(property="aws.cdk.stacks")
    private Set<String> stacks;
    @Parameter
    private Map<String, String> parameters;

    @Override
    public void execute(CloudDefinition cloudDefinition, EnvironmentResolver environmentResolver) {
        if (this.stacks != null && !this.stacks.isEmpty() && logger.isWarnEnabled()) {
            HashSet<String> undefinedStacks = new HashSet<String>(this.stacks);
            cloudDefinition.getStacks().forEach(stack -> undefinedStacks.remove(stack.getStackName()));
            if (!undefinedStacks.isEmpty()) {
                logger.warn("The following stacks are not defined in the cloud application and can not be deployed: {}", (Object)String.join((CharSequence)", ", undefinedStacks));
            }
        }
        DefaultProcessRunner processRunner = new DefaultProcessRunner(this.project.getBasedir());
        HashMap<String, StackDeployer> deployers = new HashMap<String, StackDeployer>();
        for (StackDefinition stack2 : cloudDefinition.getStacks()) {
            if (this.stacks != null && !this.stacks.isEmpty() && !this.stacks.contains(stack2.getStackName())) continue;
            StackDeployer deployer = deployers.computeIfAbsent(stack2.getEnvironment(), environment -> {
                ResolvedEnvironment resolvedEnvironment = environmentResolver.resolve((String)environment);
                DockerImageAssetPublisher dockerImagePublisher = new DockerImageAssetPublisher(resolvedEnvironment, processRunner);
                FileAssetPublisher filePublisher = new FileAssetPublisher(resolvedEnvironment);
                ToolkitConfiguration toolkitConfiguration = new ToolkitConfiguration(this.toolkitStackName);
                return new StackDeployer(cloudDefinition.getCloudAssemblyDirectory(), resolvedEnvironment, toolkitConfiguration, filePublisher, dockerImagePublisher);
            });
            if (!stack2.getResources().isEmpty()) {
                deployer.deploy(stack2, this.parameters != null ? this.parameters : ImmutableMap.of());
                continue;
            }
            deployer.destroy(stack2);
        }
    }
}

