/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import io.linguarobot.aws.cdk.maven.AbstractCloudActionMojo;
import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.CloudDefinition;
import io.linguarobot.aws.cdk.maven.EnvironmentResolver;
import io.linguarobot.aws.cdk.maven.LoggingStackEventListener;
import io.linguarobot.aws.cdk.maven.ResolvedEnvironment;
import io.linguarobot.aws.cdk.maven.StackDefinition;
import io.linguarobot.aws.cdk.maven.Stacks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.CloudFormationClientBuilder;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;

@Mojo(name="destroy")
public class DestroyMojo
extends AbstractCloudActionMojo {
    private static final Logger logger = LoggerFactory.getLogger(DestroyMojo.class);
    @Parameter(property="aws.cdk.stacks")
    private Set<String> stacks;

    @Override
    public void execute(CloudDefinition cloudDefinition, EnvironmentResolver environmentResolver) {
        if (this.stacks != null && !this.stacks.isEmpty() && logger.isWarnEnabled()) {
            HashSet<String> undefinedStacks = new HashSet<String>(this.stacks);
            cloudDefinition.getStacks().forEach(stack -> undefinedStacks.remove(stack.getStackName()));
            if (!undefinedStacks.isEmpty()) {
                logger.warn("The following stacks are not defined in the cloud application and can not be deleted: {}", (Object)String.join((CharSequence)", ", undefinedStacks));
            }
        }
        HashMap clients = new HashMap();
        IntStream.range(0, cloudDefinition.getStacks().size()).map(i -> cloudDefinition.getStacks().size() - 1 - i).mapToObj(cloudDefinition.getStacks()::get).filter(stack -> this.stacks == null || this.stacks.isEmpty() || this.stacks.contains(stack.getStackName())).forEach(stack -> {
            CloudFormationClient client = clients.computeIfAbsent(stack.getEnvironment(), environment -> {
                ResolvedEnvironment resolvedEnvironment = environmentResolver.resolve((String)environment);
                return (CloudFormationClient)((CloudFormationClientBuilder)((CloudFormationClientBuilder)CloudFormationClient.builder().region(resolvedEnvironment.getRegion())).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)resolvedEnvironment.getCredentials()))).build();
            });
            this.destroy(client, (StackDefinition)stack);
        });
    }

    private void destroy(CloudFormationClient client, StackDefinition stackDefinition) {
        Stack stack = Stacks.findStack(client, stackDefinition.getStackName()).filter(s -> s.stackStatus() != StackStatus.DELETE_COMPLETE).orElse(null);
        if (stack != null) {
            stack = Stacks.deleteStack(client, stack.stackName());
            if (logger.isInfoEnabled()) {
                logger.info("The stack '{}' is being deleted, waiting until the operation is completed", (Object)stack.stackName());
                stack = Stacks.awaitCompletion(client, stack, new LoggingStackEventListener());
            } else {
                stack = Stacks.awaitCompletion(client, stack);
            }
            if (stack.stackStatus() != StackStatus.DELETE_COMPLETE) {
                throw new CdkPluginException("The deletion of '" + stack.stackName() + "' has failed.");
            }
            logger.info("The stack '{}' has been successfully deleted", (Object)stack.stackName());
        }
    }
}

