/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.google.common.collect.ImmutableList;
import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.ImageBuild;
import io.linguarobot.aws.cdk.maven.ResolvedEnvironment;
import io.linguarobot.aws.cdk.maven.process.ProcessExecutionException;
import io.linguarobot.aws.cdk.maven.process.ProcessRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.EcrClientBuilder;
import software.amazon.awssdk.services.ecr.model.AuthorizationData;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.ImageDetail;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageNotFoundException;
import software.amazon.awssdk.services.ecr.model.Repository;
import software.amazon.awssdk.services.ecr.model.RepositoryNotFoundException;

public class DockerImageAssetPublisher {
    private static final Logger logger = LoggerFactory.getLogger(DockerImageAssetPublisher.class);
    private final ResolvedEnvironment environment;
    private final ProcessRunner processRunner;
    private EcrClient ecrClient;

    public DockerImageAssetPublisher(ResolvedEnvironment environment, ProcessRunner processRunner) {
        this.environment = environment;
        this.processRunner = processRunner;
    }

    public void publish(String repositoryName, String tag, ImageBuild imageBuild) {
        ImageDetail image = this.findImage(repositoryName, tag).orElse(null);
        if (image == null) {
            this.ensureDockerInstalled();
            AuthorizationData authorizationData = this.getAuthorizationData().orElseThrow(() -> new CdkPluginException("Unable to retrieve authorization token from ECR"));
            try {
                this.processRunner.run(this.toDockerLoginCommand(authorizationData));
            }
            catch (ProcessExecutionException e) {
                throw new CdkPluginException("Unable to add ECR authorization data");
            }
            logger.info("Building docker image before publishing it to the ECR, dockerFile={}", (Object)imageBuild.getDockerfile());
            try {
                this.processRunner.run(this.toBuildCommand(imageBuild));
            }
            catch (ProcessExecutionException e) {
                throw new CdkPluginException("Failed to build the docker image from " + imageBuild.getDockerfile() + ". Please make sure that the Docker daemon is running");
            }
            Repository repository = this.findRepository(repositoryName).orElseGet(() -> this.createRepository(repositoryName));
            String imageUri = String.join((CharSequence)":", repository.repositoryUri(), tag);
            this.processRunner.run((List<String>)ImmutableList.of((Object)"docker", (Object)"tag", (Object)imageBuild.getImageTag(), (Object)imageUri));
            logger.info("Publishing docker image, imageUri={}", (Object)imageUri);
            try {
                this.processRunner.run((List<String>)ImmutableList.of((Object)"docker", (Object)"push", (Object)imageUri));
            }
            catch (ProcessExecutionException e) {
                throw new CdkPluginException("Unable to push the image " + imageUri + " to the ECR repository");
            }
        }
    }

    private void ensureDockerInstalled() {
        try {
            this.processRunner.run(Arrays.asList("docker", "--version"));
        }
        catch (ProcessExecutionException e) {
            throw new CdkPluginException("Docker is required in order to build container assets");
        }
    }

    private void login() {
        AuthorizationData authorizationData = this.getAuthorizationData().orElseThrow(() -> new CdkPluginException("Unable to retrieve authorization token from ECR"));
        this.processRunner.run(this.toDockerLoginCommand(authorizationData));
    }

    private List<String> toBuildCommand(ImageBuild build) {
        ArrayList<String> buildCommand = new ArrayList<String>();
        buildCommand.add("docker");
        buildCommand.add("build");
        buildCommand.add("--tag");
        buildCommand.add(build.getImageTag());
        build.getArguments().forEach((name, value) -> {
            buildCommand.add("--build-arg");
            buildCommand.add(String.join((CharSequence)"=", name, value));
        });
        if (build.getTarget() != null) {
            buildCommand.add("--target");
            buildCommand.add(build.getTarget());
        }
        if (build.getDockerfile() != null) {
            buildCommand.add("--file");
            buildCommand.add(build.getContextDirectory().relativize(build.getDockerfile()).toString());
        }
        buildCommand.add(build.getContextDirectory().toString());
        return buildCommand;
    }

    private EcrClient getEcrClient() {
        if (this.ecrClient == null) {
            this.ecrClient = (EcrClient)((EcrClientBuilder)((EcrClientBuilder)EcrClient.builder().region(this.environment.getRegion())).credentialsProvider(this.environment.getCredentialsProvider())).build();
        }
        return this.ecrClient;
    }

    private List<String> toDockerLoginCommand(AuthorizationData authorizationData) {
        String[] userPassword = new String(Base64.getDecoder().decode(authorizationData.authorizationToken())).split(":");
        return ImmutableList.of((Object)"docker", (Object)"login", (Object)"--username", (Object)userPassword[0], (Object)"--password", (Object)userPassword[1], (Object)authorizationData.proxyEndpoint());
    }

    private Optional<ImageDetail> findImage(String repositoryName, String imageTag) {
        DescribeImagesRequest describeRequest = (DescribeImagesRequest)DescribeImagesRequest.builder().repositoryName(repositoryName).imageIds(new ImageIdentifier[]{(ImageIdentifier)ImageIdentifier.builder().imageTag(imageTag).build()}).build();
        try {
            DescribeImagesResponse response = this.getEcrClient().describeImages(describeRequest);
            return response.imageDetails().stream().findFirst();
        }
        catch (ImageNotFoundException | RepositoryNotFoundException e) {
            return Optional.empty();
        }
    }

    private Optional<Repository> findRepository(String name) {
        DescribeRepositoriesRequest describeRequest = (DescribeRepositoriesRequest)DescribeRepositoriesRequest.builder().repositoryNames(new String[]{name}).build();
        try {
            DescribeRepositoriesResponse response = this.getEcrClient().describeRepositories(describeRequest);
            return response.repositories().stream().findFirst();
        }
        catch (RepositoryNotFoundException e) {
            return Optional.empty();
        }
    }

    private Repository createRepository(String name) {
        CreateRepositoryRequest createRequest = (CreateRepositoryRequest)CreateRepositoryRequest.builder().repositoryName(name).build();
        CreateRepositoryResponse response = this.getEcrClient().createRepository(createRequest);
        return response.repository();
    }

    private Optional<AuthorizationData> getAuthorizationData() {
        return this.getEcrClient().getAuthorizationToken().authorizationData().stream().findFirst();
    }
}

