/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import io.linguarobot.aws.cdk.maven.CdkPluginException;
import io.linguarobot.aws.cdk.maven.ResolvedEnvironment;
import io.linguarobot.aws.cdk.maven.api.AccountCredentialsProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.regions.Region;

public class EnvironmentResolver {
    private static final String SCHEMA_PREFIX = "aws://";
    private static final String UNKNOWN_ACCOUNT = "unknown-account";
    private static final String UNKNOWN_REGION = "unknown-region";
    private final Region defaultRegion;
    private final String defaultAccount;
    private final AccountCredentialsProvider accountCredentialsProvider;

    public EnvironmentResolver(Region defaultRegion, @Nullable String defaultAccount, AccountCredentialsProvider accountCredentialsProvider) {
        this.defaultRegion = defaultRegion;
        this.defaultAccount = defaultAccount;
        this.accountCredentialsProvider = accountCredentialsProvider;
    }

    public ResolvedEnvironment resolve(String environment) {
        String[] parts;
        if (environment.startsWith(SCHEMA_PREFIX) && (parts = environment.substring(SCHEMA_PREFIX.length()).split("/")).length == 2) {
            Region region;
            String account = !parts[0].equals(UNKNOWN_ACCOUNT) ? parts[0] : this.defaultAccount;
            Region region2 = region = !parts[1].equals(UNKNOWN_REGION) ? Region.of((String)parts[1]) : this.defaultRegion;
            if (account == null) {
                throw new CdkPluginException("Unable to dynamically determine which AWS account to use for deployment");
            }
            AwsCredentials credentials = (AwsCredentials)this.accountCredentialsProvider.get(account).orElseThrow(() -> new CdkPluginException("Credentials for the account '" + account + "' are not available."));
            return new ResolvedEnvironment(region, account, credentials);
        }
        throw new IllegalArgumentException("Invalid environment format '" + environment + "'. Expected format: aws://account/region");
    }

    @Nonnull
    public Region getDefaultRegion() {
        return this.defaultRegion;
    }

    @Nullable
    public String getDefaultAccount() {
        return this.defaultAccount;
    }
}

