/*
 * Decompiled with CFR 0.152.
 */
package io.linguarobot.aws.cdk.maven;

import com.google.common.collect.ImmutableList;
import io.linguarobot.aws.cdk.maven.text.Ansi;
import io.linguarobot.aws.cdk.maven.text.table.Cell;
import io.linguarobot.aws.cdk.maven.text.table.Column;
import io.linguarobot.aws.cdk.maven.text.table.TableWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;

public class LoggingStackEventListener
implements Consumer<StackEvent> {
    private static final Logger logger = LoggerFactory.getLogger(LoggingStackEventListener.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final List<Column> COLUMNS = ImmutableList.of((Object)Column.of("Timestamp", 20, new Ansi.Parameter[0]), (Object)Column.of("Logical ID", 32, new Ansi.Parameter[0]), (Object)Column.of("Status", 32, new Ansi.Parameter[0]), (Object)Column.of("Status Reason", 64, new Ansi.Parameter[0]));
    private final TableWriter tableWriter = TableWriter.of(line -> logger.info(line.trim()), COLUMNS);

    @Override
    public void accept(StackEvent event) {
        String status;
        Ansi.Color color = event.resourceStatus() == ResourceStatus.UNKNOWN_TO_SDK_VERSION ? Ansi.Color.BLACK : ((status = event.resourceStatus().toString()).endsWith("_IN_PROGRESS") ? Ansi.Color.BLUE : (status.endsWith("_FAILED") ? Ansi.Color.RED : Ansi.Color.GREEN));
        Cell statusReason = Optional.ofNullable(event.resourceStatusReason()).map(reason -> Cell.of(reason, color)).orElse(Cell.blank());
        ImmutableList row = ImmutableList.of((Object)Cell.of(ZonedDateTime.from(event.timestamp().atZone(ZoneId.systemDefault())).format(DATE_TIME_FORMATTER), new Ansi.Parameter[0]), (Object)Cell.of(event.logicalResourceId(), new Ansi.Parameter[0]), (Object)Cell.of(event.resourceStatusAsString(), color), (Object)statusReason);
        this.tableWriter.print((List<Cell>)row);
    }
}

