/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.client;

import io.mantisrx.server.master.client.MantisMasterClientApi;
import io.mantisrx.server.master.client.MasterClientWrapper;
import io.mantisrx.server.master.client.config.ConfigurationFactory;
import io.mantisrx.server.worker.client.JobWorkerMetricsLocator;
import io.mantisrx.server.worker.client.MetricsClient;
import io.mantisrx.server.worker.client.MetricsClientImpl;
import io.mantisrx.server.worker.client.WorkerConnectionFunc;
import io.mantisrx.server.worker.client.WorkerConnectionsStatus;
import io.reactivex.mantis.remote.observable.EndpointChange;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.functions.Func1;
import rx.subjects.PublishSubject;

public class WorkerMetricsClient {
    private static final Logger logger = LoggerFactory.getLogger(WorkerMetricsClient.class);
    private final MasterClientWrapper clientWrapper;
    private final JobWorkerMetricsLocator jobWrokerMetricsLocator = new JobWorkerMetricsLocator(){

        @Override
        public Observable<EndpointChange> locateWorkerMetricsForJob(final String jobId) {
            return WorkerMetricsClient.this.clientWrapper.getMasterClientApi().flatMap((Func1)new Func1<MantisMasterClientApi, Observable<EndpointChange>>(){

                public Observable<EndpointChange> call(MantisMasterClientApi mantisMasterClientApi) {
                    logger.info("Getting worker metrics locations for " + jobId);
                    return WorkerMetricsClient.this.clientWrapper.getAllWorkerMetricLocations(jobId);
                }
            });
        }
    };

    public WorkerMetricsClient(Properties properties) {
        this.clientWrapper = new MasterClientWrapper(properties);
    }

    public WorkerMetricsClient(ConfigurationFactory configurationFactory) {
        this.clientWrapper = new MasterClientWrapper(configurationFactory);
    }

    public JobWorkerMetricsLocator getWorkerMetricsLocator() {
        return this.jobWrokerMetricsLocator;
    }

    MasterClientWrapper getClientWrapper() {
        return this.clientWrapper;
    }

    public <T> MetricsClient<T> getMetricsClientByJobId(String jobId, WorkerConnectionFunc<T> workerConnectionFunc, Observer<WorkerConnectionsStatus> workerConnectionsStatusObserver) {
        return this.getMetricsClientByJobId(jobId, workerConnectionFunc, workerConnectionsStatusObserver, 5L);
    }

    public <T> MetricsClient<T> getMetricsClientByJobId(final String jobId, WorkerConnectionFunc<T> workerConnectionFunc, Observer<WorkerConnectionsStatus> workerConnectionsStatusObserver, long dataRecvTimeoutSecs) {
        PublishSubject numWrkrsSubject = PublishSubject.create();
        this.clientWrapper.addNumWorkersObserver((Observer)numWrkrsSubject);
        return new MetricsClientImpl<T>(jobId, workerConnectionFunc, this.getWorkerMetricsLocator(), (Observable<Integer>)numWrkrsSubject.filter((Func1)new Func1<MasterClientWrapper.JobNumWorkers, Boolean>(){

            public Boolean call(MasterClientWrapper.JobNumWorkers jobNumWorkers) {
                return jobId.equals(jobNumWorkers.getJobId());
            }
        }).map((Func1)new Func1<MasterClientWrapper.JobNumWorkers, Integer>(){

            public Integer call(MasterClientWrapper.JobNumWorkers jobNumWorkers) {
                return jobNumWorkers.getNumWorkers();
            }
        }), workerConnectionsStatusObserver, dataRecvTimeoutSecs);
    }
}

