/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.app.views.firstLevel;

import com.google.common.base.Strings;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import io.mateu.mdd.core.app.AbstractArea;
import io.mateu.mdd.core.app.AbstractModule;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.IModule;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;

public class AreaComponent
extends AbstractViewComponent {
    private final AbstractArea area;

    public String toString() {
        return "" + this.area.getName();
    }

    public AreaComponent(AbstractArea area) {
        this.area = area;
        this.setTitle(area.getName());
        this.addStyleName("areaflowcomponent");
    }

    public AbstractViewComponent build() throws Exception {
        this.removeAllComponents();
        if (MDDUIAccessor.isMobile()) {
            if (this.area.getModules().length == 1) {
                AbstractModule m = (AbstractModule)this.area.getModules()[0];
                m.getMenu().stream().forEach(a -> {
                    Button b = new Button(a.getCaption());
                    this.addComponent((Component)b);
                    b.setPrimaryStyleName("link");
                    b.addStyleName("submenuoption");
                });
            } else {
                for (IModule a2 : this.area.getModules()) {
                    Button b = new Button(a2.getName());
                    this.addComponent((Component)b);
                    b.setPrimaryStyleName("link");
                    b.addStyleName("submenuoption");
                }
            }
        } else if (!Strings.isNullOrEmpty((String)this.area.getName())) {
            this.addComponentsAndExpand(new Component[]{new Label("<h1>You are now in the " + this.area.getName() + " area.</h1>", ContentMode.HTML)});
        }
        if (!MDDUIAccessor.isMobile()) {
            this.addComponentsAndExpand(new Component[]{new Label("")});
        }
        return this;
    }
}

