/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.app.views.secondLevel;

import com.vaadin.data.HasValue;
import com.vaadin.shared.Registration;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.RichTextArea;
import com.vaadin.ui.TextArea;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.WizardPage;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.Code;
import io.mateu.mdd.shared.annotations.Html;
import io.mateu.mdd.shared.annotations.NotWhenCreating;
import io.mateu.mdd.shared.annotations.NotWhenEditing;
import io.mateu.mdd.shared.annotations.Wizard;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import io.mateu.mdd.vaadin.components.views.ViewComponentHelper;
import io.mateu.mdd.vaadin.components.views.WizardComponent;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.vaadin.aceeditor.AceEditor;

public class FieldEditorComponent
extends AbstractViewComponent {
    private FieldInterfaced field;
    private MDDBinder binder;

    public String toString() {
        return "" + this.binder.getBean() + " / " + ReflectionHelper.getCaption((FieldInterfaced)this.field);
    }

    public FieldEditorComponent(MDDBinder parentBinder, FieldInterfaced field) {
        this.binder = parentBinder;
        this.field = field;
    }

    @Override
    public boolean isBarHidden() {
        return true;
    }

    public AbstractViewComponent build() throws Exception {
        super.build();
        if (this.field.isAnnotationPresent(Wizard.class)) {
            HasValue hv = new HasValue(){

                public void setValue(Object value) {
                    Object bean = FieldEditorComponent.this.binder.getBean();
                    try {
                        ReflectionHelper.setValue((FieldInterfaced)FieldEditorComponent.this.field, (Object)bean, (Object)value);
                        FieldEditorComponent.this.binder.setBean(bean, false);
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                }

                public Object getValue() {
                    try {
                        return ReflectionHelper.getValue((FieldInterfaced)FieldEditorComponent.this.field, (Object)FieldEditorComponent.this.binder.getBean());
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                        return null;
                    }
                }

                public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                    return null;
                }

                public void setRequiredIndicatorVisible(boolean b) {
                }

                public boolean isRequiredIndicatorVisible() {
                    return false;
                }

                public void setReadOnly(boolean b) {
                }

                public boolean isReadOnly() {
                    return false;
                }
            };
            try {
                this.addComponent((Component)new WizardComponent((WizardPage)((Wizard)this.field.getAnnotation(Wizard.class)).value().getConstructor(HasValue.class).newInstance(hv)));
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        } else if (this.field.isAnnotationPresent(io.mateu.mdd.shared.annotations.TextArea.class)) {
            this.setSizeFull();
            Component[] componentArray = new Component[1];
            TextArea t = new TextArea();
            componentArray[0] = t;
            this.addComponentsAndExpand(componentArray);
            t.setSizeFull();
            t.focus();
            try {
                String v = (String)ReflectionHelper.getValue((FieldInterfaced)this.field, (Object)this.binder.getBean());
                t.setValue(v != null ? v : "");
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
            t.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){

                public void valueChange(HasValue.ValueChangeEvent<String> valueChangeEvent) {
                    try {
                        Object m = FieldEditorComponent.this.binder.getBean();
                        ReflectionHelper.setValue((FieldInterfaced)FieldEditorComponent.this.field, (Object)m, (Object)valueChangeEvent.getValue());
                        FieldEditorComponent.this.binder.setBean(m, false);
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                }
            });
        } else if (this.field.isAnnotationPresent(Html.class)) {
            this.setSizeFull();
            Component[] componentArray = new Component[1];
            RichTextArea t = new RichTextArea();
            componentArray[0] = t;
            this.addComponentsAndExpand(componentArray);
            t.setSizeFull();
            t.focus();
            try {
                String v = (String)ReflectionHelper.getValue((FieldInterfaced)this.field, (Object)this.binder.getBean());
                if (v == null) {
                    v = "";
                }
                t.setValue(v);
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
            t.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){

                public void valueChange(HasValue.ValueChangeEvent<String> valueChangeEvent) {
                    try {
                        Object m = FieldEditorComponent.this.binder.getBean();
                        ReflectionHelper.setValue((FieldInterfaced)FieldEditorComponent.this.field, (Object)m, (Object)valueChangeEvent.getValue());
                        FieldEditorComponent.this.binder.setBean(m, false);
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                }
            });
        } else if (this.field.isAnnotationPresent(Code.class)) {
            this.setSizeFull();
            Component[] componentArray = new Component[1];
            AceEditor t = new AceEditor();
            componentArray[0] = t;
            this.addComponentsAndExpand(componentArray);
            t.setMode(((Code)this.field.getAnnotation(Code.class)).mode());
            t.setTheme(((Code)this.field.getAnnotation(Code.class)).theme());
            t.setSizeFull();
            t.focus();
            try {
                t.setValue((String)ReflectionHelper.getValue((FieldInterfaced)this.field, (Object)this.binder.getBean()));
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
            t.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){

                public void valueChange(HasValue.ValueChangeEvent<String> valueChangeEvent) {
                    try {
                        Object m = FieldEditorComponent.this.binder.getBean();
                        ReflectionHelper.setValue((FieldInterfaced)FieldEditorComponent.this.field, (Object)m, (Object)valueChangeEvent.getValue());
                        FieldEditorComponent.this.binder.setBean(m, false);
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                }
            });
        } else {
            this.addComponent((Component)new Label("Pendiente"));
            this.addComponentsAndExpand(new Component[]{new Label("")});
        }
        return this;
    }

    @Override
    public List<AbstractAction> getActions() {
        List<AbstractAction> l = super.getActions();
        Object bean = this.binder != null ? this.binder.getBean() : null;
        boolean isEditingNewRecord = MDDUIAccessor.isEditingNewRecord();
        ArrayList<Method> ms = new ArrayList<Method>();
        for (Method m2 : ReflectionHelper.getAllMethods((Class)(bean != null ? bean.getClass() : this.field.getDeclaringClass()))) {
            if (Modifier.isStatic(m2.getModifiers()) || m2.isAnnotationPresent(NotWhenCreating.class) && isEditingNewRecord || m2.isAnnotationPresent(NotWhenEditing.class) && !isEditingNewRecord || !m2.isAnnotationPresent(Action.class) || !this.field.getName().equals(m2.getAnnotation(Action.class).attachToField())) continue;
            ms.add(m2);
        }
        ms.sort((a, b) -> a.getAnnotation(Action.class).order() - b.getAnnotation(Action.class).order());
        ms.forEach(m -> {
            AbstractAction a = ViewComponentHelper.createAction(m, this);
            l.add(a);
        });
        return l;
    }
}

