/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.collect.Lists;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JPABooleanFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return Boolean.class.equals((Object)field.getType()) || Boolean.TYPE.equals(field.getType());
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        CheckBox r = null;
        if (forSearchFilter && object != null && object.getClass().getName().endsWith("000Filters")) {
            ComboBox cb = new ComboBox();
            container.addComponent((Component)cb);
            cb.setDataProvider(new ListDataProvider((Collection)Lists.newArrayList((Object[])new Object[]{true, false})));
            if (allFieldContainers.size() == 0) {
                cb.focus();
            }
            if (container.getComponentCount() > 0) {
                cb.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            }
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)cb);
            }
            JPABooleanFieldBuilder.completeBinding((HasValue)cb, binder, field);
            this.addErrorHandler(field, (AbstractComponent)cb);
            r = cb;
        } else {
            HorizontalLayout hl = new HorizontalLayout();
            container.addComponent((Component)hl);
            hl.addStyleName("nopadding");
            hl.addStyleName("checkboxcontainer");
            CheckBox cb = new CheckBox();
            hl.addComponent((Component)cb);
            hl.setDefaultComponentAlignment(Alignment.TOP_LEFT);
            if (allFieldContainers.size() == 0) {
                cb.focus();
            }
            hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)hl);
            }
            JPABooleanFieldBuilder.completeBinding((HasValue)cb, binder, field);
            this.addErrorHandler(field, (AbstractComponent)cb);
            r = cb;
        }
        return r;
    }
}

