/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToDoubleConverter;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Slider;
import com.vaadin.ui.TextField;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAStringFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class JPADoubleFieldBuilder
extends JPAStringFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return Double.class.equals((Object)field.getType()) || Double.TYPE.equals(field.getType());
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        Component r = null;
        if (field.isAnnotationPresent(DecimalMin.class) && field.isAnnotationPresent(DecimalMax.class)) {
            Slider tf = new Slider(new Double(((DecimalMin)field.getAnnotation(DecimalMin.class)).value()).doubleValue(), new Double(((DecimalMax)field.getAnnotation(DecimalMax.class)).value()).doubleValue(), 1);
            container.addComponent((Component)tf);
            if (allFieldContainers != null && allFieldContainers.size() == 0) {
                tf.focus();
            }
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)tf);
            }
            if (container.getComponentCount() > 0) {
                tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            }
            if (!forSearchFilter) {
                tf.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotEmpty.class));
            }
            this.bind(binder, tf, field, forSearchFilter);
            this.addErrorHandler(field, (AbstractComponent)tf);
            r = tf;
        } else {
            r = super.build(field, object, container, binder, validators, stylist, allFieldContainers, forSearchFilter, attachedActions);
        }
        return r;
    }

    protected void bind(MDDBinder binder, Slider tf, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf);
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPADoubleFieldBuilder.completeBinding(aux, binder, field);
    }

    @Override
    protected void bind(MDDBinder binder, TextField tf, final FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf).withConverter((Converter)new StringToDoubleConverter(Double.TYPE.equals(field.getType()) ? Double.valueOf(0.0) : null, "Must be a number"){

            public String convertToPresentation(Double value, ValueContext context) {
                if (value == null) {
                    return "";
                }
                String s = "" + value;
                if (s.endsWith(".0")) {
                    s = s.replaceAll("\\.0", "");
                }
                return s;
            }

            public Result<Double> convertToModel(String value, ValueContext context) {
                if (value != null) {
                    if (value.contains(".") && value.contains(",")) {
                        value = value.replaceAll("\\.", "");
                    }
                    value = value.replaceAll("\\.", ",");
                }
                Result r = null;
                if (!Strings.isNullOrEmpty((String)value)) {
                    NumberFormat format = NumberFormat.getInstance(Locale.FRANCE);
                    Number number = null;
                    try {
                        number = format.parse(value.trim());
                        double d = number.doubleValue();
                        r = Result.ok((Object)d);
                    }
                    catch (ParseException e) {
                        r = Result.error((String)(e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
                    }
                } else {
                    r = Result.ok((Object)(Double.TYPE.equals(field.getType()) ? Double.valueOf(0.0) : null));
                }
                return r;
            }
        });
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPADoubleFieldBuilder.completeBinding(aux, binder, field);
    }
}

