/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.ui.TextField;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAStringFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import javax.money.MonetaryAmount;
import org.javamoney.moneta.FastMoney;

public class JPAFastMoneyFieldBuilder
extends JPAStringFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return FastMoney.class.equals((Object)field.getType()) || MonetaryAmount.class.equals((Object)field.getType());
    }

    @Override
    protected void bind(MDDBinder binder, TextField tf, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf).withConverter(new Converter(){

            public Result convertToModel(Object o, ValueContext valueContext) {
                String s = (String)o;
                if (Strings.isNullOrEmpty((String)s)) {
                    return Result.ok((Object)FastMoney.of((Number)0, (String)"EUR"));
                }
                return Result.ok((Object)FastMoney.parse((CharSequence)s));
            }

            public Object convertToPresentation(Object o, ValueContext valueContext) {
                return o != null ? o.toString() : "";
            }
        });
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPAFastMoneyFieldBuilder.completeBinding(aux, binder, field);
    }
}

