/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasItems;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.SerializableFunction;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBoxGroup;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.RadioButtonGroup;
import com.vaadin.ui.TextField;
import com.vaadin.ui.TwinColSelect;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.MDD;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.dataProviders.JPQLListDataProvider;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.DataProvider;
import io.mateu.mdd.shared.annotations.DependsOn;
import io.mateu.mdd.shared.annotations.UseIdToSelect;
import io.mateu.mdd.shared.annotations.UseLinkToListView;
import io.mateu.mdd.shared.annotations.UseRadioButtons;
import io.mateu.mdd.shared.annotations.Width;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Query;
import javax.validation.constraints.NotNull;

public class JPAManyToOneFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return field.isAnnotationPresent(ManyToOne.class) || field.getType().isAnnotationPresent(Entity.class);
    }

    @Override
    public Component build(final FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        ComboBox r = null;
        VerticalLayout tf = null;
        AbstractField hv = null;
        com.vaadin.data.provider.DataProvider dp = null;
        TextField captionOwner = null;
        Converter<String, Object> converter = null;
        Button botonLink = null;
        if (field.isAnnotationPresent(UseLinkToListView.class)) {
            HorizontalLayout wrap = new HorizontalLayout();
            wrap.setSpacing(true);
            wrap.setDefaultComponentAlignment(Alignment.MIDDLE_LEFT);
            final TextField l = new TextField();
            l.setEnabled(false);
            l.addStyleName("borderless");
            wrap.addComponent((Component)l);
            captionOwner = l;
            hv = new AbstractField(){
                Object v = null;

                protected void doSetValue(Object o) {
                    this.v = o;
                    if (o != null) {
                        l.setValue(o.toString());
                    } else {
                        l.setValue("");
                    }
                }

                public Object getValue() {
                    return this.v;
                }
            };
            if (!MDD.isReadWrite((Class)field.getType())) {
                Button b = new Button("Select");
                b.addStyleName("link");
                b.addClickListener((Button.ClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
                wrap.addComponent((Component)b);
            }
            container.addComponent((Component)wrap);
            this.addErrorHandler(field, (AbstractComponent)((AbstractField)tf));
            r = tf;
            tf = wrap;
            if (!forSearchFilter) {
                l.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class));
            }
        } else {
            HorizontalLayout hl;
            if (field.getType().isAnnotationPresent(UseIdToSelect.class)) {
                VerticalLayout fl;
                tf = fl = new VerticalLayout();
                hl = new HorizontalLayout();
                fl.addComponent((Component)hl);
                hl.setDefaultComponentAlignment(Alignment.BOTTOM_LEFT);
                container.addComponent((Component)fl);
                fl.addStyleName("nopadding");
                final TextField stf = new TextField();
                hl.addComponent((Component)stf);
                final Label l = new Label();
                fl.addComponent((Component)l);
                this.addErrorHandler(field, (AbstractComponent)stf);
                r = stf;
                captionOwner = stf;
                hv = stf;
                converter = new Converter<String, Object>(){

                    public Result<Object> convertToModel(String s, ValueContext valueContext) {
                        stf.setComponentError(null);
                        Result[] r = new Result[1];
                        if (Strings.isNullOrEmpty((String)s)) {
                            r[0] = Result.ok(null);
                            l.setValue("No value");
                        } else {
                            try {
                                JPAHelper.notransact(em -> {
                                    FieldInterfaced fid = ReflectionHelper.getIdField((Class)field.getType());
                                    String sql = "select x from " + field.getType().getName() + " x where x." + fid.getName() + " = :i";
                                    Object id = null;
                                    id = Integer.TYPE.equals(fid.getType()) || Integer.class.equals((Object)fid.getType()) ? Integer.valueOf(Integer.parseInt(s)) : (Long.TYPE.equals(fid.getType()) || Long.class.equals((Object)fid.getType()) ? Long.valueOf(Long.parseLong(s)) : (String.class.equals((Object)fid.getType()) ? s : s));
                                    Query q = em.createQuery(sql).setParameter("i", id);
                                    List list = q.getResultList();
                                    if (list.size() == 1) {
                                        Object v = list.get(0);
                                        r[0] = Result.ok(v);
                                        l.setValue(v != null ? "" + v : "No value");
                                    } else {
                                        r[0] = Result.error((String)"Not found");
                                        l.setValue("Not found");
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                if (throwable instanceof InvocationTargetException) {
                                    throwable = throwable.getCause();
                                }
                                String msg = throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName();
                                r[0] = Result.error((String)msg);
                                l.setValue(msg);
                            }
                        }
                        return r[0];
                    }

                    public String convertToPresentation(Object o, ValueContext valueContext) {
                        String s = null;
                        l.setValue(o != null ? "" + o : "No value");
                        if (o != null) {
                            Object id = ReflectionHelper.getId((Object)o);
                            s = id != null ? "" + id : "";
                        }
                        return s != null ? s : "";
                    }
                };
            } else {
                hl = new HorizontalLayout();
                tf = hl;
                hl.setDefaultComponentAlignment(Alignment.BOTTOM_LEFT);
                container.addComponent((Component)hl);
                if (!forSearchFilter && field.isAnnotationPresent(UseRadioButtons.class)) {
                    RadioButtonGroup rbg = new RadioButtonGroup();
                    hl.addComponent((Component)rbg);
                    hv = rbg;
                    this.addErrorHandler(field, (AbstractComponent)rbg);
                    r = rbg;
                    captionOwner = rbg;
                    JPAManyToOneFieldBuilder.setDataProvider((HasItems)rbg, field, binder);
                    if (!forSearchFilter) {
                        rbg.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class));
                    }
                } else {
                    ComboBox cb = new ComboBox();
                    hl.addComponent((Component)cb);
                    captionOwner = cb;
                    this.addErrorHandler(field, (AbstractComponent)cb);
                    r = cb;
                    cb.addStyleName("combo");
                    if (field.isAnnotationPresent(Width.class)) {
                        cb.setWidth(((Width)field.getAnnotation(Width.class)).value());
                    }
                    if (allFieldContainers != null && allFieldContainers.size() == 0) {
                        cb.focus();
                    }
                    hv = cb;
                    JPAManyToOneFieldBuilder.setDataProvider((HasItems)cb, field, binder);
                }
            }
            if (!forSearchFilter && !field.isAnnotationPresent(UseRadioButtons.class)) {
                hv.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class));
                if (field.getType().isAnnotationPresent(Entity.class)) {
                    com.vaadin.data.provider.DataProvider dpx;
                    Button b = null;
                    Object object2 = hv instanceof ComboBox ? ((ComboBox)hv).getDataProvider() : (dpx = hv instanceof RadioButtonGroup ? ((RadioButtonGroup)hv).getDataProvider() : null);
                    if (dpx != null && dpx instanceof JPQLListDataProvider) {
                        b = new Button(null, (Resource)VaadinIcons.REFRESH);
                        b.addStyleName("quiet");
                        b.addStyleName("nopadding");
                        b.addClickListener((Button.ClickListener & Serializable)e -> ((JPQLListDataProvider)dpx).refresh());
                        hl.addComponent((Component)b);
                    }
                    b = new Button(null, (Resource)VaadinIcons.SEARCH);
                    b.addStyleName("quiet");
                    b.addStyleName("nopadding");
                    b.addClickListener((Button.ClickListener & Serializable)e -> MDDUIAccessor.go((String)(field.getName() + "_search")));
                    hl.addComponent((Component)b);
                    if (!MDD.isReadWrite((Class)field.getType())) {
                        botonLink = new Button(null, (Resource)VaadinIcons.EXTERNAL_LINK);
                        botonLink.addStyleName("quiet");
                        botonLink.addStyleName("nopadding");
                        botonLink.addClickListener((Button.ClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
                        botonLink.setVisible(false);
                        hl.addComponent((Component)botonLink);
                    }
                }
            }
        }
        if (allFieldContainers != null) {
            allFieldContainers.put(field, (Component)tf);
        }
        captionOwner.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
        Binder.Binding binding = this.bind(binder, (HasValue)hv, field, forSearchFilter, dp, (AbstractComponent)captionOwner, (Converter)converter, botonLink);
        return r;
    }

    public static void setDataProvider(final HasItems hdp, FieldInterfaced field, MDDBinder binder) {
        try {
            JPAHelper.notransact(em -> {
                Method micg;
                com.vaadin.data.provider.DataProvider dp = null;
                ItemCaptionGenerator & Serializable icg = null;
                DataProvider dpa = field.isAnnotationPresent(DataProvider.class) ? (DataProvider)field.getAnnotation(DataProvider.class) : null;
                Method mdp = ReflectionHelper.getMethod((Class)field.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)field.getName()) + "DataProvider"));
                if (mdp != null) {
                    dp = (com.vaadin.data.provider.DataProvider)(mdp.getParameterCount() == 0 ? mdp.invoke(binder.getBean(), new Object[0]) : mdp.invoke(binder.getBean(), new Object[]{binder}));
                    if (mdp.isAnnotationPresent(DependsOn.class)) {
                        for (String fn : mdp.getAnnotation(DependsOn.class).value().split(",")) {
                            fn = fn.trim();
                            binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                                if (e.isUserOriginated() && binder.getBean() != null) {
                                    com.vaadin.data.provider.DataProvider dpx = null;
                                    try {
                                        Object bean;
                                        dpx = (com.vaadin.data.provider.DataProvider)(mdp.getParameterCount() == 0 ? mdp.invoke(binder.getBean(), new Object[0]) : mdp.invoke(binder.getBean(), new Object[]{binder}));
                                        if (hdp instanceof RadioButtonGroup) {
                                            ((RadioButtonGroup)hdp).setDataProvider(dpx);
                                        } else if (hdp instanceof CheckBoxGroup) {
                                            Object v;
                                            ((CheckBoxGroup)hdp).setDataProvider(dpx);
                                            Object bean2 = binder.getBean();
                                            if (bean2 != null && ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean2) != null && (v = ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean2)) != null && v instanceof Set) {
                                                ((CheckBoxGroup)hdp).setValue((Set)v);
                                            }
                                        } else if (hdp instanceof ComboBox) {
                                            ((ComboBox)hdp).setDataProvider(dpx, (SerializableFunction & Serializable)f -> new SerializablePredicate(){

                                                public boolean test(Object o) {
                                                    String s = (String)f;
                                                    return o != null && (Strings.isNullOrEmpty((String)s) || ((ComboBox)hdp).getItemCaptionGenerator().apply(o).toLowerCase().contains(s.toLowerCase()));
                                                }
                                            });
                                        } else if (hdp instanceof TwinColSelect) {
                                            ((TwinColSelect)hdp).setDataProvider(dpx);
                                        } else if (hdp instanceof Grid) {
                                            ((Grid)hdp).setDataProvider(dpx);
                                        }
                                        Object v = null;
                                        if (hdp instanceof ComboBox && field.isAnnotationPresent(NotNull.class) && ((ComboBox)hdp).getDataProvider().size(new com.vaadin.data.provider.Query()) == 1) {
                                            v = ((ComboBox)hdp).getDataProvider().fetch(new com.vaadin.data.provider.Query()).findFirst().get();
                                        }
                                        if ((bean = binder.getBean()) != null && ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean) == null) {
                                            ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, v);
                                            binder.update(bean);
                                        }
                                    }
                                    catch (Exception e1) {
                                        Notifier.alert((Throwable)e1);
                                    }
                                }
                            });
                        }
                    }
                } else if (dpa != null) {
                    try {
                        dp = (com.vaadin.data.provider.DataProvider)dpa.dataProvider().newInstance();
                    }
                    catch (InstantiationException e2) {
                        e2.printStackTrace();
                    }
                    catch (IllegalAccessException e3) {
                        e3.printStackTrace();
                    }
                } else {
                    dp = new JPQLListDataProvider(em, field);
                }
                if ((micg = ReflectionHelper.getMethod((Class)field.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)field.getName()) + "ItemCaptionGenerator"))) != null) {
                    icg = (ItemCaptionGenerator & Serializable)micg.invoke(binder.getBean(), new Object[0]);
                } else if (dpa != null) {
                    try {
                        icg = (ItemCaptionGenerator)dpa.itemCaptionGenerator().newInstance();
                    }
                    catch (InstantiationException e4) {
                        e4.printStackTrace();
                    }
                    catch (IllegalAccessException e5) {
                        e5.printStackTrace();
                    }
                } else {
                    FieldInterfaced fName = ReflectionHelper.getNameField((Class)field.getType());
                    if (fName != null) {
                        icg = (ItemCaptionGenerator & Serializable)i -> {
                            try {
                                return "" + ReflectionHelper.getValue((FieldInterfaced)fName, (Object)i);
                            }
                            catch (NoSuchMethodException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            return "Error";
                        };
                    }
                }
                if (hdp instanceof RadioButtonGroup) {
                    if (dp != null) {
                        ((RadioButtonGroup)hdp).setDataProvider(dp);
                    }
                    if (icg != null) {
                        ((RadioButtonGroup)hdp).setItemCaptionGenerator((ItemCaptionGenerator)icg);
                    }
                } else if (hdp instanceof CheckBoxGroup) {
                    if (dp != null) {
                        ((CheckBoxGroup)hdp).setDataProvider(dp);
                    }
                    if (icg != null) {
                        ((CheckBoxGroup)hdp).setItemCaptionGenerator((ItemCaptionGenerator)icg);
                    }
                } else if (hdp instanceof ComboBox) {
                    if (dp != null) {
                        ((ComboBox)hdp).setDataProvider(dp, (SerializableFunction & Serializable)f -> new SerializablePredicate(){

                            public boolean test(Object o) {
                                String s = (String)f;
                                return o != null && (Strings.isNullOrEmpty((String)s) || ((ComboBox)hdp).getItemCaptionGenerator().apply(o).toLowerCase().contains(s.toLowerCase()));
                            }
                        });
                    }
                    if (icg != null) {
                        ((ComboBox)hdp).setItemCaptionGenerator((ItemCaptionGenerator)icg);
                    }
                } else if (hdp instanceof TwinColSelect) {
                    if (dp != null) {
                        ((TwinColSelect)hdp).setDataProvider(dp);
                    }
                    if (icg != null) {
                        ((TwinColSelect)hdp).setItemCaptionGenerator((ItemCaptionGenerator)icg);
                    }
                } else if (hdp instanceof Grid && dp != null) {
                    ((Grid)hdp).setDataProvider(dp);
                }
                if (hdp instanceof ComboBox && field.isAnnotationPresent(NotNull.class)) {
                    com.vaadin.data.provider.Query q = new com.vaadin.data.provider.Query();
                    if (((ComboBox)hdp).getDataProvider().size(q) == 1) {
                        Object v = null;
                        v = ((ComboBox)hdp).getDataProvider().fetch(q).findFirst().get();
                        Object bean = binder.getBean();
                        if (bean != null && ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean) == null) {
                            ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, v);
                            binder.setBean(bean, false);
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            Notifier.alert((Throwable)t);
        }
    }

    public Object convert(String s) {
        return s;
    }

    public void addValidators(List<Validator> validators) {
    }

    protected Binder.Binding bind(MDDBinder binder, HasValue tf, FieldInterfaced field, boolean forSearchFilter, com.vaadin.data.provider.DataProvider dp, AbstractComponent captionOwner, Converter converter, Button botonLink) {
        Binder.BindingBuilder aux = binder.forField(tf);
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        if (converter != null) {
            aux.withConverter(converter);
        }
        Binder.Binding binding = JPAManyToOneFieldBuilder.completeBinding(aux, binder, field, captionOwner);
        if (dp != null && dp instanceof JPQLListDataProvider) {
            JPQLListDataProvider ldp = (JPQLListDataProvider)dp;
            binding.getField().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> ldp.refresh());
        }
        if (!forSearchFilter && field.getDeclaringClass() != null && field.getType().isAnnotationPresent(Entity.class)) {
            binding.getField().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                if (botonLink != null) {
                    botonLink.setVisible(e.getValue() != null);
                }
            });
        }
        if (botonLink != null) {
            botonLink.setVisible(tf.getValue() != null);
        }
        return binding;
    }

    private Object getInstance(FieldInterfaced field, Object rawValue) {
        if (rawValue == null || "".equals(rawValue)) {
            return null;
        }
        if (field.getType().isAssignableFrom(rawValue.getClass())) {
            return rawValue;
        }
        try {
            Object id = rawValue;
            if (rawValue instanceof String) {
                FieldInterfaced idField = ReflectionHelper.getIdField((Class)field.getType());
                if (Long.class.equals((Object)idField.getType()) || Long.TYPE.equals(idField.getType())) {
                    id = Long.parseLong((String)rawValue);
                }
                if (Integer.class.equals((Object)idField.getType()) || Integer.TYPE.equals(idField.getType())) {
                    id = Integer.parseInt((String)rawValue);
                }
            }
            return JPAHelper.find((Class)field.getType(), (Object)id);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }
}

