/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.server.Setter;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.interfaces.Card;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.DataProvider;
import io.mateu.mdd.shared.annotations.FullWidth;
import io.mateu.mdd.shared.annotations.Money;
import io.mateu.mdd.shared.annotations.UseTable;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAOneToManyFieldBuilder;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.money.MonetaryAmount;
import javax.persistence.Entity;
import org.javamoney.moneta.FastMoney;

public class JPAOutputFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return String.class.equals((Object)field.getType());
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        Component r = null;
        if (!forSearchFilter) {
            if (IResource.class.equals((Object)field.getGenericClass())) {
                VerticalLayout hl = new VerticalLayout();
                Label l = new Label("", ContentMode.HTML);
                hl.addComponent((Component)l);
                l.addStyleName("collectionlinklabel");
                hl.addStyleName("nopadding");
                hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                this.addComponent(container, (Component)hl, attachedActions.get(field.getName()));
                this.bindResourcesList(binder, l, field);
                if (allFieldContainers != null) {
                    allFieldContainers.put(field, (Component)hl);
                }
            } else if (Collection.class.isAssignableFrom(field.getType())) {
                if (Set.class.isAssignableFrom(field.getType())) {
                    Label l = new Label("", ContentMode.HTML);
                    l.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                    this.addComponent(container, (Component)l, attachedActions.get(field.getName()));
                    if (allFieldContainers != null) {
                        allFieldContainers.put(field, (Component)l);
                    }
                    JPAOneToManyFieldBuilder.bindSet(binder, l, field);
                } else {
                    Method mh = ReflectionHelper.getMethod((Class)field.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)field.getName()) + "Html"));
                    if (mh != null) {
                        VerticalLayout hl = new VerticalLayout();
                        hl.addStyleName("collectionlinklabel");
                        Label l = new Label("", ContentMode.HTML);
                        hl.addComponent((Component)l);
                        hl.addStyleName("nopadding");
                        hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                        this.addComponent(container, (Component)hl, attachedActions.get(field.getName()));
                        if (allFieldContainers != null) {
                            allFieldContainers.put(field, (Component)hl);
                        }
                        JPAOneToManyFieldBuilder.bind(binder, l, field, mh);
                    } else if (Card.class.isAssignableFrom(field.getGenericClass())) {
                        CssLayout hl = new CssLayout();
                        hl.addStyleName("collectionlinklabel");
                        hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                        this.addComponent(container, (Component)hl, attachedActions.get(field.getName()));
                        JPAOneToManyFieldBuilder.bind(binder, hl, field, mh, true);
                        if (allFieldContainers != null) {
                            allFieldContainers.put(field, (Component)hl);
                        }
                    } else {
                        DataProvider dpa;
                        Grid g = new Grid();
                        g.addStyleName("gridonetomany");
                        g.addStyleName("output");
                        String colsFilter = "";
                        if (field.isAnnotationPresent(UseTable.class)) {
                            colsFilter = ((UseTable)field.getAnnotation(UseTable.class)).fields();
                        }
                        List<FieldInterfaced> colFields = JPAOneToManyFieldBuilder.getColumnFields(field, colsFilter);
                        Class targetClass = field.getGenericClass();
                        boolean inline = false;
                        ListViewComponent.buildColumns(g, colFields, false, inline, binder, field);
                        g.setSelectionMode(attachedActions != null && attachedActions.size() > 0 ? Grid.SelectionMode.MULTI : Grid.SelectionMode.NONE);
                        g.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                        int ancho = 0;
                        for (Grid.Column col : g.getColumns()) {
                            ancho = (int)((double)ancho + col.getWidth());
                        }
                        if (ancho <= 0) {
                            ancho = 500;
                        }
                        boolean anchoCompleto = field.isAnnotationPresent(FullWidth.class) || ancho > 900;
                        anchoCompleto = false;
                        if (anchoCompleto) {
                            g.setWidth("100%");
                        } else {
                            g.setWidth("" + (ancho + 60) + "px");
                        }
                        if (anchoCompleto) {
                            if (g.getColumns().size() == 1) {
                                ((Grid.Column)g.getColumns().get(0)).setExpandRatio(1);
                            } else {
                                g.addColumn((ValueProvider & Serializable)d -> null).setWidthUndefined().setCaption("");
                            }
                        }
                        g.setHeightMode(HeightMode.UNDEFINED);
                        DataProvider dataProvider = dpa = field.isAnnotationPresent(DataProvider.class) ? (DataProvider)field.getAnnotation(DataProvider.class) : null;
                        if (dpa == null) {
                            Method method = ReflectionHelper.getMethod((Class)field.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)field.getName()) + "DataProvider"));
                        }
                        JPAOneToManyFieldBuilder.bind(binder, g, field, targetClass, null);
                        if (allFieldContainers != null) {
                            allFieldContainers.put(field, (Component)g);
                        }
                        this.addComponent(container, (Component)g, attachedActions.get(field.getName()));
                    }
                }
            } else {
                Button botonLink = null;
                Label tf = new Label();
                tf.setContentMode(ContentMode.HTML);
                tf.addStyleName("outputlabel");
                if (Integer.class.equals((Object)field.getType()) || Integer.TYPE.equals(field.getType()) || Long.class.equals((Object)field.getType()) || Long.TYPE.equals(field.getType()) || Double.class.equals((Object)field.getType()) || Double.TYPE.equals(field.getType()) || FastMoney.class.equals((Object)field.getType()) || MonetaryAmount.class.equals((Object)field.getType())) {
                    tf.addStyleName("alinearderecha");
                }
                if (field.getType().isAnnotationPresent(Entity.class)) {
                    HorizontalLayout hl = new HorizontalLayout();
                    hl.addStyleName("nopadding");
                    container.addComponent((Component)hl);
                    hl.setWidthUndefined();
                    tf.setValue("None");
                    hl.addComponent((Component)tf);
                    if (container.getComponentCount() > 0) {
                        hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                    }
                    botonLink = new Button("None");
                    botonLink.addStyleName("link");
                    botonLink.addClickListener((Button.ClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
                    botonLink.setVisible(false);
                    hl.addComponent((Component)botonLink);
                    if (allFieldContainers != null) {
                        allFieldContainers.put(field, (Component)hl);
                    }
                } else {
                    container.addComponent((Component)tf);
                    if (container.getComponentCount() > 0) {
                        tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                    }
                    if (allFieldContainers != null) {
                        allFieldContainers.put(field, (Component)tf);
                    }
                }
                this.bind(binder, tf, botonLink, field);
            }
        }
        return r;
    }

    private void bindResourcesList(MDDBinder binder, final Label l, FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField(new HasValue(){

            public void setValue(Object o) {
                if (o == null || ((Collection)o).size() == 0) {
                    l.setValue("Empty list");
                } else {
                    try {
                        String h = "<div class='freeTexts'>";
                        for (Object i : (Collection)o) {
                            IResource l2 = (IResource)i;
                            h = h + "<div class='line'>";
                            h = h + "<a href='" + l2.toFileLocator().getUrl() + "'>" + l2.getName() + "</a>";
                            h = h + "</div>";
                        }
                        h = h + "</div>";
                        l.setValue(h);
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                }
            }

            public Object getValue() {
                return null;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        });
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        aux.bind(field.getName());
    }

    protected void bind(MDDBinder binder, final Label tf, final Button botonLink, final FieldInterfaced field) {
        binder.forField((HasValue)new AbstractField(){
            Object v;

            protected void doSetValue(Object o) {
                this.v = o;
                if (field.isAnnotationPresent(Money.class)) {
                    o = new DecimalFormat("##,###,###,###,###,###.00").format(o != null ? o : Integer.valueOf(0));
                }
                tf.setValue(o != null ? JPAOutputFieldBuilder.this.objectToString(o) : "None");
                if (botonLink != null) {
                    tf.setVisible(o == null);
                    botonLink.setVisible(o != null);
                    botonLink.setCaption(o != null ? JPAOutputFieldBuilder.this.objectToString(o) : "None");
                }
            }

            public Object getValue() {
                return this.v;
            }
        }).bind((ValueProvider & Serializable)o -> {
            try {
                return ReflectionHelper.getValue((FieldInterfaced)field, (Object)o);
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
                return "";
            }
        }, (Setter & Serializable)(o, v) -> {});
    }

    private String objectToString(Object o) {
        if (o instanceof Collection) {
            String s = "";
            for (Object x : (Collection)o) {
                if (!"".equals(s)) {
                    s = s + "<br/>";
                }
                s = s + x.toString();
            }
            if ("".equals(s)) {
                s = s + "Empty list";
            }
            return s;
        }
        return o.toString();
    }
}

