/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAStringFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import java.util.List;
import java.util.Map;

public class JPAPrimitiveArraysFieldBuilder
extends JPAStringFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        boolean ok = field.getType().isArray();
        if (ok) {
            ok &= String[].class.equals((Object)field.getType()) || Integer[].class.equals((Object)field.getType()) || Long[].class.equals((Object)field.getType()) || Float[].class.equals((Object)field.getType()) || Double[].class.equals((Object)field.getType()) || Boolean[].class.equals((Object)field.getType()) || int[].class.equals((Object)field.getType()) || long[].class.equals((Object)field.getType()) || float[].class.equals((Object)field.getType()) || double[].class.equals((Object)field.getType()) || boolean[].class.equals((Object)field.getType());
        }
        return ok;
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        TextArea r = null;
        if (!forSearchFilter) {
            TextArea tf = field.isAnnotationPresent(io.mateu.mdd.shared.annotations.TextArea.class) ? new TextArea() : new TextField();
            container.addComponent((Component)tf);
            tf.setValueChangeMode(ValueChangeMode.BLUR);
            this.addErrorHandler(field, (AbstractComponent)tf);
            r = tf;
            if (allFieldContainers != null && allFieldContainers.size() == 0) {
                tf.focus();
            }
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)tf);
            }
            if (container.getComponentCount() > 0) {
                tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            }
            this.bind(binder, (AbstractTextField)tf, field);
        }
        return r;
    }

    protected void bind(MDDBinder binder, final AbstractTextField tf, final FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf).withConverter(new Converter(){

            public Result convertToModel(Object o, ValueContext valueContext) {
                Object[] r = null;
                String s = (String)o;
                if (!Strings.isNullOrEmpty((String)s)) {
                    String[] tokens = s.split(tf instanceof TextArea ? "\\\n" : "[, ]");
                    if (Integer[].class.equals((Object)field.getType())) {
                        Integer[] x = new Integer[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Integer(tokens[i]);
                        }
                        r = x;
                    } else if (int[].class.equals((Object)field.getType())) {
                        int[] x = new int[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Integer(tokens[i]);
                        }
                        r = x;
                    } else if (Long[].class.equals((Object)field.getType())) {
                        Long[] x = new Long[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Long(tokens[i]);
                        }
                        r = x;
                    } else if (long[].class.equals((Object)field.getType())) {
                        long[] x = new long[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Long(tokens[i]);
                        }
                        r = x;
                    } else if (Float[].class.equals((Object)field.getType())) {
                        Float[] x = new Float[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Float(tokens[i]);
                        }
                        r = x;
                    } else if (float[].class.equals((Object)field.getType())) {
                        float[] x = new float[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Float(tokens[i]).floatValue();
                        }
                        r = x;
                    } else if (Double[].class.equals((Object)field.getType())) {
                        Double[] x = new Double[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Double(tokens[i]);
                        }
                        r = x;
                    } else if (double[].class.equals((Object)field.getType())) {
                        double[] x = new double[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Double(tokens[i]);
                        }
                        r = x;
                    } else if (Boolean[].class.equals((Object)field.getType())) {
                        Boolean[] x = new Boolean[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Boolean(tokens[i]);
                        }
                        r = x;
                    } else if (boolean[].class.equals((Object)field.getType())) {
                        boolean[] x = new boolean[tokens.length];
                        for (int i = 0; i < tokens.length; ++i) {
                            x[i] = new Boolean(tokens[i]);
                        }
                        r = x;
                    } else if (String[].class.equals((Object)field.getType())) {
                        r = tokens;
                    }
                }
                return Result.ok(r);
            }

            public Object convertToPresentation(Object o, ValueContext valueContext) {
                String s;
                block22: {
                    s = "";
                    if (o == null) break block22;
                    if (o instanceof int[]) {
                        int[] col;
                        int[] nArray = col = (int[])o;
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            Integer v = nArray[i];
                            if (!"".equals(s)) {
                                s = s + (tf instanceof TextArea ? "\n" : ",");
                            }
                            s = s + v;
                        }
                    } else if (o instanceof long[]) {
                        long[] col;
                        long[] lArray = col = (long[])o;
                        int n = lArray.length;
                        for (int i = 0; i < n; ++i) {
                            Long v = lArray[i];
                            if (!"".equals(s)) {
                                s = s + (tf instanceof TextArea ? "\n" : ",");
                            }
                            s = s + v;
                        }
                    } else if (o instanceof float[]) {
                        float[] col;
                        float[] fArray = col = (float[])o;
                        int n = fArray.length;
                        for (int i = 0; i < n; ++i) {
                            Float v = Float.valueOf(fArray[i]);
                            if (!"".equals(s)) {
                                s = s + (tf instanceof TextArea ? "\n" : ",");
                            }
                            s = s + v;
                        }
                    } else if (o instanceof double[]) {
                        double[] col;
                        double[] dArray = col = (double[])o;
                        int n = dArray.length;
                        for (int i = 0; i < n; ++i) {
                            Double v = dArray[i];
                            if (!"".equals(s)) {
                                s = s + (tf instanceof TextArea ? "\n" : ",");
                            }
                            s = s + v;
                        }
                    } else if (o instanceof boolean[]) {
                        boolean[] col;
                        boolean[] blArray = col = (boolean[])o;
                        int n = blArray.length;
                        for (int i = 0; i < n; ++i) {
                            Boolean v = blArray[i];
                            if (!"".equals(s)) {
                                s = s + (tf instanceof TextArea ? "\n" : ",");
                            }
                            s = s + v;
                        }
                    } else {
                        Object[] col;
                        for (Object v : col = (Object[])o) {
                            if (!"".equals(s)) {
                                s = s + (tf instanceof TextArea ? "\n" : ",");
                            }
                            s = s + v;
                        }
                    }
                }
                return s;
            }
        });
        JPAPrimitiveArraysFieldBuilder.completeBinding(aux, binder, field);
    }
}

