/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasDataProvider;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.provider.Query;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.CheckBoxGroup;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TextField;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.dataProviders.JPQLListDataProvider;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.annotations.DataProvider;
import io.mateu.mdd.shared.annotations.TextArea;
import io.mateu.mdd.shared.annotations.ValueClass;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAStringFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.persistence.Entity;
import javax.validation.constraints.NotNull;

public class JPAPrimitiveCollectionsFieldBuilder
extends JPAStringFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        boolean ok = Collection.class.isAssignableFrom(field.getType());
        if (ok) {
            Class gc = ReflectionHelper.getGenericClass((FieldInterfaced)field, Collection.class, (String)"E");
            ok &= String.class.equals((Object)gc) || Integer.class.equals((Object)gc) || Long.class.equals((Object)gc) || Float.class.equals((Object)gc) || Double.class.equals((Object)gc) || Boolean.class.equals((Object)gc);
        }
        return ok;
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        CheckBoxGroup r = null;
        if (!forSearchFilter) {
            Method mdp = ReflectionHelper.getMethod((Class)field.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)field.getName()) + "DataProvider"));
            if (field.isAnnotationPresent(ValueClass.class) || field.isAnnotationPresent(DataProvider.class) || mdp != null) {
                CheckBoxGroup rbg;
                CheckBoxGroup tf = null;
                CheckBoxGroup hv = null;
                tf = rbg = new CheckBoxGroup();
                container.addComponent((Component)rbg);
                this.addErrorHandler(field, (AbstractComponent)rbg);
                r = rbg;
                hv = rbg;
                if (mdp != null) {
                    try {
                        ((HasDataProvider)tf).setDataProvider((com.vaadin.data.provider.DataProvider)mdp.invoke(object, new Object[0]));
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                } else if (field.isAnnotationPresent(ValueClass.class)) {
                    ValueClass a = (ValueClass)field.getAnnotation(ValueClass.class);
                    ((HasDataProvider)tf).setDataProvider((com.vaadin.data.provider.DataProvider)new JPQLListDataProvider(a.value()));
                } else if (field.isAnnotationPresent(DataProvider.class)) {
                    try {
                        DataProvider a = (DataProvider)field.getAnnotation(DataProvider.class);
                        ((HasDataProvider)tf).setDataProvider((com.vaadin.data.provider.DataProvider)a.dataProvider().newInstance());
                        rbg.setItemCaptionGenerator((ItemCaptionGenerator)a.itemCaptionGenerator().newInstance());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        JPAHelper.notransact(em -> rbg.setDataProvider((com.vaadin.data.provider.DataProvider)new JPQLListDataProvider(em, field)));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    FieldInterfaced fName = ReflectionHelper.getNameField((Class)field.getType());
                    if (fName != null) {
                        rbg.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)i -> {
                            try {
                                return "" + ReflectionHelper.getValue((FieldInterfaced)fName, (Object)i);
                            }
                            catch (NoSuchMethodException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            return "Error";
                        });
                    }
                }
                if (!forSearchFilter) {
                    rbg.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class));
                }
                if (allFieldContainers != null) {
                    allFieldContainers.put(field, (Component)tf);
                }
                if (container.getComponentCount() > 0) {
                    tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                }
                this.bind(binder, (HasValue)hv, field, forSearchFilter);
            } else {
                com.vaadin.ui.TextArea tf = field.isAnnotationPresent(TextArea.class) ? new com.vaadin.ui.TextArea() : new TextField();
                container.addComponent((Component)tf);
                tf.setValueChangeMode(ValueChangeMode.BLUR);
                this.addErrorHandler(field, (AbstractComponent)tf);
                r = tf;
                if (allFieldContainers != null && allFieldContainers.size() == 0) {
                    tf.focus();
                }
                if (allFieldContainers != null) {
                    allFieldContainers.put(field, (Component)tf);
                }
                if (container.getComponentCount() > 0) {
                    tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                }
                this.bind(binder, (AbstractTextField)tf, field);
            }
        }
        return r;
    }

    protected void bind(MDDBinder binder, final AbstractTextField tf, final FieldInterfaced field) {
        HasValue hv = new HasValue(){

            public void setValue(Object o) {
                String s = "";
                if (o != null) {
                    Collection col = (Collection)o;
                    for (Object v : col) {
                        if (!"".equals(s)) {
                            s = s + (tf instanceof com.vaadin.ui.TextArea ? "\n" : ",");
                        }
                        s = s + v;
                    }
                }
                tf.setValue(s);
            }

            public Object getValue() {
                AbstractCollection col = Set.class.isAssignableFrom(field.getType()) ? new HashSet() : new ArrayList();
                Class gc = ReflectionHelper.getGenericClass((FieldInterfaced)field, Collection.class, (String)"E");
                if (!Strings.isNullOrEmpty((String)tf.getValue())) {
                    for (String s : tf.getValue().split(tf instanceof com.vaadin.ui.TextArea ? "\\\n" : ",")) {
                        s = s.trim();
                        if (Integer.class.equals((Object)gc)) {
                            col.add(new Integer(s));
                            continue;
                        }
                        if (Long.class.equals((Object)gc)) {
                            col.add(new Long(s));
                            continue;
                        }
                        if (Double.class.equals((Object)gc)) {
                            col.add(new Double(s));
                            continue;
                        }
                        if (Float.class.equals((Object)gc)) {
                            col.add(new Float(s));
                            continue;
                        }
                        if (Boolean.class.equals((Object)gc)) {
                            col.add(new Boolean(s));
                            continue;
                        }
                        if (!String.class.equals((Object)gc)) continue;
                        col.add(s);
                    }
                }
                return col;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return tf.addValueChangeListener(valueChangeListener);
            }

            public void setRequiredIndicatorVisible(boolean b) {
                tf.setRequiredIndicatorVisible(b);
            }

            public boolean isRequiredIndicatorVisible() {
                return tf.isRequiredIndicatorVisible();
            }

            public void setReadOnly(boolean b) {
                tf.setReadOnly(b);
            }

            public boolean isReadOnly() {
                return tf.isReadOnly();
            }
        };
        JPAPrimitiveCollectionsFieldBuilder.completeBinding(hv, binder, field);
    }

    @Override
    public void bind(MDDBinder binder, final HasValue tf, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField(tf);
        aux.withConverter(new Converter(){

            public Result convertToModel(Object o, ValueContext valueContext) {
                if (o != null) {
                    ArrayList s = new ArrayList();
                    for (Object x : (Collection)o) {
                        s.add(x.getClass().isAnnotationPresent(Entity.class) ? ReflectionHelper.getId(x) : x);
                    }
                    return Result.ok(s);
                }
                return Result.ok(null);
            }

            public Object convertToPresentation(Object o, ValueContext valueContext) {
                if (o == null) {
                    return new HashSet();
                }
                com.vaadin.data.provider.DataProvider dp = null;
                if (tf instanceof HasDataProvider) {
                    dp = ((HasDataProvider)tf).getDataProvider();
                } else if (tf instanceof ComboBox) {
                    dp = ((ComboBox)tf).getDataProvider();
                }
                if (dp != null) {
                    Collection col = (Collection)o;
                    HashSet<Object> s = new HashSet<Object>();
                    for (Object z : col) {
                        Optional<Object> optional = dp.fetch(new Query()).filter(x -> x.getClass().equals(z.getClass()) ? x.equals(z) : ReflectionHelper.getId((Object)x).equals(z)).findFirst();
                        if (!optional.isPresent()) continue;
                        s.add(optional.get());
                    }
                    return s;
                }
                return o;
            }
        });
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        JPAPrimitiveCollectionsFieldBuilder.completeBinding(aux, binder, field);
    }
}

