/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.components.ResourceComponent;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.interfaces.Translated;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class JPAResourceFieldBuilder
extends AbstractFieldBuilder {
    private Translated literal;

    @Override
    public boolean isSupported(FieldInterfaced field) {
        return IResource.class.isAssignableFrom(field.getType());
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        ResourceComponent c = new ResourceComponent(field, binder);
        container.addComponent((Component)c);
        if (allFieldContainers.size() == 0) {
            c.focus();
        }
        allFieldContainers.put(field, (Component)c);
        if (container.getComponentCount() > 0) {
            c.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
        }
        if (!forSearchFilter) {
            c.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotEmpty.class));
        }
        this.bind(binder, c, field, forSearchFilter);
        this.addErrorHandler(field, (AbstractComponent)c);
        return c;
    }

    protected void bind(MDDBinder binder, ResourceComponent c, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField(c);
        JPAResourceFieldBuilder.completeBinding(aux, binder, field);
    }
}

