/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Resource;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TextArea;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAStringFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class JPATextAreaFieldBuilder
extends JPAStringFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return field.isAnnotationPresent(io.mateu.mdd.shared.annotations.TextArea.class);
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, final Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        Component r = null;
        if (forSearchFilter) {
            r = super.build(field, object, container, binder, validators, stylist, allFieldContainers, forSearchFilter, attachedActions);
        } else {
            HorizontalLayout l = new HorizontalLayout();
            final TextArea tf = new TextArea();
            l.addComponent((Component)tf);
            tf.setWidth("370px");
            this.addErrorHandler(field, (AbstractComponent)tf);
            r = tf;
            if (allFieldContainers != null && allFieldContainers.size() == 0) {
                tf.focus();
            }
            Button b = new Button((Resource)VaadinIcons.EXPAND_SQUARE);
            l.addComponent((Component)b);
            b.addStyleName("quiet");
            b.addClickListener((Button.ClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
            container.addComponent((Component)l);
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)tf);
            }
            if (container.getComponentCount() > 0) {
                l.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            }
            validators.put((HasValue)tf, new ArrayList());
            tf.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){

                public void valueChange(HasValue.ValueChangeEvent<String> valueChangeEvent) {
                    Validator v;
                    ValidationResult result = null;
                    Iterator iterator = ((List)validators.get(tf)).iterator();
                    while (iterator.hasNext() && !(result = (v = (Validator)iterator.next()).apply(valueChangeEvent.getValue(), new ValueContext((Component)tf))).isError()) {
                    }
                    if (result != null && result.isError()) {
                        tf.setComponentError((ErrorMessage)new UserError(result.getErrorMessage()));
                    } else {
                        tf.setComponentError(null);
                    }
                }
            });
            tf.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotEmpty.class));
            if (field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotEmpty.class)) {
                validators.get(tf).add((Validator)new StringLengthValidator("Required field", Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            }
            Binder.BindingBuilder aux = binder.forField((HasValue)tf);
            if (!forSearchFilter && field.getDeclaringClass() != null) {
                aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
            }
            this.addErrorHandler(field, (AbstractComponent)tf);
            JPATextAreaFieldBuilder.completeBinding(aux, binder, field);
        }
        return r;
    }
}

