/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.server.Page;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TextField;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class JPAURLFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        return URL.class.equals((Object)field.getType());
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        TextField tf = new TextField();
        container.addComponent((Component)tf);
        tf.setValueChangeMode(ValueChangeMode.BLUR);
        this.addErrorHandler(field, (AbstractComponent)tf);
        Button b = new Button("Go", (Button.ClickListener & Serializable)e -> {
            if (!Strings.isNullOrEmpty((String)tf.getValue())) {
                Page.getCurrent().open(tf.getValue(), "_blank");
            }
        });
        HorizontalLayout hl = new HorizontalLayout(new Component[]{tf, b});
        container.addComponent((Component)hl);
        if (allFieldContainers != null && allFieldContainers.size() == 0) {
            tf.focus();
        }
        if (allFieldContainers != null) {
            allFieldContainers.put(field, (Component)tf);
        }
        if (container.getComponentCount() > 0) {
            hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
        }
        if (!forSearchFilter) {
            tf.setRequiredIndicatorVisible(field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotEmpty.class));
        }
        this.bind(binder, tf, field, forSearchFilter);
        return tf;
    }

    protected void bind(MDDBinder binder, TextField tf, FieldInterfaced field, boolean forSearchFilter) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf).withConverter(new Converter(){

            public Result convertToModel(Object o, ValueContext valueContext) {
                URL u = null;
                try {
                    if (!Strings.isNullOrEmpty((String)((String)o))) {
                        u = new URL((String)o);
                    }
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
                return Result.ok(u);
            }

            public Object convertToPresentation(Object o, ValueContext valueContext) {
                return o != null ? o.toString() : "";
            }
        });
        if (!forSearchFilter && field.getDeclaringClass() != null) {
            aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        }
        aux.bind(field.getName());
    }
}

