/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders.components;

import com.google.common.base.Strings;
import com.vaadin.data.HasValue;
import com.vaadin.event.MouseEvents;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ClassResource;
import com.vaadin.server.FileResource;
import com.vaadin.server.Resource;
import com.vaadin.shared.Registration;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Link;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.shared.VaadinHelper;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.util.notification.Notifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileComponent
extends Composite
implements HasValue<File>,
Component.Focusable {
    private static final Logger log = LoggerFactory.getLogger(FileComponent.class);
    private final MDDBinder binder;
    private final Link hyperLink;
    private final Upload upload;
    private final Image image;
    private File file;
    private Map<UUID, HasValue.ValueChangeListener> listeners = new HashMap<UUID, HasValue.ValueChangeListener>();

    public FileComponent(FieldInterfaced field, MDDBinder binder) {
        this.binder = binder;
        class MyUploader
        implements Upload.Receiver,
        Upload.SucceededListener {
            public File filex;

            MyUploader() {
            }

            public OutputStream receiveUpload(String fileName, String mimeType) {
                System.out.println("receiveUpload(" + fileName + "," + mimeType + ")");
                FileOutputStream os = null;
                if (fileName != null && !"".equals(fileName)) {
                    String extension = ".tmp";
                    if (fileName.lastIndexOf(".") < fileName.length() - 1) {
                        extension = fileName.substring(fileName.lastIndexOf("."));
                        fileName = fileName.substring(0, fileName.lastIndexOf("."));
                    }
                    File temp = null;
                    try {
                        this.filex = temp = File.createTempFile(fileName, extension);
                        os = new FileOutputStream(this.filex);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return os;
            }

            public void uploadSucceeded(Upload.SucceededEvent event) {
                String baseUrl = System.getProperty("tmpurl");
                URL url = null;
                try {
                    url = baseUrl == null ? this.filex.toURI().toURL() : new URL(baseUrl + "/" + this.filex.getName());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                System.out.println("uploadSucceeded(" + this.filex.getAbsolutePath() + ")");
                try {
                    FileComponent.this.file = this.filex;
                    HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent((Component)FileComponent.this, (Object)FileComponent.this, true);
                    FileComponent.this.listeners.values().forEach(l -> l.valueChange(ce));
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }
        }
        MyUploader receiver = new MyUploader();
        this.upload = new Upload(null, (Upload.Receiver)receiver);
        this.upload.addSucceededListener((Upload.SucceededListener)receiver);
        HorizontalLayout h = new HorizontalLayout();
        h.setSpacing(true);
        this.hyperLink = new Link();
        h.addComponent((Component)this.hyperLink);
        this.image = new Image();
        h.addComponent((Component)this.image);
        this.image.setWidth("130px");
        this.image.setVisible(false);
        this.image.addClickListener((MouseEvents.ClickListener & Serializable)e -> {
            if (this.file != null) {
                String u = null;
                try {
                    u = VaadinHelper.getAdaptedUIRootPath();
                    if (!u.endsWith("/")) {
                        u = u + "/";
                    }
                    u = u + "APP/connector/0/" + this.image.getConnectorId() + "/source/" + new FileResource(this.file).getFilename();
                }
                catch (Exception e1) {
                    Notifier.alert((Throwable)e1);
                }
                if (!Strings.isNullOrEmpty((String)u)) {
                    this.getUI().getPage().open(u, "_blank");
                }
            }
        });
        VerticalLayout v = new VerticalLayout();
        h.addComponent((Component)v);
        v.addStyleName("nopadding");
        v.addComponent((Component)new Button((Resource)VaadinIcons.CLOSE, new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                if (FileComponent.this.file != null) {
                    FileComponent.this.file = null;
                }
                HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent((Component)FileComponent.this, (Object)FileComponent.this, true);
                FileComponent.this.listeners.values().forEach(l -> l.valueChange(ce));
            }
        }));
        v.addComponent((Component)this.upload);
        this.hyperLink.setTargetName("_blank");
        this.setCompositionRoot((Component)h);
        this.upload.addChangeListener((Upload.ChangeListener & Serializable)e -> System.out.println("UPLOAD HA CAMBIADO!"));
    }

    public void setValue(File o) {
        this.file = o;
        try {
            boolean esFoto = false;
            if (this.file != null && this.file.getName() != null && (this.file.getName().toLowerCase().endsWith(".jpg") || this.file.getName().toLowerCase().endsWith(".jpeg") || this.file.getName().toLowerCase().endsWith(".gif") || this.file.getName().toLowerCase().endsWith(".png") || this.file.getName().toLowerCase().endsWith(".svg") || this.file.getName().toLowerCase().endsWith(".webp"))) {
                this.hyperLink.setVisible(false);
                this.image.setVisible(true);
                this.image.setSource((Resource)(this.file != null ? new FileResource(this.file) : new ClassResource("/images/noimage.png")));
            } else {
                this.hyperLink.setCaption(this.file != null ? this.file.getName() : null);
                this.hyperLink.setResource((Resource)(this.file != null ? new FileResource(this.file) : new ClassResource("/images/noimage.png")));
                this.hyperLink.setVisible(true);
                this.image.setVisible(false);
            }
            if (this.file == null) {
                this.image.setVisible(true);
                this.hyperLink.setVisible(false);
                this.image.setSource((Resource)new ClassResource("/images/noimage.png"));
            }
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
        this.upload.setComponentError(null);
    }

    public File getValue() {
        return this.file;
    }

    public void setRequiredIndicatorVisible(boolean b) {
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }

    public void setReadOnly(boolean b) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<File> valueChangeListener) {
        final UUID _id = UUID.randomUUID();
        this.listeners.put(_id, valueChangeListener);
        return new Registration(){
            UUID id;
            {
                this.id = _id;
            }

            public void remove() {
                FileComponent.this.listeners.remove(this.id);
            }
        };
    }

    public void focus() {
        this.upload.focus();
    }

    public int getTabIndex() {
        return this.upload.getTabIndex();
    }

    public void setTabIndex(int i) {
        this.upload.setTabIndex(i);
    }
}

