/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders.components;

import com.google.common.base.Strings;
import com.vaadin.data.HasValue;
import com.vaadin.event.LayoutEvents;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.GeneralRepository;
import io.mateu.util.interfaces.IIcon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class IconComponent
extends Composite
implements HasValue<IIcon>,
Component.Focusable {
    private final MDDBinder binder;
    private final Button b;
    private List<IIcon> icons;
    private IIcon icon;
    private Map<UUID, HasValue.ValueChangeListener> listeners = new HashMap<UUID, HasValue.ValueChangeListener>();

    public IconComponent(FieldInterfaced field, MDDBinder binder) {
        this.binder = binder;
        try {
            this.icons = ((GeneralRepository)Helper.getImpl(GeneralRepository.class)).findAllIcons();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.icons = new ArrayList<IIcon>();
        }
        this.b = new Button();
        this.b.setCaptionAsHtml(true);
        this.b.addClickListener((Button.ClickListener & Serializable)e -> this.abrirListaIconos());
        this.setCompositionRoot((Component)this.b);
    }

    private void abrirListaIconos() {
        Window w = new Window("Select an Icon");
        w.addStyleName("miapp");
        w.setWidth("700px");
        w.setHeight("600px");
        CssLayout l = new CssLayout();
        VerticalLayout vl = new VerticalLayout();
        TextField tf = new TextField();
        vl.addComponent((Component)tf);
        tf.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.rellenar(l, (String)e.getValue(), w));
        this.rellenar(l, "", w);
        l.setSizeUndefined();
        vl.addComponent((Component)l);
        w.setContent((Component)new Panel((Component)vl));
        w.center();
        w.setModal(true);
        w.addCloseListener((Window.CloseListener & Serializable)e -> {});
        UI.getCurrent().addWindow(w);
    }

    private void rellenar(CssLayout l, String text, Window w) {
        try {
            l.removeAllComponents();
            this.icons.stream().filter(i -> Strings.isNullOrEmpty((String)text) || i.getId().toLowerCase().contains(text.toLowerCase())).forEach(i -> {
                VerticalLayout c = new VerticalLayout();
                l.addComponent((Component)c);
                Label h = new Label(i.getHtml(), ContentMode.HTML);
                c.addComponent((Component)h);
                h.addStyleName("icono");
                c.addComponent((Component)new Label(i.getId()));
                c.setSizeUndefined();
                c.addStyleName("cardicono");
                c.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> {
                    IIcon old = this.icon;
                    this.setValue((IIcon)i);
                    HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent((Component)this, (Object)old, true);
                    this.listeners.values().forEach(x -> x.valueChange(ce));
                    w.close();
                });
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setValue(IIcon o) {
        this.icon = o;
        this.b.setCaption(this.icon != null ? this.icon.getHtml() : VaadinIcons.QUESTION.getHtml());
    }

    public IIcon getValue() {
        return this.icon;
    }

    public void setRequiredIndicatorVisible(boolean b) {
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }

    public void setReadOnly(boolean b) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<IIcon> valueChangeListener) {
        final UUID _id = UUID.randomUUID();
        this.listeners.put(_id, valueChangeListener);
        return new Registration(){
            UUID id;
            {
                this.id = _id;
            }

            public void remove() {
                IconComponent.this.listeners.remove(this.id);
            }
        };
    }

    public void focus() {
        this.b.focus();
    }

    public int getTabIndex() {
        return this.b.getTabIndex();
    }

    public void setTabIndex(int i) {
        this.b.setTabIndex(i);
    }
}

