/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.base.Strings;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.vaadin.actions.AcctionRunner;
import io.mateu.mdd.vaadin.components.ComponentWrapper;
import io.mateu.mdd.vaadin.components.HomeComponent;
import io.mateu.mdd.vaadin.components.app.views.firstLevel.AreaComponent;
import io.mateu.mdd.vaadin.components.app.views.firstLevel.MenuComponent;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.SearchInMenuComponent;
import io.mateu.mdd.vaadin.navigation.View;
import io.mateu.mdd.vaadin.navigation.ViewStack;
import io.mateu.mdd.vaadin.util.VaadinHelper;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public abstract class AbstractViewComponent<A extends AbstractViewComponent<A>>
extends VerticalLayout {
    private final String uuid = UUID.randomUUID().toString();
    private VaadinIcons icon;
    private Component header;
    private Label titleLabel;
    private CssLayout kpisContainer;
    private View view;
    protected CssLayout bar;
    protected CssLayout subheader;
    protected Map<Method, AbstractAction> actionsByMethod = new HashMap<Method, AbstractAction>();
    protected Map<String, Component> menuItemsById = new HashMap<String, Component>();
    protected Map<String, List<Component>> menuItemsByGroup = new HashMap<String, List<Component>>();
    protected List<String> menuItemIdsUnseen = new ArrayList<String>();
    private String title;
    private HorizontalLayout hiddens;
    private boolean backable;
    private boolean built;
    private AbstractViewComponent parentView;
    private Label iconLabel;
    private Component backButton;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractViewComponent that = (AbstractViewComponent)((Object)o);
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uuid);
    }

    public AbstractViewComponent getParentView() {
        return this.parentView;
    }

    public VaadinIcons getIcon() {
        return this.icon;
    }

    public void setIcon(VaadinIcons icon) {
        this.icon = icon;
    }

    public void setParentView(AbstractViewComponent parentView) {
        this.parentView = parentView;
    }

    public CssLayout getKpisContainer() {
        return this.kpisContainer;
    }

    public boolean esForm() {
        return false;
    }

    public void addActionsBar(boolean top) {
        if (!this.isBarHidden()) {
            this.bar = new CssLayout();
            if (top) {
                this.bar.addStyleName("actionsbar");
            } else {
                this.bar.addStyleName("formactionsbar");
            }
            this.bar.addStyleName("nopadding");
            this.menuItemsById = new HashMap<String, Component>();
            this.addBack(this.bar);
            this.getActionsContainer().addComponent((Component)this.bar);
        }
    }

    public void hideHeader() {
        this.header.setVisible(false);
    }

    public boolean expandOnOpen() {
        return false;
    }

    private Component createHeader() {
        HorizontalLayout l = new HorizontalLayout();
        l.addStyleName("viewHeader");
        l.addComponent(this.createTitleLabel());
        this.hiddens = new HorizontalLayout();
        this.hiddens.addStyleName("hidden");
        l.addComponent((Component)this.hiddens);
        return l;
    }

    public void setStack(ViewStack stack) {
        boolean add = false;
        int pos = 0;
        if (!add && stack.size() > 0) {
            while (!add && pos < stack.size()) {
                View v = stack.get(pos);
                Component c = v.getComponent();
                if (!(c instanceof AreaComponent || c instanceof SearchInMenuComponent || c instanceof MenuComponent || c instanceof HomeComponent)) {
                    add = true;
                }
                if (!(add || !(c instanceof ComponentWrapper) || ((ComponentWrapper)c).getComponentCount() <= 0 || (c = ((ComponentWrapper)c).getComponent(0)) instanceof AreaComponent || c instanceof SearchInMenuComponent || c instanceof MenuComponent || c instanceof HomeComponent)) {
                    add = true;
                }
                if (add) continue;
                ++pos;
            }
        }
        if (add && this instanceof AbstractViewComponent) {
            this.setBackable(true);
            if (this instanceof EditorViewComponent) {
                ((EditorViewComponent)this).setKpisContainer((Layout)this.kpisContainer);
                ((EditorViewComponent)this).buildIfNeeded();
                ((EditorViewComponent)this).rebuildActions();
            }
        }
    }

    private Component createTitleLabel() {
        this.iconLabel = new Label("", ContentMode.HTML);
        this.iconLabel.addStyleName("viewIcon");
        this.titleLabel = new Label("", ContentMode.HTML);
        this.titleLabel.addStyleName("viewTitle");
        this.kpisContainer = new CssLayout();
        this.kpisContainer.addStyleName("nopadding");
        this.kpisContainer.addStyleName("kpisContainer");
        this.kpisContainer.setSizeUndefined();
        if (this.getIcon() != null) {
            this.iconLabel.setValue(this.getIcon().getHtml());
        } else {
            this.iconLabel.setVisible(false);
        }
        HorizontalLayout hl = new HorizontalLayout(new Component[]{this.iconLabel, this.titleLabel, this.kpisContainer});
        hl.addStyleName("nopadding");
        return hl;
    }

    public void updateViewTitle(String newTitle) {
        this.title = newTitle;
        this.updatePageTitle();
    }

    public void updatePageTitle() {
        if (this.titleLabel != null) {
            this.titleLabel.setValue(this.getTitle());
        }
        if (this.iconLabel != null) {
            if (this.getIcon() != null) {
                this.iconLabel.setValue(this.getIcon().getHtml());
                this.iconLabel.setVisible(true);
            } else {
                this.iconLabel.setVisible(false);
            }
        }
    }

    public HorizontalLayout getHiddens() {
        return this.hiddens;
    }

    public String getTitle() {
        return this.title != null ? this.title : ((Object)((Object)this)).toString();
    }

    public String getPageTitle() {
        return this.getTitle();
    }

    public A setTitle(String title) {
        this.title = title;
        return (A)((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public Layout getActionsContainer() {
        return this;
    }

    public A buildIfNeeded() {
        if (!this.built) {
            try {
                this.build();
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
        return (A)((Object)this);
    }

    public A build() throws Exception {
        this.addStyleName("viewcomponent");
        this.header = this.createHeader();
        this.addComponent(this.header);
        if (!this.esForm()) {
            this.addActionsBar(true);
        }
        this.subheader = new CssLayout();
        this.addComponent((Component)this.subheader);
        this.subheader.addStyleName("nopadding");
        this.subheader.setWidth("100%");
        this.subheader.setVisible(false);
        if (!this.esForm()) {
            this.addViewActionsMenuItems(this.bar);
        }
        this.built = true;
        return (A)((Object)this);
    }

    private void addBack(CssLayout bar) {
        if (!this.isActionPresent("back")) {
            Button b = new Button("", (Resource)VaadinIcons.ARROW_LEFT);
            this.backButton = b;
            bar.addComponent((Component)b);
            b.addStyleName("quiet");
            b.addClickListener((Button.ClickListener & Serializable)e -> {
                try {
                    if (this.beforeBack()) {
                        MDDUIAccessor.goBack();
                    }
                }
                catch (Throwable throwable) {
                    Notifier.alert((Throwable)throwable);
                }
            });
            this.addMenuItem("back", this.backButton);
        } else {
            this.backButton = this.getMenuItemById("back");
        }
        if (this.isBackable()) {
            this.backButton.setVisible(true);
        }
    }

    public void addViewActionsMenuItems(CssLayout bar) {
        if (this.isActionPresent("back")) {
            this.getMenuItemById("back").setVisible(this.isBackable());
        }
        for (final AbstractAction a : this.getActions()) {
            Component i = null;
            if (!this.isActionPresent(a.getId())) {
                Button b = new Button(a.getCaption(), (Resource)a.getIcon());
                i = b;
                b.addStyleName("quiet");
                b.addClickListener((Button.ClickListener & Serializable)e -> {
                    try {
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    new AcctionRunner().run(a);
                                }
                                catch (Throwable ex) {
                                    Notifier.alert((Throwable)ex);
                                    AbstractViewComponent.this.removeStyleName("refreshonback");
                                }
                            }
                        };
                        if (!Strings.isNullOrEmpty((String)a.getConfirmationMessage())) {
                            VaadinHelper.confirm(a.getConfirmationMessage(), () -> r.run());
                        } else {
                            r.run();
                        }
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                });
                if (!Strings.isNullOrEmpty((String)a.getGroup())) {
                    this.menuItemsByGroup.computeIfAbsent(a.getGroup(), k -> new ArrayList()).add(i);
                }
                this.addMenuItem(a.getId(), i);
                if (!Strings.isNullOrEmpty((String)a.getStyle())) {
                    i.addStyleName(a.getStyle());
                }
                if (Strings.isNullOrEmpty((String)a.getGroup())) {
                    bar.addComponent(i);
                }
                a.addShortCut(b);
            } else {
                i = this.getMenuItemById(a.getId());
            }
            if (i != null && !Strings.isNullOrEmpty((String)a.getStyle())) {
                i.addStyleName(a.getStyle());
            }
            i.setVisible(a.isVisible());
        }
        if (bar != null && (bar.getComponentCount() == 0 || bar.getComponentCount() == 1 && !bar.getComponent(0).isVisible())) {
            bar.setVisible(false);
        }
    }

    public boolean beforeBack() {
        return true;
    }

    public void markAllAsUnseen() {
        this.menuItemIdsUnseen = new ArrayList<String>(this.menuItemsById.keySet());
    }

    public List<String> getUnseenActions() {
        return this.menuItemIdsUnseen;
    }

    public void removeUnseen() {
        for (String id : this.menuItemIdsUnseen) {
            this.menuItemsById.get(id).setVisible(false);
        }
    }

    public boolean isActionPresent(String id) {
        boolean found = this.menuItemsById.containsKey(id);
        if (found) {
            this.menuItemIdsUnseen.remove(id);
        }
        return found;
    }

    public Component getMenuItemById(String id) {
        return this.menuItemsById.get(id);
    }

    public void addMenuItem(String id, Component i) {
        this.menuItemsById.put(id, i);
    }

    public List<AbstractAction> getActions() {
        return new ArrayList<AbstractAction>();
    }

    public AbstractAction getActionByMethod(Method m) {
        return this.actionsByMethod.get(m);
    }

    public void setAction(Method m, AbstractAction action) {
        this.actionsByMethod.put(m, action);
    }

    public boolean isBackable() {
        return this.backable;
    }

    public void setBackable(boolean backable) {
        this.backable = backable;
        if (this.backButton != null) {
            this.backButton.setVisible(backable);
        }
    }

    public boolean isBarHidden() {
        return false;
    }
}

