/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.vaadin.data.HasValue;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.FormLayoutBuilderParameters;
import io.mateu.mdd.shared.annotations.MainSearchFilter;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.views.FormLayoutBuilder;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.data.Pair;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersComponent
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(FiltersComponent.class);
    private final ListViewComponent listViewComponent;
    private final Class modelType;
    private MDDBinder binder;
    private Component allFiltersComponent;

    public MDDBinder getBinder() {
        return this.binder;
    }

    public FiltersComponent(ListViewComponent listViewComponent) throws IllegalAccessException, InstantiationException {
        this.listViewComponent = listViewComponent;
        this.modelType = listViewComponent.getFiltersType();
        this.build();
    }

    private void build() {
        long t0 = System.currentTimeMillis();
        CssLayout l = new CssLayout();
        CssLayout pl = MDDUIAccessor.isMobile() ? l : new CssLayout(new Component[]{l});
        this.setCompositionRoot((Component)pl);
        l.addStyleName("nopadding");
        pl.addStyleName("nopadding");
        this.addStyleName("filterscomponent");
        this.binder = new MDDBinder(this.modelType);
        try {
            this.binder.setBean(this.listViewComponent.getModelForSearchFilters());
        }
        catch (Exception e2) {
            Notifier.alert((Throwable)e2);
        }
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.listViewComponent.setModelForSearchFilters(this.binder.getBean()));
        HashMap validators = new HashMap();
        List<FieldInterfaced> allFilterFields = this.getAllFilterFields();
        HorizontalLayout botones = new HorizontalLayout();
        if (!MDDUIAccessor.isMobile() && allFilterFields.size() > 0) {
            botones.addStyleName("botonerafiltros");
            botones.setSpacing(false);
        }
        if (allFilterFields.size() > 0) {
            List<Object> mainFilterFields = allFilterFields.stream().filter(f -> f.isAnnotationPresent(MainSearchFilter.class)).collect(Collectors.toList());
            if (mainFilterFields.size() == 0) {
                mainFilterFields = allFilterFields.size() > 1 ? allFilterFields.subList(0, allFilterFields.size() > 2 ? 2 : allFilterFields.size()) : allFilterFields;
            }
            Pair<Component, AbstractStylist> r = FormLayoutBuilder.get().build((Layout)l, this.binder, this.modelType, this.binder.getBean(), new ArrayList<Component>(), FormLayoutBuilderParameters.builder().validators(validators).allFields(mainFilterFields).forSearchFilters(true).createSections(false).createTabs(false).build(), null);
            VerticalLayout vl = new VerticalLayout();
            vl.addStyleName("nopadding");
            vl.setSpacing(false);
            botones.addComponent((Component)vl);
            Button b = new Button((Resource)VaadinIcons.CLOSE);
            vl.addComponent((Component)b);
            b.addStyleName("quiet");
            b.addStyleName("boton");
            b.addStyleName("buttonlink");
            b.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent clickEvent) {
                    try {
                        Object filters = FiltersComponent.this.modelType.newInstance();
                        FiltersComponent.this.listViewComponent.setModelForSearchFilters(filters);
                        FiltersComponent.this.listViewComponent.search(FiltersComponent.this.listViewComponent.getModelForSearchFilters());
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                }
            });
            if (mainFilterFields.size() < allFilterFields.size()) {
                r = FormLayoutBuilder.get().build(this.binder, this.modelType, this.binder.getBean(), new ArrayList<Component>(), FormLayoutBuilderParameters.builder().validators(validators).allFields(allFilterFields).forSearchFilters(true).forSearchFiltersExtended(true).build(), null);
                this.allFiltersComponent = (Component)r.getKey();
                b = new Button((Resource)VaadinIcons.FILTER);
                vl.addComponent((Component)b);
                b.addStyleName("quiet");
                b.addStyleName("boton");
                b.addStyleName("buttonlink");
                b.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        FiltersComponent.this.listViewComponent.setModelForSearchFilters(FiltersComponent.this.binder.getBean());
                        MDDUIAccessor.go((String)FiltersComponent.this.listViewComponent.getPathForFilters());
                    }
                });
                b.setClickShortcut(70, new int[]{17});
            }
        } else {
            ArrayList stringFieldNames = new ArrayList();
            ReflectionHelper.getAllFields((Class)this.modelType).forEach(f -> {
                if (String.class.equals((Object)f.getType())) {
                    stringFieldNames.add(f.getName());
                }
            });
            if (stringFieldNames.size() > 0) {
                TextField f2 = new TextField("Text");
                botones.addComponent((Component)f2);
                String ph = "";
                for (String s : stringFieldNames) {
                    if (!"".equals(ph)) {
                        ph = ph + "/";
                    }
                    ph = ph + s;
                }
                f2.setPlaceholder(ph);
                this.binder.bind((HasValue)f2, "anytext");
            }
        }
        Button b = new Button((Resource)VaadinIcons.SEARCH);
        botones.addComponent((Component)b);
        b.addStyleName("quiet");
        b.addStyleName("buttonlink");
        b.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                try {
                    FiltersComponent.this.listViewComponent.search(FiltersComponent.this.binder.getBean());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        b.setClickShortcut(13, new int[0]);
        b.addStyleName("principal");
        b.addStyleName("botonsearch");
        pl.addComponent((Component)botones);
        log.debug("filters component built in " + (System.currentTimeMillis() - t0) + " ms.");
    }

    private List<FieldInterfaced> getAllFilterFields() {
        List<FieldInterfaced> allFields = this.listViewComponent.getFilterFields();
        return allFields;
    }

    public Component getFiltersViewComponent() {
        return this.allFiltersComponent;
    }
}

