/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.base.Strings;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.MDD;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.interfaces.NakedObjectStylist;
import io.mateu.mdd.core.interfaces.ReadOnly;
import io.mateu.mdd.core.layout.MiFormLayout;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.FormLayoutBuilderParameters;
import io.mateu.mdd.shared.annotations.Balance;
import io.mateu.mdd.shared.annotations.EndTabs;
import io.mateu.mdd.shared.annotations.FieldGroup;
import io.mateu.mdd.shared.annotations.FullWidth;
import io.mateu.mdd.shared.annotations.KPI;
import io.mateu.mdd.shared.annotations.Money;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.SameLine;
import io.mateu.mdd.shared.annotations.Section;
import io.mateu.mdd.shared.annotations.SectionKPI;
import io.mateu.mdd.shared.annotations.StartTabs;
import io.mateu.mdd.shared.annotations.Stylist;
import io.mateu.mdd.shared.annotations.Tab;
import io.mateu.mdd.shared.annotations.Unmodifiable;
import io.mateu.mdd.shared.annotations.Width;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.actions.AcctionRunner;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.FieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAOutputFieldBuilder;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.FormLayoutGroup;
import io.mateu.mdd.vaadin.components.views.FormLayoutSection;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.data.Pair;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormLayoutBuilder {
    private static final Logger log = LoggerFactory.getLogger(FormLayoutBuilder.class);
    private static FormLayoutBuilder instance = new FormLayoutBuilder();

    public Pair<Component, AbstractStylist> build(MDDBinder binder, Class<?> modelType, Object model, List<Component> componentsToLookForErrors, FormLayoutBuilderParameters params, Map<String, List<AbstractAction>> attachedActions) {
        return this.build(null, binder, modelType, model, componentsToLookForErrors, params, attachedActions);
    }

    public Pair<Component, AbstractStylist> build(EditorViewComponent editor, MDDBinder binder, Class<?> modelType, Object model, List<Component> componentsToLookForErrors, FormLayoutBuilderParameters params, Map<String, List<AbstractAction>> attachedActions) {
        VerticalLayout contentContainer = null;
        contentContainer = new VerticalLayout();
        contentContainer.addStyleName("contentcontainer");
        contentContainer.addStyleName("nopadding");
        return this.build(editor, (Layout)contentContainer, binder, modelType, model, componentsToLookForErrors, params, attachedActions);
    }

    public Pair<Component, AbstractStylist> build(Layout contentContainer, MDDBinder binder, Class modelType, Object model, List<Component> componentsToLookForErrors, FormLayoutBuilderParameters params, Map<String, List<AbstractAction>> attachedActions) {
        return this.build(null, contentContainer, binder, modelType, model, componentsToLookForErrors, params, attachedActions);
    }

    public Pair<Component, AbstractStylist> build(EditorViewComponent editor, Layout contentContainer, MDDBinder binder, Class modelType, Object model, List<Component> componentsToLookForErrors, FormLayoutBuilderParameters params, Map<String, List<AbstractAction>> attachedActions) {
        long t0 = System.currentTimeMillis();
        NakedObjectStylist stylist = new NakedObjectStylist(modelType);
        if (modelType.isAnnotationPresent(Stylist.class)) {
            try {
                stylist = (AbstractStylist)modelType.getAnnotation(Stylist.class).value().newInstance();
            }
            catch (InstantiationException e2) {
                e2.printStackTrace();
            }
            catch (IllegalAccessException e3) {
                e3.printStackTrace();
            }
            catch (ClassCastException e4) {
                e4.printStackTrace();
            }
        }
        stylist.setViewTitle(Helper.capitalize((String)modelType.getSimpleName()));
        stylist.setUp(params.getAllFields());
        log.debug("editor component E.1 in " + (System.currentTimeMillis() - t0) + " ms.");
        HashMap<FieldInterfaced, Component> allFieldContainers = new HashMap<FieldInterfaced, Component>();
        JPAOutputFieldBuilder ofb = new JPAOutputFieldBuilder();
        TabSheet sectionTabSheet = null;
        if (params.isCreateSections()) {
            ArrayList<FormLayoutSection> sections = new ArrayList<FormLayoutSection>();
            HashMap<String, FormLayoutSection> sectionsByCaption = new HashMap<String, FormLayoutSection>();
            FormLayoutSection section = null;
            for (FieldInterfaced f : params.getAllFields()) {
                if (f.isAnnotationPresent(Section.class) && (section = (FormLayoutSection)sectionsByCaption.get(((Section)f.getAnnotation(Section.class)).value())) == null) {
                    section = new FormLayoutSection(((Section)f.getAnnotation(Section.class)).value(), ((Section)f.getAnnotation(Section.class)).card());
                    sections.add(section);
                    sectionsByCaption.put(section.getCaption(), section);
                }
                if (section == null && (section = (FormLayoutSection)sectionsByCaption.get("General")) == null) {
                    section = new FormLayoutSection("General", false);
                    sections.add(section);
                    sectionsByCaption.put(section.getCaption(), section);
                }
                if (f.isAnnotationPresent(SectionKPI.class)) {
                    section.getKpis().add(f);
                    continue;
                }
                section.getFields().add(f);
            }
            Layout realContainer = contentContainer;
            if (sections.size() == 1) {
                FormLayoutSection s = (FormLayoutSection)sections.get(0);
                if ("general".equalsIgnoreCase(s.getCaption())) {
                    s.setCaption(null);
                }
            } else if (sections.size() > 1) {
                if (!MDDUIAccessor.isMobile() && editor != null) {
                    editor.setSizeFull();
                }
                sectionTabSheet = new TabSheet();
                if (editor != null) {
                    TabSheet finalSectionTabSheet = sectionTabSheet;
                    sectionTabSheet.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener & Serializable)e -> editor.setFocusedSection(finalSectionTabSheet, e.getTabSheet().getSelectedTab()));
                }
                if (contentContainer instanceof VerticalLayout) {
                    ((VerticalLayout)contentContainer).addComponentsAndExpand(new Component[]{sectionTabSheet});
                } else {
                    contentContainer.addComponent((Component)sectionTabSheet);
                }
                realContainer = sectionTabSheet;
            }
            NakedObjectStylist finalStylist1 = stylist;
            Layout finalRealContainer = realContainer;
            sections.forEach(arg_0 -> this.lambda$build$0(binder, params, editor, ofb, model, (AbstractStylist)finalStylist1, allFieldContainers, componentsToLookForErrors, attachedActions, (Component)finalRealContainer, contentContainer, arg_0));
        } else {
            this.buildAndAddFields(editor, ofb, model, contentContainer, binder, params.getValidators(), (AbstractStylist)stylist, allFieldContainers, params.getAllFields(), params.isForSearchFilters(), params.isForSearchFiltersExtended(), componentsToLookForErrors, attachedActions);
        }
        log.debug("editor component E.2 in " + (System.currentTimeMillis() - t0) + " ms.");
        NakedObjectStylist finalStylist = stylist;
        binder.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<Object>((AbstractStylist)finalStylist, binder, allFieldContainers){
            final /* synthetic */ AbstractStylist val$finalStylist;
            final /* synthetic */ MDDBinder val$binder;
            final /* synthetic */ Map val$allFieldContainers;
            {
                this.val$finalStylist = abstractStylist;
                this.val$binder = mDDBinder;
                this.val$allFieldContainers = map;
            }

            public void valueChange(HasValue.ValueChangeEvent<Object> valueChangeEvent) {
                AbstractFieldBuilder.applyStyles(this.val$finalStylist, this.val$binder.getBean(), this.val$allFieldContainers, (Pair<Map<FieldInterfaced, List<String>>, Map<FieldInterfaced, List<String>>>)this.val$finalStylist.process(this.val$binder.getBean()));
            }
        });
        AbstractFieldBuilder.applyStyles((AbstractStylist)stylist, model, allFieldContainers, (Pair<Map<FieldInterfaced, List<String>>, Map<FieldInterfaced, List<String>>>)stylist.process(binder.getBean()));
        if (sectionTabSheet != null) {
            String sid = MateuUI.get().getPendingFocusedSectionId();
            if (!Strings.isNullOrEmpty((String)sid)) {
                sectionTabSheet.setSelectedTab(Integer.parseInt(sid));
            } else if (editor != null && !Strings.isNullOrEmpty((String)editor.getFocusedSectionId())) {
                sectionTabSheet.setSelectedTab(Integer.parseInt(editor.getFocusedSectionId()));
            }
        }
        log.debug("editor component E.3 in " + (System.currentTimeMillis() - t0) + " ms.");
        return new Pair((Object)contentContainer, (Object)stylist);
    }

    private void addActions(Layout form, List<AbstractAction> l) {
        if (l != null && l.size() > 0) {
            HorizontalLayout actionsContainer = new HorizontalLayout();
            form.addComponent((Component)actionsContainer);
            actionsContainer.addStyleName("nopadding");
            actionsContainer.addStyleName("sectionactionbar");
            ArrayList secuencia = new ArrayList();
            HashMap mapa = new HashMap();
            boolean pos = false;
            for (AbstractAction abstractAction : l) {
            }
            for (AbstractAction a : l) {
                Button b = new Button(a.getCaption(), (Resource)a.getIcon());
                actionsContainer.addComponent((Component)b);
                b.addStyleName("tiny");
                b.addStyleName("quiet");
                b.addStyleName(a.getStyle());
                b.addClickListener((Button.ClickListener & Serializable)e -> {
                    try {
                        new AcctionRunner().run(a);
                    }
                    catch (Throwable ex) {
                        Notifier.alert((Throwable)ex);
                    }
                });
            }
        }
    }

    private Component createKpi(MDDBinder binder, final FieldInterfaced kpi) {
        VerticalLayout vl = new VerticalLayout();
        vl.addStyleName("kpi");
        vl.addStyleName("sectionkpi");
        vl.setWidthUndefined();
        vl.addComponent((Component)new Label(ReflectionHelper.getCaption((FieldInterfaced)kpi)));
        final Label l = new Label();
        vl.addComponent((Component)l);
        l.addStyleName("valor");
        l.setContentMode(ContentMode.HTML);
        Binder.Binding binding = binder.forField(new HasValue(){
            Object v = null;

            public void setValue(Object o) {
                this.v = o;
                String s = "";
                if (Double.TYPE.equals(kpi.getType()) && (kpi.isAnnotationPresent(Money.class) || kpi.isAnnotationPresent(Balance.class))) {
                    DecimalFormat df = new DecimalFormat("##,###,###,###,##0.00");
                    s = df.format(this.v != null ? this.v : Integer.valueOf(0));
                    if (kpi.isAnnotationPresent(Balance.class)) {
                        if (this.v != null && (Double)this.v < 0.0) {
                            l.addStyleName("negativo");
                            l.removeStyleName("positivo");
                        } else {
                            l.addStyleName("positivo");
                            l.removeStyleName("negativo");
                        }
                    }
                } else if (this.v == null) {
                    s = "";
                } else if (this.v instanceof Boolean) {
                    if (((Boolean)this.v).booleanValue() && !((KPI)kpi.getAnnotation(KPI.class)).reversed()) {
                        s = VaadinIcons.CHECK.getHtml();
                        l.addStyleName("friendly");
                    } else {
                        s = VaadinIcons.CLOSE.getHtml();
                        l.addStyleName("danger");
                    }
                    l.addStyleName("centered");
                } else {
                    s = "" + this.v;
                }
                l.setValue(s);
            }

            public Object getValue() {
                return this.v;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        }).bind(kpi.getName());
        return vl;
    }

    private void addSectionToContainer(Component finalRealContainer, Panel form, String caption) {
        if (finalRealContainer instanceof TabSheet) {
            TabSheet ts = (TabSheet)finalRealContainer;
            form.setId("" + ts.getComponentCount());
            TabSheet.Tab tab = ts.addTab((Component)form, caption);
        } else if (finalRealContainer instanceof Layout) {
            ((Layout)finalRealContainer).addComponent((Component)form);
        }
    }

    private void buildAndAddFields(EditorViewComponent editor, JPAOutputFieldBuilder ofb, Object model, Layout contentContainer, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, List<FieldInterfaced> fields, boolean forSearchFilters, boolean forSearchFiltersExtended, List<Component> componentsToLookForErrors, Map<String, List<AbstractAction>> attachedActions) {
        this.buildAndAddFields(editor, ofb, model, contentContainer, binder, validators, stylist, allFieldContainers, fields, forSearchFilters, forSearchFiltersExtended, true, componentsToLookForErrors, attachedActions);
    }

    public void buildAndAddFields(EditorViewComponent editor, JPAOutputFieldBuilder ofb, Object model, Layout contentContainer, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, List<FieldInterfaced> fields, boolean forSearchFilters, boolean forSearchFiltersExtended, boolean createTabs, List<Component> componentsToLookForErrors, Map<String, List<AbstractAction>> attachedActions) {
        if (forSearchFilters) {
            if (forSearchFiltersExtended) {
                Layout layout = contentContainer;
                contentContainer = new VerticalLayout();
                layout.addComponent((Component)contentContainer);
                contentContainer.setSizeUndefined();
            }
            this._buildAndAddFields(editor, ofb, model, contentContainer, binder, validators, stylist, allFieldContainers, fields, forSearchFilters, forSearchFiltersExtended, createTabs, componentsToLookForErrors, attachedActions);
        } else {
            contentContainer.setSizeFull();
            ArrayList<FormLayoutGroup> groups = new ArrayList<FormLayoutGroup>();
            HashMap<String, FormLayoutGroup> groupsByCaption = new HashMap<String, FormLayoutGroup>();
            int posGroup = 1;
            FormLayoutGroup group = null;
            for (FieldInterfaced f : fields) {
                if (f.isAnnotationPresent(FieldGroup.class) && (group = (FormLayoutGroup)groupsByCaption.get(((FieldGroup)f.getAnnotation(FieldGroup.class)).value())) == null) {
                    group = new FormLayoutGroup(((FieldGroup)f.getAnnotation(FieldGroup.class)).value());
                    groups.add(group);
                    groupsByCaption.put(group.getCaption(), group);
                }
                if (group == null) {
                    group = (FormLayoutGroup)groupsByCaption.get("Field Group " + posGroup);
                }
                if (group == null || group.getCaption().startsWith("Field Group ") && group.getFields().size() >= 3) {
                    group = new FormLayoutGroup("Field Group " + (group == null ? posGroup : ++posGroup));
                    groups.add(group);
                    groupsByCaption.put(group.getCaption(), group);
                }
                group.getFields().add(f);
            }
            CssLayout css = new CssLayout();
            contentContainer.addComponent((Component)css);
            groups.forEach(g -> {
                VerticalLayout l = new VerticalLayout();
                css.addComponent((Component)l);
                l.setSizeUndefined();
                if (editor != null && !editor.esForm() || !g.getCaption().startsWith("Field Group ")) {
                    l.addStyleName("fieldgroup");
                    if (!Strings.isNullOrEmpty((String)g.getCaption())) {
                        Label c = new Label(g.getCaption());
                        l.addComponent((Component)c);
                        c.addStyleName("h4");
                        c.addStyleName("fieldgroupheader");
                    }
                } else {
                    l.addStyleName("nofieldgroup");
                }
                this._buildAndAddFields(editor, ofb, model, (Layout)l, binder, validators, stylist, allFieldContainers, g.getFields(), forSearchFilters, forSearchFiltersExtended, createTabs, componentsToLookForErrors, attachedActions);
            });
        }
    }

    public void _buildAndAddFields(EditorViewComponent editor, JPAOutputFieldBuilder ofb, Object model, Layout contentContainer, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, List<FieldInterfaced> fields, boolean forSearchFilters, boolean forSearchFiltersExtended, boolean createTabs, List<Component> componentsToLookForErrors, Map<String, List<AbstractAction>> attachedActions) {
        TabSheet tabs = null;
        TabSheet.Tab tab = null;
        Layout currentContentContainer = contentContainer;
        HorizontalLayout currentFieldContainer = null;
        ArrayList<TabSheet> tabSheetsStack = new ArrayList<TabSheet>();
        ArrayList<TabSheet.Tab> tabsStack = new ArrayList<TabSheet.Tab>();
        ArrayList<Layout> containersStack = new ArrayList<Layout>();
        boolean readOnly = model != null && model instanceof ReadOnly && ((ReadOnly)model).isReadOnly();
        for (FieldInterfaced f : fields) {
            long t0 = System.currentTimeMillis();
            HorizontalLayout wrapper = null;
            if (forSearchFilters && !forSearchFiltersExtended) {
                HorizontalLayout hl;
                wrapper = hl = new HorizontalLayout();
                contentContainer.addComponent((Component)hl);
                hl.addStyleName("nopadding");
            } else {
                if (f.isAnnotationPresent(FullWidth.class) || f.isAnnotationPresent(Tab.class) && ((Tab)f.getAnnotation(Tab.class)).fullWith() || f.isAnnotationPresent(StartTabs.class) && ((StartTabs)f.getAnnotation(StartTabs.class)).fullWith()) {
                    contentContainer.setWidth("100%");
                    contentContainer.addStyleName("section-fullwidth");
                    if (!currentContentContainer.equals(contentContainer)) {
                        currentContentContainer.setWidth("100%");
                        currentContentContainer.addStyleName("section-fullwidth");
                    }
                }
                if (createTabs) {
                    if (f.isAnnotationPresent(StartTabs.class)) {
                        if (tabs != null) {
                            tabSheetsStack.add(0, tabs);
                            tabsStack.add(0, tab);
                            containersStack.add(0, currentContentContainer);
                        }
                        tabs = new TabSheet();
                        tabs.setSizeUndefined();
                        currentContentContainer.addComponent((Component)tabs);
                    }
                    if (f.isAnnotationPresent(EndTabs.class)) {
                        if (tabSheetsStack.size() > 0) {
                            tab = (TabSheet.Tab)tabsStack.remove(0);
                            tabs = (TabSheet)tabSheetsStack.remove(0);
                            currentContentContainer = (Layout)containersStack.remove(0);
                        } else {
                            tab = null;
                            tabs = null;
                            currentContentContainer = contentContainer;
                        }
                    }
                    if (f.isAnnotationPresent(Tab.class)) {
                        Tab ta = (Tab)f.getAnnotation(Tab.class);
                        if (tabs == null) {
                            tabs = new TabSheet();
                            tabs.setSizeUndefined();
                            currentContentContainer.addComponent((Component)tabs);
                        }
                        currentContentContainer = new MiFormLayout();
                        tab = tabs.addTab((Component)currentContentContainer);
                        tab.setCaption(ta.value());
                    }
                }
                if (currentFieldContainer == null || !f.isAnnotationPresent(SameLine.class)) {
                    HorizontalLayout wrap;
                    currentFieldContainer = wrap = new HorizontalLayout();
                    wrap.setSpacing(true);
                    wrap.setDefaultComponentAlignment(Alignment.TOP_LEFT);
                    if (f.isAnnotationPresent(FullWidth.class)) {
                        wrap.setWidth("100%");
                    }
                }
                wrapper = currentFieldContainer;
                if (f.isAnnotationPresent(FullWidth.class) || f.isAnnotationPresent(Width.class)) {
                    wrapper = new VerticalLayout();
                    currentFieldContainer.addComponent((Component)wrapper);
                    ((VerticalLayout)wrapper).setSpacing(false);
                    wrapper.setWidth(f.isAnnotationPresent(Width.class) ? ((Width)f.getAnnotation(Width.class)).value() : "100%");
                    wrapper.addStyleName("nopadding");
                    wrapper.addStyleName("widthwrapper");
                }
            }
            Component c = null;
            if (!forSearchFilters && ((readOnly |= MDD.isReadOnly((FieldInterfaced)f)) || !f.forceInput() && (f.isAnnotationPresent(GeneratedValue.class) || editor != null && (f.isAnnotationPresent(Output.class) || !editor.isNewRecord() && (f.getDeclaringClass().isAnnotationPresent(Unmodifiable.class) || f.isAnnotationPresent(Id.class))) || !Component.class.isAssignableFrom(f.getType()) && ReflectionHelper.getMethod(model.getClass(), (String)ReflectionHelper.getSetter((FieldInterfaced)f)) == null))) {
                c = ofb.build(f, model, (Layout)wrapper, binder, validators, stylist, allFieldContainers, forSearchFilters, attachedActions);
            } else if (f.isAnnotationPresent(FieldBuilder.class)) {
                try {
                    c = ((FieldBuilder)f.getAnnotation(FieldBuilder.class)).value().newInstance().build(f, model, (Layout)wrapper, binder, validators, stylist, allFieldContainers, forSearchFilters, attachedActions);
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            } else {
                AbstractFieldBuilder b = (AbstractFieldBuilder)MDDUIAccessor.getApp().getFieldBuilder(f);
                if (b != null) {
                    c = b.build(f, model, (Layout)wrapper, binder, validators, stylist, allFieldContainers, forSearchFilters, attachedActions);
                }
            }
            if (c != null) {
                componentsToLookForErrors.add(c);
            }
            if ((!forSearchFilters || forSearchFiltersExtended) && wrapper != null && wrapper.getComponentCount() > 0) {
                currentContentContainer.addComponent((Component)currentFieldContainer);
            }
            log.debug("editor component field " + f + " in " + (System.currentTimeMillis() - t0) + " ms.");
        }
    }

    public static FormLayoutBuilder get() {
        return instance;
    }

    private /* synthetic */ void lambda$build$0(MDDBinder binder, FormLayoutBuilderParameters params, EditorViewComponent editor, JPAOutputFieldBuilder ofb, Object model, AbstractStylist finalStylist1, Map allFieldContainers, List componentsToLookForErrors, Map attachedActions, Component finalRealContainer, Layout contentContainer, FormLayoutSection s) {
        VerticalLayout form;
        Object object = form = MDDUIAccessor.isMobile() ? new VerticalLayout() : new MiFormLayout();
        if (s.isCard()) {
            form.addStyleName("sectioncard");
        }
        if (s.getKpis().size() > 0) {
            CssLayout kpisContainer = new CssLayout();
            form.addComponent((Component)kpisContainer);
            kpisContainer.addStyleName("nopadding");
            kpisContainer.addStyleName("sectionkpiscontainer");
            for (FieldInterfaced kpi : s.getKpis()) {
                Component c = this.createKpi(binder, kpi);
                kpisContainer.addComponent(c);
            }
        }
        this.addActions((Layout)form, (List)params.getActionsPerSection().get(s.getCaption()));
        this.buildAndAddFields(editor, ofb, model, (Layout)form, binder, params.getValidators(), finalStylist1, allFieldContainers, s.getFields(), params.isForSearchFilters(), params.isForSearchFiltersExtended(), componentsToLookForErrors, attachedActions);
        Panel p = new Panel((Component)form);
        this.addSectionToContainer(finalRealContainer, p, s.getCaption());
        p.addStyleName("borderless");
        if (form.getWidth() == 100.0f && Sizeable.Unit.PERCENTAGE.equals((Object)form.getWidthUnits())) {
            contentContainer.setWidth("100%");
        }
    }
}

