/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.vaadin.icons.VaadinIcons;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.MDDRunnableAction;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.core.views.ExtraFilters;
import io.mateu.mdd.shared.annotations.UseLinkToListView;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.views.IEditorViewComponent;
import io.mateu.mdd.vaadin.components.views.JPAListViewComponent;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JPACollectionFieldViewComponent
extends JPAListViewComponent {
    private final FieldInterfaced field;
    private final IEditorViewComponent evfc;
    private final boolean addingToCollection;

    @Override
    public VaadinIcons getIcon() {
        return VaadinIcons.TASKS;
    }

    public JPACollectionFieldViewComponent(Class entityClass, FieldInterfaced field, IEditorViewComponent evfc, boolean addingToCollection) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this(entityClass, JPACollectionFieldViewComponent.createExtraFields(field, evfc, addingToCollection), field, evfc, addingToCollection);
    }

    private static ExtraFilters createExtraFields(FieldInterfaced field, IEditorViewComponent evfc, boolean addingToCollection) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ExtraFilters ef = null;
        List ids = JPACollectionFieldViewComponent.getIds(evfc, field);
        if (ids.size() > 0) {
            ef = new ExtraFilters(" x " + (field.isAnnotationPresent(UseLinkToListView.class) && !addingToCollection ? "" : " not ") + " in :z ", new Object[]{"z", JPACollectionFieldViewComponent.getIds(evfc, field)});
        }
        return ef;
    }

    private static List getIds(IEditorViewComponent evfc, FieldInterfaced field) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object x : (Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)evfc.getModel())) {
            l.add(ReflectionHelper.getId(x));
        }
        return l;
    }

    public JPACollectionFieldViewComponent(Class entityClass, ExtraFilters extraFilters, FieldInterfaced field, IEditorViewComponent evfc, boolean addingToCollection) {
        super(entityClass, extraFilters);
        this.field = field;
        this.evfc = evfc;
        this.addingToCollection = addingToCollection;
    }

    @Override
    public void updateExtraFilters() throws Exception {
        this.setExtraFilters(JPACollectionFieldViewComponent.createExtraFields(this.field, this.evfc, this.addingToCollection));
    }

    public FieldInterfaced getField() {
        return this.field;
    }

    @Override
    public boolean isAddEnabled() {
        return !this.field.isAnnotationPresent(UseLinkToListView.class);
    }

    @Override
    public boolean isDeleteEnabled() {
        return !this.field.isAnnotationPresent(UseLinkToListView.class);
    }

    @Override
    public List<AbstractAction> getActions() {
        ArrayList<AbstractAction> l = new ArrayList<AbstractAction>();
        if (this.field.isAnnotationPresent(UseLinkToListView.class) && !this.addingToCollection) {
            l.add((AbstractAction)new MDDRunnableAction("Add items"){

                public void run() {
                    MDDUIAccessor.go((String)"add");
                }
            });
            l.add((AbstractAction)new MDDRunnableAction("Remove selected items"){

                public void run() {
                    try {
                        Object parentBean = JPACollectionFieldViewComponent.this.evfc.getBinder().getBean();
                        ReflectionHelper.setValue((FieldInterfaced)JPACollectionFieldViewComponent.this.field, (Object)parentBean, (Object)ReflectionHelper.removeAll((Collection)((Collection)ReflectionHelper.getValue((FieldInterfaced)JPACollectionFieldViewComponent.this.field, (Object)parentBean)), (Collection)JPACollectionFieldViewComponent.this.getSelection()));
                        JPACollectionFieldViewComponent.this.evfc.getBinder().setBean(parentBean, false);
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                    if (JPACollectionFieldViewComponent.this.field.isAnnotationPresent(UseLinkToListView.class)) {
                        try {
                            JPACollectionFieldViewComponent.this.evfc.save(false);
                            MDDUIAccessor.goBack();
                        }
                        catch (Throwable throwable) {
                            Notifier.alert((Throwable)throwable);
                        }
                    }
                }
            });
        } else {
            l.add((AbstractAction)new MDDRunnableAction("Add selected"){

                public void run() {
                    try {
                        JPAHelper.notransact(em -> JPACollectionFieldViewComponent.this.getSelection().forEach(o -> {
                            Object m = JPACollectionFieldViewComponent.this.evfc.getModel();
                            try {
                                ReflectionHelper.addToCollection((FieldInterfaced)JPACollectionFieldViewComponent.this.field, (Object)m, (Object)o);
                                JPACollectionFieldViewComponent.this.evfc.getBinder().setBean(m, false);
                            }
                            catch (Exception e1) {
                                Notifier.alert((Throwable)e1);
                            }
                        }));
                        if (JPACollectionFieldViewComponent.this.field.isAnnotationPresent(UseLinkToListView.class) && JPACollectionFieldViewComponent.this.addingToCollection) {
                            JPACollectionFieldViewComponent.this.evfc.save(false);
                        }
                        MDDUIAccessor.goBack();
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                }
            });
        }
        return l;
    }

    @Override
    public String toString() {
        return this.field != null ? "Adding " + Helper.capitalize((String)this.field.getName()).toLowerCase() + " to " + this.evfc.toString() : super.toString();
    }
}

