/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Grid;
import io.mateu.mdd.core.MDD;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.interfaces.GridDecorator;
import io.mateu.mdd.core.interfaces.StyledEnum;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.core.views.ExtraFilters;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.FrozenColumn;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.Indelible;
import io.mateu.mdd.shared.annotations.LiteralSearchFilter;
import io.mateu.mdd.shared.annotations.MainSearchFilter;
import io.mateu.mdd.shared.annotations.NewNotAllowed;
import io.mateu.mdd.shared.annotations.NoChart;
import io.mateu.mdd.shared.annotations.Order;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.Password;
import io.mateu.mdd.shared.annotations.SearchFilter;
import io.mateu.mdd.shared.annotations.Sum;
import io.mateu.mdd.shared.annotations.UseIdToSelect;
import io.mateu.mdd.shared.data.ChartData;
import io.mateu.mdd.shared.data.ChartValue;
import io.mateu.mdd.shared.data.SumData;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponentListener;
import io.mateu.mdd.vaadin.components.views.ViewComponentHelper;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.AuditRecord;
import io.mateu.util.interfaces.Translated;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import io.mateu.util.persistence.JPATransaction;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Query;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAListViewComponent
extends ListViewComponent {
    private static final Logger log = LoggerFactory.getLogger(JPAListViewComponent.class);
    private final Map<String, Object> initialValues;
    private final List<String> aliasedColumnNamesList = new ArrayList<String>();
    private final List<String> columnIds;
    private final Map<String, FieldInterfaced> fieldsByAliasedColumnName;
    private final Map<String, String> aliasedColumnNamesByColId = new HashMap<String, String>();
    private final Map<String, FieldInterfaced> fieldsByColId = new HashMap<String, FieldInterfaced>();
    private final Consumer<Object> callback;
    private ExtraFilters extraFilters;
    private final Class entityClass;
    private Object filters;
    private List<SumData> sums;
    private int frozenColumnCount = -1;
    private final String useColumns;
    private final String useFilters;
    private final String useFields;
    private List<String> columnNames = new ArrayList<String>();
    private Map<String, FieldInterfaced> fieldsByColumnName = new HashMap<String, FieldInterfaced>();
    private List<String> filterNames = new ArrayList<String>();
    private Map<String, FieldInterfaced> fieldsByFilterName = new HashMap<String, FieldInterfaced>();
    private List<String> columnFields;
    private List<FieldInterfaced> filterFields;
    Map<String, String> alias = new HashMap<String, String>();
    Map<String, String> aliasedColumnNames = new HashMap<String, String>();
    String selectColumnsForCount;
    String selectColumnsForList;
    List<FieldInterfaced> sumFields;

    public Map<String, FieldInterfaced> getFieldsByColId() {
        return this.fieldsByColId;
    }

    public JPAListViewComponent(Class entityClass, String columns) {
        this(entityClass, null, null, columns, null, null, null);
    }

    public JPAListViewComponent(Class entityClass) {
        this(entityClass, null, null);
    }

    public JPAListViewComponent(Class entityClass, ExtraFilters extraFilters) {
        this(entityClass, extraFilters, null);
    }

    public JPAListViewComponent(Class entityClass, ExtraFilters extraFilters, Map<String, Object> initialValues) {
        this(entityClass, extraFilters, initialValues, null, null, null);
    }

    public JPAListViewComponent(Class entityClass, ExtraFilters extraFilters, Map<String, Object> initialValues, String columns, String filters, String fields) {
        this(entityClass, extraFilters, initialValues, columns, filters, fields, null);
    }

    public JPAListViewComponent(final Class entityClass, ExtraFilters extraFilters, Map<String, Object> initialValues, String columns, String filters, String fields, final Consumer<Object> callback) {
        this.entityClass = entityClass;
        this.extraFilters = extraFilters;
        this.initialValues = initialValues;
        this.useColumns = columns;
        this.useFilters = filters;
        this.useFields = fields;
        this.callback = callback;
        this.addListener(new ListViewComponentListener(){

            @Override
            public void onEdit(Object id) {
                try {
                    MDDUIAccessor.goTo((String)(JPAListViewComponent.this.getUrl() + "/" + URLEncoder.encode(Helper.encodeState((String)("" + id)), "iso-8859-1")));
                }
                catch (UnsupportedEncodingException e) {
                    Notifier.alert((Throwable)e);
                }
            }

            @Override
            public void onSelect(Object id) {
                if (callback != null) {
                    if (id != null && id instanceof Optional) {
                        id = ((Optional)id).get();
                    }
                    Object o = null;
                    if (id != null) {
                        try {
                            o = JPAHelper.find((Class)entityClass, (Object)JPAListViewComponent.this.toId(id));
                        }
                        catch (Throwable throwable) {
                            Notifier.alert((Throwable)throwable);
                        }
                    }
                    callback.accept(o);
                    MDDUIAccessor.goBack();
                }
            }
        });
        this.columnFields = JPAListViewComponent.getSelectFields(this.getColumnType(), this.useColumns, this.columnNames, this.fieldsByColumnName);
        this.filterFields = this.getFilterFields();
        this.createAliases(this.getColumnType(), this.columnNames, this.fieldsByColumnName, this.alias, this.aliasedColumnNames, this.aliasedColumnNamesList);
        this.sumFields = this.fieldsByColumnName.values().stream().filter(f -> f.isAnnotationPresent(Sum.class)).collect(Collectors.toList());
        String ql = "count(x)";
        for (FieldInterfaced f2 : this.sumFields) {
            if (!"".equals(ql)) {
                ql = ql + ", ";
            }
            ql = ql + " sum(x." + f2.getName() + ") ";
        }
        this.selectColumnsForCount = ql;
        this.selectColumnsForList = this.buildFieldsPart(this.columnFields);
        this.columnIds = new ArrayList<String>();
        int pos = 0;
        for (String n2 : this.columnNames) {
            String colId = "col" + pos++;
            this.columnIds.add(colId);
            this.aliasedColumnNamesByColId.put(colId, this.aliasedColumnNames.get(n2));
            if (pos <= 1) continue;
            this.fieldsByColId.put(colId, this.fieldsByColumnName.get(n2));
        }
        this.fieldsByAliasedColumnName = new HashMap<String, FieldInterfaced>();
        this.columnNames.stream().forEach(n -> this.fieldsByAliasedColumnName.put(this.aliasedColumnNames.get(n), this.fieldsByColumnName.get(n)));
    }

    @Override
    public int getFrozenColumnCount() {
        if (this.frozenColumnCount < 0) {
            int pos = 1;
            for (FieldInterfaced columnField : JPAListViewComponent.getColumnFields(this.entityClass)) {
                if (columnField.isAnnotationPresent(FrozenColumn.class)) {
                    this.frozenColumnCount = pos;
                }
                ++pos;
            }
            if (this.frozenColumnCount < 0) {
                this.frozenColumnCount = 0;
            }
        }
        return this.frozenColumnCount;
    }

    @Override
    public void buildColumns(Grid grid) {
        JPAListViewComponent.buildColumns(grid, this.columnIds, this.fieldsByColId, true, false, null, null, this.useColumnsToColIds(this.useColumns));
    }

    private String useColumnsToColIds(String useColumns) {
        if (useColumns == null) {
            return null;
        }
        String r = "";
        int pos = 0;
        for (String t : useColumns.split(",")) {
            String k = t.trim();
            if (k.contains("(")) {
                k = k.substring(0, k.indexOf("("));
            }
            if (k.contains(" ")) {
                k = k.substring(0, k.indexOf(" "));
            }
            if (!"".equals(r)) {
                r = r + ",";
            }
            r = r + t.replaceAll(k.replaceAll("\\.", "\\\\."), "col_" + pos++);
        }
        return r;
    }

    public String toString() {
        if (this.callback != null) {
            String n = Helper.capitalize((String)this.entityClass.getSimpleName(), (boolean)false);
            return "Select a" + (n.matches("^[aeiou].*") ? "n" : "") + " " + n;
        }
        return Helper.pluralize((String)Helper.capitalize((String)this.entityClass.getSimpleName()));
    }

    @Override
    public Object getModelForSearchFilters() throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return this.createNewInstance();
    }

    @Override
    public void setModelForSearchFilters(Object filters) {
        if (this.filtersComponent != null) {
            this.filtersComponent.getBinder().setBean(filters);
        }
        this.filters = filters;
    }

    @Override
    public String getFieldsFilter() {
        return this.selectColumnsForList;
    }

    @Override
    public String getEditableFieldsFilter() {
        return this.useFields;
    }

    @Override
    public List<FieldInterfaced> getFilterFields(Class filtersType) {
        if (Strings.isNullOrEmpty((String)this.useFilters)) {
            List<Object> filterFields = ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Password.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && (f.isAnnotationPresent(SearchFilter.class) || f.isAnnotationPresent(MainSearchFilter.class))).collect(Collectors.toList());
            if (filterFields.size() == 0) {
                filterFields = ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Password.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && !f.isAnnotationPresent(Output.class) && !IResource.class.isAssignableFrom(f.getType()) && (String.class.equals((Object)f.getType()) || LocalDate.class.equals((Object)f.getType()) || LocalDateTime.class.equals((Object)f.getType()) || LocalTime.class.equals((Object)f.getType()) || Date.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType()) || Boolean.class.equals((Object)f.getType()) || f.getType().isEnum() || f.isAnnotationPresent(ManyToOne.class) || f.getType().isAnnotationPresent(Entity.class))).collect(Collectors.toList());
            }
            filterFields.forEach(f -> {
                this.filterNames.add(f.getName());
                this.fieldsByFilterName.put(f.getName(), (FieldInterfaced)f);
            });
            return filterFields;
        }
        ArrayList fns = Lists.newArrayList((Object[])this.useFilters.replaceAll(" ", "").split(","));
        List<FieldInterfaced> filterFields = fns.stream().map(n -> {
            FieldInterfaced f = ReflectionHelper.getFieldByName((Class)filtersType, (String)n);
            this.filterNames.add((String)n);
            this.fieldsByFilterName.put((String)n, f);
            return f;
        }).collect(Collectors.toList());
        return filterFields;
    }

    @Override
    public boolean isAddEnabled() {
        return !this.entityClass.isAnnotationPresent(NewNotAllowed.class);
    }

    @Override
    public boolean isDeleteEnabled() {
        return this.callback == null && !this.entityClass.isAnnotationPresent(Indelible.class);
    }

    @Override
    public List<AbstractAction> getActions() {
        ArrayList<AbstractAction> l = new ArrayList<AbstractAction>();
        ArrayList<Method> ms = new ArrayList<Method>();
        if (this.callback == null) {
            for (Method m2 : ReflectionHelper.getAllMethods((Class)this.entityClass)) {
                if (!Modifier.isStatic(m2.getModifiers()) || !m2.isAnnotationPresent(Action.class)) continue;
                ms.add(m2);
            }
        }
        ms.sort((a, b) -> a.getAnnotation(Action.class).order() - b.getAnnotation(Action.class).order());
        ms.forEach(m -> l.add(ViewComponentHelper.createAction(m, this)));
        return l;
    }

    public Object createNewInstance() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (this.filters == null) {
            this.filters = this.getFiltersType().newInstance();
            if (this.initialValues != null) {
                for (String k : this.initialValues.keySet()) {
                    try {
                        ReflectionHelper.setValue((String)k, (Object)this.filters, (Object)this.initialValues.get(k));
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                }
            }
        }
        return this.filters;
    }

    @Override
    public Class getFiltersType() {
        try {
            return ReflectionHelper.createClass((ClassPool)MDD.getClassPool(), MDDBinder.class, (ClassLoader)MDD.getClassPool().getClassLoader(), (String)(this.entityClass.getName() + "000Filters" + this.getFilterFieldsSerialized()), this.getFilterFields(this.entityClass), (boolean)true);
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
            return null;
        }
    }

    private String getFilterFieldsSerialized() {
        String s = "";
        if (!Strings.isNullOrEmpty((String)this.useFilters)) {
            s = s + this.useFilters.replaceAll("[,\\.]", "");
        }
        return s;
    }

    public Object getFilters() {
        return this.filters;
    }

    @Override
    public Collection findAll(Object filters, final List<QuerySortOrder> sortOrders, final int offset, final int limit) {
        final ArrayList l = new ArrayList();
        try {
            JPAHelper.notransact((JPATransaction)new JPATransaction(){

                public void run(EntityManager em) throws Throwable {
                    Query q = JPAListViewComponent.this.buildQuery(em, JPAListViewComponent.this.selectColumnsForList, JPAListViewComponent.this.getFilters(), sortOrders, null, offset, limit, true);
                    l.addAll(q.getResultList());
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return l;
    }

    private Query buildQuery(EntityManager em, String selectedColumns, Object filters, List<QuerySortOrder> sortOrders, int offset, int limit) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.buildQuery(em, selectedColumns, filters, sortOrders, null, offset, limit, false);
    }

    private Query buildQuery(EntityManager em, String selectedColumns, Object filters, List<QuerySortOrder> sortOrders, String groupClause, int offset, int limit, boolean addOrderClause) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        String w = "";
        w = this.buildWhereClause(filters, this.entityClass, parameterValues);
        String jpql = "select " + selectedColumns + " from " + this.entityClass.getName() + " x ";
        for (String string : this.alias.keySet()) {
            jpql = jpql + " left join " + string + " " + this.alias.get(string);
        }
        if (!"".equals(w)) {
            jpql = jpql + " where " + w;
        }
        if (!Strings.isNullOrEmpty((String)groupClause)) {
            jpql = jpql + " " + groupClause + " ";
        }
        if (addOrderClause) {
            String oc = "";
            if (sortOrders != null) {
                for (QuerySortOrder querySortOrder : sortOrders) {
                    if (!"".equals(oc)) {
                        oc = oc + ", ";
                    }
                    oc = oc + "col" + this.getColumnIndex(querySortOrder.getSorted()) + " " + (SortDirection.DESCENDING.equals((Object)querySortOrder.getDirection()) ? "desc" : "asc");
                }
            }
            ArrayList<FieldInterfaced> arrayList = new ArrayList<FieldInterfaced>();
            for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)this.getColumnType())) {
                if (!f.isAnnotationPresent(Order.class)) continue;
                arrayList.add(f);
            }
            Collections.sort(arrayList, (f1, f2) -> ((Order)f1.getAnnotation(Order.class)).priority() - ((Order)f2.getAnnotation(Order.class)).priority());
            for (FieldInterfaced f : arrayList) {
                if (!"".equals(oc)) {
                    oc = oc + ", ";
                }
                oc = oc + this.aliasedColumnNames.get(f.getName()) + " " + (((Order)f.getAnnotation(Order.class)).desc() ? "desc" : "asc");
            }
            if ("".equals(oc) && ReflectionHelper.getFieldByName((Class)this.entityClass, (String)"audit") != null && AuditRecord.class.isAssignableFrom(ReflectionHelper.getFieldByName((Class)this.entityClass, (String)"audit").getType())) {
                oc = oc + "x.audit.modified desc";
            }
            if ("".equals(oc) && this.columnNames.size() > 1) {
                oc = oc + this.aliasedColumnNames.get(this.columnNames.get(1)) + " desc";
            }
            if (!"".equals(oc)) {
                jpql = jpql + " order by " + oc;
            }
        }
        Query q = em.createQuery(jpql).setFirstResult(offset).setMaxResults(limit);
        for (String string : parameterValues.keySet()) {
            q.setParameter(string, parameterValues.get(string));
        }
        System.out.println(jpql);
        System.out.println(q.toString());
        return q;
    }

    private int getColumnIndex(String columnId) {
        int i = this.aliasedColumnNamesList.indexOf(columnId);
        if (i < 0 && columnId.startsWith("col")) {
            i = Integer.parseInt(columnId.substring("col".length()));
        }
        return i;
    }

    private void createAliases(Class sourceType, List<String> paths, Map<String, FieldInterfaced> fieldsByPath, Map<String, String> alias, Map<String, String> aliasedColumnNames, List<String> aliasedColumnNamesList) {
        for (String path : paths) {
            FieldInterfaced f = fieldsByPath.get(path);
            String p = path;
            FieldInterfaced fx = f;
            Class type = sourceType;
            FieldInterfaced f0 = null;
            String pathAcumulado = "x";
            while (!Strings.isNullOrEmpty((String)p)) {
                String s = p;
                if (p.contains(".")) {
                    p = p.substring(p.indexOf(".") + 1);
                    s = s.substring(0, s.indexOf("."));
                } else {
                    p = null;
                }
                if (!"".equals(pathAcumulado)) {
                    pathAcumulado = pathAcumulado + ".";
                }
                pathAcumulado = pathAcumulado + s;
                fx = ReflectionHelper.getFieldByName((Class)type, (String)s);
                if (fx == null || !(type = fx.getType()).isAnnotationPresent(Entity.class) || fx.isAnnotationPresent(NotNull.class) || fx.isAnnotationPresent(NotNull.class)) continue;
                if (!alias.containsKey(pathAcumulado)) {
                    alias.put(pathAcumulado, "x" + alias.size());
                }
                pathAcumulado = alias.get(pathAcumulado);
                f0 = fx;
            }
            aliasedColumnNames.put(path, pathAcumulado);
            aliasedColumnNamesList.add(pathAcumulado);
        }
    }

    public static List<String> getSelectFields(Class targetType, String useColumns, List<String> columnNames, Map<String, FieldInterfaced> fieldsByColumnName) {
        List<FieldInterfaced> cols = JPAListViewComponent.getColumnFields(targetType, false, useColumns, columnNames, fieldsByColumnName);
        FieldInterfaced idField = null;
        for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)targetType)) {
            if (!f.isAnnotationPresent(Id.class)) continue;
            idField = f;
        }
        if (idField != null) {
            columnNames.add(0, idField.getName());
        }
        return columnNames;
    }

    private String buildWhereClause(Object filters, Class entityClass, Map<String, Object> parameterValues) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String ql = "";
        try {
            this.updateExtraFilters();
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
        if (this.extraFilters != null && !Strings.isNullOrEmpty((String)this.extraFilters.getQl())) {
            if (!"".equals(ql)) {
                ql = ql + " and ";
            }
            ql = ql + this.extraFilters.getQl();
            if (this.extraFilters.getParameters() != null) {
                parameterValues.putAll(this.extraFilters.getParameters());
            }
        }
        if (filters == null) {
            return ql;
        }
        List<Object> allFields = this.getFilterFields();
        allFields = allFields.stream().filter(f -> !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && (!f.isAnnotationPresent(Id.class) || !f.isAnnotationPresent(GeneratedValue.class) || f.isAnnotationPresent(MainSearchFilter.class) || f.isAnnotationPresent(SearchFilter.class))).collect(Collectors.toList());
        for (FieldInterfaced fieldInterfaced : allFields) {
            Object v = ReflectionHelper.getValue((FieldInterfaced)fieldInterfaced, (Object)filters);
            if (v == null) continue;
            FieldInterfaced ef = ReflectionHelper.getFieldByName((Class)entityClass, (String)fieldInterfaced.getName());
            if (ef != null && ef.getType().isAnnotationPresent(UseIdToSelect.class)) {
                boolean anadir = !String.class.equals(v.getClass()) || !Strings.isNullOrEmpty((String)((String)v));
                if (!anadir) continue;
                FieldInterfaced idf = ReflectionHelper.getIdField((Class)entityClass);
                if (!"".equals(ql)) {
                    ql = ql + " and ";
                }
                ql = ql + " x." + fieldInterfaced.getName() + "." + idf.getName() + " = :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), v);
                continue;
            }
            if (String.class.equals(v.getClass())) {
                String s = (String)v;
                if (Strings.isNullOrEmpty((String)s)) continue;
                if (!"".equals(ql)) {
                    ql = ql + " and ";
                }
                ql = ql + " lower(x." + fieldInterfaced.getName() + (fieldInterfaced.isAnnotationPresent(LiteralSearchFilter.class) ? ".es" : "") + ") like :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), "%" + ((String)v).toLowerCase() + "%");
                continue;
            }
            if (Boolean.class.equals(v.getClass()) || Boolean.TYPE.equals(v.getClass())) {
                boolean b = (Boolean)v;
                if (!"".equals(ql)) {
                    ql = ql + " and ";
                }
                if (!b) {
                    ql = ql + " not ";
                }
                ql = ql + " x." + fieldInterfaced.getName() + " ";
                if (!b) continue;
                ql = ql + " = true ";
                continue;
            }
            if (Integer.class.equals(v.getClass()) || Integer.TYPE.equals(v.getClass()) || Long.class.equals(v.getClass()) || Long.TYPE.equals(v.getClass()) || Double.class.equals(v.getClass()) || Double.TYPE.equals(v.getClass())) {
                String fname = fieldInterfaced.getName();
                if (fname.endsWith("From")) {
                    fname = fname.substring(0, fname.lastIndexOf("From"));
                }
                if (fname.endsWith("To")) {
                    fname = fname.substring(0, fname.lastIndexOf("To"));
                }
                if (fname.endsWith("Value")) {
                    fname = fname.substring(0, fname.lastIndexOf("Value"));
                }
                if (!"".equals(ql)) {
                    ql = ql + " and ";
                }
                ql = ql + " x." + fname + " " + (fieldInterfaced.getName().endsWith("From") ? ">=" : (fieldInterfaced.getName().endsWith("To") ? "<=" : "=")) + " :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), v);
                continue;
            }
            if (LocalDate.class.equals(v.getClass()) || LocalDateTime.class.equals(v.getClass()) || Date.class.equals(v.getClass())) {
                String fname = fieldInterfaced.getName();
                if (fname.endsWith("From")) {
                    fname = fname.substring(0, fname.lastIndexOf("From"));
                }
                if (fname.endsWith("To")) {
                    fname = fname.substring(0, fname.lastIndexOf("To"));
                }
                if (!"".equals(ql)) {
                    ql = ql + " and ";
                }
                ql = ql + " x." + fname + " " + (fieldInterfaced.getName().endsWith("From") ? ">=" : "<=") + " :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), v);
                continue;
            }
            if (!"".equals(ql)) {
                ql = ql + " and ";
            }
            ql = ql + " x." + fieldInterfaced.getName() + " = :" + fieldInterfaced.getName() + " ";
            parameterValues.put(fieldInterfaced.getName(), v);
        }
        return ql;
    }

    public void updateExtraFilters() throws Exception {
    }

    private String buildFieldsPart(List<String> columnFieldNames) {
        String s = "";
        int pos = 0;
        for (String columnName : columnFieldNames) {
            if (!"".equals(s)) {
                s = s + ", ";
            }
            String colId = this.aliasedColumnNames.get(columnName);
            s = s + colId + " as col" + pos++;
        }
        return s;
    }

    @Override
    public int gatherCount(final Object filters) {
        final int[] count = new int[]{0};
        try {
            JPAHelper.notransact((JPATransaction)new JPATransaction(){

                public void run(EntityManager em) throws Throwable {
                    JPAListViewComponent.this.sums = new ArrayList();
                    Query q = JPAListViewComponent.this.buildQuery(em, JPAListViewComponent.this.selectColumnsForCount, filters, null, 0, 1000);
                    log.debug(q.toString());
                    Object r = q.getSingleResult();
                    if (r instanceof Long) {
                        count[0] = ((Long)r).intValue();
                    } else if (r instanceof Object[]) {
                        Object[] v = (Object[])r;
                        count[0] = ((Long)v[0]).intValue();
                        DecimalFormat nf = new DecimalFormat("#,###,###,###,###,###,###.00");
                        int pos = 1;
                        for (FieldInterfaced f : JPAListViewComponent.this.sumFields) {
                            Object x;
                            String caption = Helper.capitalize((String)f.getName());
                            if (!caption.startsWith("Total")) {
                                caption = "Total " + caption;
                            }
                            if (!Strings.isNullOrEmpty((String)((Sum)f.getAnnotation(Sum.class)).caption())) {
                                caption = ((Sum)f.getAnnotation(Sum.class)).caption();
                            }
                            if ((x = v[pos++]) != null && x instanceof Double) {
                                x = (double)Math.round(100.0 * (Double)x) / 100.0;
                                x = nf.format(x);
                            }
                            JPAListViewComponent.this.sums.add(new SumData(caption, x != null ? "" + x : "---", ""));
                        }
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return count[0];
    }

    @Override
    public List<SumData> getSums(Object filters) {
        return this.sums;
    }

    @Override
    protected List<ChartData> getCharts(Object filters) {
        ArrayList<ChartData> l = new ArrayList<ChartData>();
        JPAListViewComponent.getColumnFields(this.entityClass).stream().filter(f -> !f.isAnnotationPresent(NoChart.class) && !Translated.class.isAssignableFrom(f.getType()) && (f.getType().isEnum() || !IResource.class.isAssignableFrom(f.getType()) && f.isAnnotationPresent(ManyToOne.class) || Boolean.TYPE.equals(f.getType()) || Boolean.class.equals((Object)f.getType()))).forEach(f -> l.add(this.gatherChartData(filters, (FieldInterfaced)f)));
        return l;
    }

    private ChartData gatherChartData(final Object filters, final FieldInterfaced f) {
        final ArrayList vs = new ArrayList();
        String caption = "By " + Helper.capitalize((String)f.getName()).toLowerCase();
        try {
            JPAHelper.notransact((JPATransaction)new JPATransaction(){

                public void run(EntityManager em) throws Throwable {
                    Query q = JPAListViewComponent.this.buildQuery(em, "x." + f.getName() + ", count(x)", filters, null, "group by x." + f.getName(), 0, 1000, false);
                    log.debug(q.toString());
                    List r = q.getResultList();
                    for (Object[] l : r) {
                        String s = "";
                        if (l[0] instanceof StyledEnum) {
                            s = ((StyledEnum)l[0]).getStyle();
                        }
                        vs.add(new ChartValue(l[0], "" + l[0], new Double("" + l[1]).doubleValue(), s));
                    }
                }
            });
        }
        catch (Throwable throwable) {
            Notifier.alert((Throwable)throwable);
        }
        ChartData d = new ChartData(f, caption, vs);
        return d;
    }

    @Override
    public Object deserializeId(String sid) {
        FieldInterfaced idField = null;
        for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)this.entityClass)) {
            if (!f.isAnnotationPresent(Id.class)) continue;
            idField = f;
            break;
        }
        Object id = sid;
        if (idField != null) {
            if (Long.class.equals((Object)idField.getType()) || Long.TYPE.equals(idField.getType())) {
                id = Long.parseLong(sid);
            } else if (Integer.class.equals((Object)idField.getType()) || Integer.TYPE.equals(idField.getType())) {
                id = Integer.parseInt(sid);
            } else if (Boolean.class.equals((Object)idField.getType()) || Boolean.TYPE.equals(idField.getType())) {
                id = Boolean.parseBoolean(sid);
            } else if (Double.class.equals((Object)idField.getType()) || Double.TYPE.equals(idField.getType())) {
                id = Double.parseDouble(sid);
            }
        }
        return id;
    }

    @Override
    public Class getModelType() {
        return this.entityClass;
    }

    @Override
    public Class getColumnType() {
        return this.entityClass;
    }

    @Override
    protected void delete(final Set selection) {
        try {
            JPAHelper.transact((JPATransaction)new JPATransaction(){

                public void run(EntityManager em) throws Throwable {
                    for (Object o : selection) {
                        ReflectionHelper.delete((EntityManager)em, (Object)em.find(JPAListViewComponent.this.entityClass, JPAListViewComponent.this.toId(o)));
                    }
                }
            });
        }
        catch (Throwable throwable) {
            Notifier.alert((Throwable)throwable);
        }
    }

    @Override
    public void decorateGrid(Grid grid) {
        GridDecorator d = null;
        try {
            Method m = ReflectionHelper.getMethod((Class)this.entityClass, (String)"getGridDecorator");
            if (m != null) {
                d = Modifier.isStatic(m.getModifiers()) ? (GridDecorator)m.invoke(null, new Object[0]) : (GridDecorator)m.invoke(ReflectionHelper.newInstance((Class)this.entityClass), new Object[0]);
            } else if (GridDecorator.class.isAssignableFrom(this.entityClass)) {
                d = (GridDecorator)ReflectionHelper.newInstance((Class)this.entityClass);
            }
            if (d != null) {
                d.decorateGrid(grid);
            }
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
    }

    public ExtraFilters getExtraFilters() {
        return this.extraFilters;
    }

    public void setExtraFilters(ExtraFilters extraFilters) {
        this.extraFilters = extraFilters;
    }

    @Override
    public Set getSelection() {
        HashSet sel = new HashSet();
        try {
            JPAHelper.notransact(em -> super.getSelection().forEach(o -> {
                Object v = em.find(this.entityClass, this.toId(o));
                sel.add(v != null ? v : o);
            }));
        }
        catch (Throwable throwable) {
            Notifier.alert((Throwable)throwable);
        }
        return sel;
    }
}

