/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.byteowls.vaadin.chartjs.ChartJs;
import com.byteowls.vaadin.chartjs.config.ChartConfig;
import com.byteowls.vaadin.chartjs.config.DonutChartConfig;
import com.byteowls.vaadin.chartjs.data.Dataset;
import com.byteowls.vaadin.chartjs.data.PieDataset;
import com.byteowls.vaadin.chartjs.options.types.PieChartOptions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.vaadin.data.Converter;
import com.vaadin.data.HasDataProvider;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.SerializableFunction;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.Setter;
import com.vaadin.server.UserError;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.shared.ui.BorderStyle;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.DateField;
import com.vaadin.ui.DateTimeField;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.StyleGenerator;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.components.grid.EditorOpenEvent;
import com.vaadin.ui.components.grid.EditorOpenListener;
import com.vaadin.ui.components.grid.SortOrderProvider;
import com.vaadin.ui.renderers.ComponentRenderer;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;
import com.vaadin.ui.renderers.TextRenderer;
import elemental.json.JsonValue;
import io.mateu.i18n.Translator;
import io.mateu.mdd.core.dataProviders.JPQLListDataProvider;
import io.mateu.mdd.core.interfaces.AbstractJPQLListView;
import io.mateu.mdd.core.interfaces.Activable;
import io.mateu.mdd.core.interfaces.Cancellable;
import io.mateu.mdd.core.interfaces.ICellStyleGenerator;
import io.mateu.mdd.core.interfaces.StyledEnum;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.Balance;
import io.mateu.mdd.shared.annotations.Caption;
import io.mateu.mdd.shared.annotations.CellStyleGenerator;
import io.mateu.mdd.shared.annotations.ColumnWidth;
import io.mateu.mdd.shared.annotations.DataProvider;
import io.mateu.mdd.shared.annotations.HtmlCol;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.ListColumn;
import io.mateu.mdd.shared.annotations.MainSearchFilter;
import io.mateu.mdd.shared.annotations.Money;
import io.mateu.mdd.shared.annotations.NativeJPQLResult;
import io.mateu.mdd.shared.annotations.NotInList;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.Password;
import io.mateu.mdd.shared.annotations.RightAlignedCol;
import io.mateu.mdd.shared.annotations.SearchFilter;
import io.mateu.mdd.shared.annotations.UseCheckboxes;
import io.mateu.mdd.shared.annotations.UseComponentsToEditValues;
import io.mateu.mdd.shared.annotations.UseIdToSelect;
import io.mateu.mdd.shared.annotations.ValueClass;
import io.mateu.mdd.shared.annotations.WeekDays;
import io.mateu.mdd.shared.data.ChartData;
import io.mateu.mdd.shared.data.ChartValue;
import io.mateu.mdd.shared.data.FareValue;
import io.mateu.mdd.shared.data.SumData;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.interfaces.RpcView;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.components.WeekDaysComponent;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import io.mateu.mdd.vaadin.components.views.DummyConverter;
import io.mateu.mdd.vaadin.components.views.FiltersComponent;
import io.mateu.mdd.vaadin.components.views.JPACollectionFieldListViewComponent;
import io.mateu.mdd.vaadin.components.views.JPAListViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponentListener;
import io.mateu.mdd.vaadin.components.views.ResultsComponent;
import io.mateu.mdd.vaadin.components.views.RpcListViewComponent;
import io.mateu.mdd.vaadin.components.views.WeekDaysGridEditor;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.mdd.vaadin.util.VaadinHelper;
import io.mateu.reflection.FieldInterfacedForCheckboxColumn;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.IIcon;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.money.MonetaryAmount;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.ManyToOne;
import javax.persistence.Query;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.javamoney.moneta.FastMoney;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.grid.cellrenderers.editable.DateFieldRenderer;
import org.vaadin.grid.cellrenderers.editable.SimpleSelectRenderer;
import org.vaadin.grid.cellrenderers.editable.TextFieldRenderer;
import org.vaadin.grid.cellrenderers.editoraware.CheckboxRenderer;

public abstract class ListViewComponent
extends AbstractViewComponent<ListViewComponent> {
    private static final Logger log = LoggerFactory.getLogger(ListViewComponent.class);
    public ResultsComponent resultsComponent;
    private List<ListViewComponentListener> listeners = new ArrayList<ListViewComponentListener>();
    private int count;
    private Label countLabel;
    public FiltersComponent filtersComponent;
    private Button excelButton;
    private Button pdfButton;
    private HorizontalLayout matchesComponent;
    private String baseUrl;

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public VaadinIcons getIcon() {
        return VaadinIcons.LINES;
    }

    public String getFieldsFilter() {
        return null;
    }

    public String getEditableFieldsFilter() {
        return null;
    }

    public ListViewComponent() {
        if (!MDDUIAccessor.isMobile()) {
            this.setSizeFull();
        }
    }

    @Override
    public ListViewComponent build() throws Exception {
        this.addStyleName("listviewcomponent");
        super.build();
        if (!(this instanceof JPACollectionFieldListViewComponent)) {
            this.filtersComponent = new FiltersComponent(this);
            this.addComponent((Component)this.filtersComponent);
        }
        this.setSizeFull();
        if (!(this instanceof JPACollectionFieldListViewComponent)) {
            Component[] componentArray = new Component[3];
            this.excelButton = new Button("<i class=\"fas fa-file-excel\"></i>", (Button.ClickListener & Serializable)e -> this.excel());
            componentArray[0] = this.excelButton;
            this.pdfButton = new Button("<i class=\"fas fa-file-pdf\"></i>", (Button.ClickListener & Serializable)e -> this.pdf());
            componentArray[1] = this.pdfButton;
            this.countLabel = new Label();
            componentArray[2] = this.countLabel;
            this.matchesComponent = new HorizontalLayout(componentArray);
            this.addComponent((Component)this.matchesComponent);
            this.matchesComponent.addStyleName("nopadding");
            this.countLabel.addStyleName("resultsmessage");
            this.excelButton.addStyleName("link");
            this.excelButton.addStyleName("botondeicono");
            this.excelButton.setCaptionAsHtml(true);
            this.pdfButton.addStyleName("link");
            this.pdfButton.addStyleName("botondeicono");
            this.pdfButton.setCaptionAsHtml(true);
        }
        Component[] componentArray = new Component[1];
        this.resultsComponent = this.buildResultsComponent();
        componentArray[0] = this.resultsComponent;
        this.addComponentsAndExpand(componentArray);
        return this;
    }

    private void pdf() {
        try {
            this.getUI().getPage().open(VaadinHelper.listViewComponentToPdf(this, this.getModelForSearchFilters()).toString(), "_blank");
        }
        catch (Throwable throwable) {
            Notifier.alert((Throwable)throwable);
        }
    }

    private void excel() {
        try {
            this.getUI().getPage().open(VaadinHelper.listViewComponentToExcel(this, this.getModelForSearchFilters()).toString(), "_blank");
        }
        catch (Throwable throwable) {
            Notifier.alert((Throwable)throwable);
        }
    }

    private ResultsComponent buildResultsComponent() {
        return new ResultsComponent(this, (Component)this.matchesComponent);
    }

    public List<FieldInterfaced> getColumnFields() {
        return ListViewComponent.getColumnFields(this.getColumnType(), false, this.getFieldsFilter(), new ArrayList<String>(), new HashMap<String, FieldInterfaced>());
    }

    public void buildColumns(Grid grid) {
        List<FieldInterfaced> colFields = this.getColumnFields();
        ListViewComponent.buildColumns(grid, colFields, this instanceof JPAListViewComponent, false, null, null, this.getFieldsFilter());
    }

    public static void buildColumns(Grid grid, List<FieldInterfaced> colFields, boolean isJPAListViewComponent, boolean editable) {
        ListViewComponent.buildColumns(grid, colFields, isJPAListViewComponent, editable, null);
    }

    public static void buildColumns(Grid grid, List<FieldInterfaced> colFields, boolean isJPAListViewComponent, boolean editable, MDDBinder binder) {
        ListViewComponent.buildColumns(grid, colFields, isJPAListViewComponent, editable, binder, null);
    }

    public static void buildColumns(Grid grid, List<FieldInterfaced> colFields, boolean isJPAListViewComponent, boolean editable, MDDBinder binder, FieldInterfaced collectionField) {
        ListViewComponent.buildColumns(grid, colFields, isJPAListViewComponent, editable, binder, null, null);
    }

    public static void buildColumns(Grid grid, List<FieldInterfaced> colFields, boolean isJPAListViewComponent, boolean editable, MDDBinder binder, FieldInterfaced collectionField, String fieldsFilter) {
        ArrayList<String> columnIds = new ArrayList<String>();
        HashMap<String, FieldInterfaced> fieldByColumnId = new HashMap<String, FieldInterfaced>();
        if (!Strings.isNullOrEmpty((String)fieldsFilter)) {
            ArrayList<String> fns = new ArrayList<String>();
            for (String s : fieldsFilter.split(",")) {
                String n = s.trim();
                if (n.contains("(")) {
                    n = n.substring(0, n.indexOf("("));
                }
                if (n.contains(" ")) {
                    n = n.substring(0, n.indexOf(" "));
                }
                fns.add(n);
            }
            for (int i = 0; i < colFields.size(); ++i) {
                fieldByColumnId.put((String)fns.get(i), colFields.get(i));
                columnIds.add((String)fns.get(i));
            }
        } else {
            colFields.forEach(f -> {
                fieldByColumnId.put(f.getId(), (FieldInterfaced)f);
                columnIds.add(f.getId());
            });
        }
        ListViewComponent.buildColumns(grid, columnIds, fieldByColumnId, isJPAListViewComponent, editable, binder, collectionField, fieldsFilter);
    }

    public static void buildColumns(Grid grid, List<String> columnIds, Map<String, FieldInterfaced> fieldByColumnId, boolean isJPAListViewComponent, boolean editable, MDDBinder binder, FieldInterfaced collectionField, String fieldsFilter) {
        Object bean = binder != null ? binder.getBean() : null;
        HashMap<Object, String> nombresColumnas = new HashMap<Object, String>();
        HashMap<Object, String> extras = new HashMap<Object, String>();
        if (!Strings.isNullOrEmpty((String)fieldsFilter)) {
            Pattern patternNombre = Pattern.compile("'(.*?)'");
            Pattern patternParentesis = Pattern.compile("\\((.*?)\\)");
            for (String t : fieldsFilter.split(",")) {
                Matcher matcher;
                String v2;
                String n = t;
                if (n.contains("(")) {
                    n = n.substring(0, n.indexOf("("));
                }
                if (n.contains(" ")) {
                    n = n.substring(0, n.indexOf(" "));
                }
                if (t.contains("'")) {
                    v2 = "";
                    matcher = patternNombre.matcher(t);
                    if (matcher.find()) {
                        v2 = matcher.group(1);
                    }
                    nombresColumnas.putIfAbsent(n, v2);
                }
                if (!t.contains("(")) continue;
                v2 = "";
                matcher = patternParentesis.matcher(t);
                if (matcher.find()) {
                    v2 = matcher.group(1);
                }
                extras.putIfAbsent(n, v2);
            }
        }
        ArrayList<Grid.Column> colBindings = new ArrayList<Grid.Column>();
        HashMap<Grid.Column, FieldInterfaced> fieldByCol = new HashMap<Grid.Column, FieldInterfaced>();
        for (String columnId : columnIds) {
            FieldInterfaced f = fieldByColumnId.get(columnId);
            if (f == null) continue;
            if (f.isAnnotationPresent(UseCheckboxes.class) && ((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline()) {
                Collection possibleValues = null;
                String vmn = ReflectionHelper.getGetter((String)(collectionField.getName() + ReflectionHelper.getFirstUpper((String)f.getName()))) + "Values";
                Method mdp = ReflectionHelper.getMethod((Class)collectionField.getDeclaringClass(), (String)vmn);
                if (mdp != null) {
                    try {
                        possibleValues = (Collection)mdp.invoke(bean, new Object[0]);
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                } else {
                    Notifier.alert((String)("Missing " + vmn + " method at " + collectionField.getDeclaringClass().getName()));
                }
                int pos = 0;
                if (possibleValues == null) continue;
                for (Object v3 : possibleValues) {
                    if (v3 == null) continue;
                    fieldByColumnId.put(columnId + "_" + pos, (FieldInterfaced)new FieldInterfacedForCheckboxColumn(f.getName() + "" + pos, f, v3));
                    ++pos;
                }
                continue;
            }
            fieldByColumnId.put(columnId, f);
        }
        int pos = 0;
        for (final String columnId : columnIds) {
            final FieldInterfaced f = fieldByColumnId.get(columnId);
            if (f == null) continue;
            final int finalPos = (isJPAListViewComponent ? 1 : 0) + pos++;
            ICellStyleGenerator csg = null;
            if (f.isAnnotationPresent(CellStyleGenerator.class)) {
                try {
                    csg = (ICellStyleGenerator)((CellStyleGenerator)f.getAnnotation(CellStyleGenerator.class)).value().newInstance();
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }
            if (Boolean.TYPE.equals(f.getType()) || Boolean.class.equals((Object)f.getType())) {
                csg = new ICellStyleGenerator(){

                    public String getStyles(Object row, Object value) {
                        return "";
                    }

                    public boolean isContentShown() {
                        return true;
                    }
                };
            }
            final DecimalFormat df = new DecimalFormat("##,###,###,###,##0.00");
            final ICellStyleGenerator finalCsg = csg;
            Grid.Column col = grid.addColumn(new ValueProvider(){

                public Object apply(Object o) {
                    Object v = null;
                    if (o instanceof Object[]) {
                        v = ((Object[])o)[finalPos];
                    } else {
                        try {
                            v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)o);
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    if (Double.TYPE.equals(f.getType()) && f.isAnnotationPresent(Money.class)) {
                        return v != null ? df.format(v) : df.format(0L);
                    }
                    if (boolean[].class.equals((Object)f.getType()) && f.isAnnotationPresent(WeekDays.class)) {
                        if (o == null) {
                            return null;
                        }
                        boolean[] wds = (boolean[])v;
                        String s = "";
                        if (wds != null) {
                            for (int i = 0; i < wds.length; ++i) {
                                if (!"".equals(s)) {
                                    s = s + ",";
                                }
                                s = s + (wds[i] ? WeekDaysComponent.days.get(i) : "-");
                            }
                        }
                        return s;
                    }
                    if (LocalDate.class.equals((Object)f.getType())) {
                        return v != null ? ((LocalDate)v).format(DateTimeFormatter.ISO_LOCAL_DATE) : null;
                    }
                    if (LocalDateTime.class.equals((Object)f.getType())) {
                        return v != null ? ((LocalDateTime)v).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")) : null;
                    }
                    if (LocalTime.class.equals((Object)f.getType())) {
                        return v != null ? ((LocalTime)v).format(DateTimeFormatter.ofPattern("HH:mm")) : null;
                    }
                    if (Boolean.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType())) {
                        return "<i class='fas fa-" + (v != null && (Boolean)v != false ? "check" : "times") + "'></i>";
                    }
                    if (IIcon.class.isAssignableFrom(f.getType())) {
                        return v != null ? "" + v : null;
                    }
                    if (IResource.class.equals((Object)f.getType())) {
                        IResource r = (IResource)v;
                        if (r != null) {
                            try {
                                return new Link(r.getName(), (Resource)new ExternalResource(r.toFileLocator().getUrl()), "_blank", 400, 400, BorderStyle.MINIMAL);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        return null;
                    }
                    return v != null ? "" + v : null;
                }
            });
            if (IResource.class.equals((Object)f.getType())) {
                col.setRenderer((Renderer)new ComponentRenderer());
            }
            if (IIcon.class.isAssignableFrom(f.getType())) {
                col.setRenderer((Renderer)new HtmlRenderer(""));
            }
            if (Boolean.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType())) {
                col.setRenderer((Renderer)new HtmlRenderer(""));
            }
            if (csg != null) {
                col.setStyleGenerator(new StyleGenerator(){

                    public String apply(Object o) {
                        try {
                            Object v = null;
                            if (o instanceof Object[]) {
                                v = ((Object[])o)[finalPos];
                            } else {
                                try {
                                    v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)o);
                                }
                                catch (NoSuchMethodException e) {
                                    e.printStackTrace();
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                            String s = finalCsg.getStyles(o, v);
                            if (o instanceof Activable) {
                                if (!((Activable)o).isActive()) {
                                    s = (Strings.isNullOrEmpty((String)s) ? "" : s + " ") + "cancelled";
                                }
                            } else if (o instanceof Cancellable && ((Cancellable)o).isCancelled()) {
                                s = (Strings.isNullOrEmpty((String)s) ? "" : s + " ") + "cancelled";
                            }
                            return s;
                        }
                        catch (Exception e) {
                            Notifier.alert((Throwable)e);
                            return null;
                        }
                    }
                });
            } else if (collectionField != null && collectionField.getGenericClass() != null && (Activable.class.isAssignableFrom(collectionField.getGenericClass()) || Cancellable.class.isAssignableFrom(collectionField.getGenericClass()))) {
                col.setStyleGenerator(new StyleGenerator(){

                    public String apply(Object o) {
                        try {
                            if (o instanceof Activable ? !((Activable)o).isActive() : o instanceof Cancellable && ((Cancellable)o).isCancelled()) {
                                return "cancelled";
                            }
                        }
                        catch (Exception e) {
                            Notifier.alert((Throwable)e);
                        }
                        return null;
                    }
                });
            }
            if (finalCsg != null && !finalCsg.isContentShown()) {
                col.setRenderer((Renderer)new TextRenderer(){

                    public JsonValue encode(Object value) {
                        return super.encode(null);
                    }
                });
            }
            if (f.isAnnotationPresent(HtmlCol.class)) {
                col.setRenderer((Renderer)new HtmlRenderer(""));
            }
            if (Integer.class.equals((Object)f.getType()) || Integer.TYPE.equals(f.getType()) || Long.class.equals((Object)f.getType()) || Long.TYPE.equals(f.getType()) || Double.class.equals((Object)f.getType()) || Double.TYPE.equals(f.getType()) || BigInteger.class.equals((Object)f.getType()) || BigDecimal.class.equals((Object)f.getType()) || Number.class.equals((Object)f.getType()) || FastMoney.class.equals((Object)f.getType()) || MonetaryAmount.class.equals((Object)f.getType()) || f.isAnnotationPresent(RightAlignedCol.class)) {
                if (f.isAnnotationPresent(Balance.class)) {
                    col.setStyleGenerator(new StyleGenerator(){

                        public String apply(Object o) {
                            try {
                                Object v = null;
                                if (o instanceof Object[]) {
                                    v = ((Object[])o)[finalPos];
                                } else {
                                    try {
                                        v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)o);
                                    }
                                    catch (NoSuchMethodException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                }
                                String s = "v-align-right";
                                s = v != null && (Double)v < 0.0 ? s + " negativo" : s + " positivo";
                                return s;
                            }
                            catch (Exception e) {
                                Notifier.alert((Throwable)e);
                                return null;
                            }
                        }
                    });
                } else {
                    col.setStyleGenerator((StyleGenerator & Serializable)c -> "v-align-right");
                }
            }
            if (editable) {
                boolean eager = false;
                if (!f.isAnnotationPresent(Output.class)) {
                    if (collectionField != null && collectionField.isAnnotationPresent(UseComponentsToEditValues.class)) {
                        ListViewComponent.setEditorAsRenderer(col, f, eager, grid, binder, collectionField);
                    } else {
                        TextField nf;
                        final Method mdp = ReflectionHelper.getMethod((Class)f.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)f.getName()) + "DataProvider"));
                        if (f.getType().isAnnotationPresent(UseIdToSelect.class)) {
                            nf = new TextField();
                            if (eager) {
                                nf.setValueChangeMode(ValueChangeMode.EAGER);
                            }
                            col.setEditorBinding(grid.getEditor().getBinder().forField((HasValue)nf).bind((ValueProvider & Serializable)o -> {
                                Object id = null;
                                if (o != null) {
                                    id = ReflectionHelper.getId((Object)o);
                                }
                                return id != null ? "" + id : "";
                            }, (Setter & Serializable)(o, v) -> {
                                Object[] w = new Object[]{null};
                                try {
                                    JPAHelper.notransact(em -> {
                                        FieldInterfaced fid = ReflectionHelper.getIdField((Class)f.getType());
                                        String sql = "select x from " + f.getType().getName() + " x where x." + fid.getName() + " = :i";
                                        Object id = null;
                                        id = Integer.TYPE.equals(fid.getType()) || Integer.class.equals((Object)fid.getType()) ? Integer.valueOf(Integer.parseInt((String)v)) : (Long.TYPE.equals(fid.getType()) || Long.class.equals((Object)fid.getType()) ? Long.valueOf(Long.parseLong((String)v)) : (String.class.equals((Object)fid.getType()) ? v : v));
                                        Query q = em.createQuery(sql).setParameter("i", id);
                                        List r = q.getResultList();
                                        if (r.size() == 1) {
                                            w[0] = r.get(0);
                                            nf.setComponentError(null);
                                        } else {
                                            nf.setComponentError((ErrorMessage)new UserError("Not found"));
                                        }
                                    });
                                }
                                catch (Throwable throwable) {
                                    if (throwable instanceof InvocationTargetException) {
                                        throwable = throwable.getCause();
                                    }
                                    String msg = throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName();
                                    nf.setComponentError((ErrorMessage)new UserError(msg));
                                    Notifier.alert((Throwable)throwable);
                                }
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)w[0]);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            }));
                            col.setEditable(true);
                        } else if (f.isAnnotationPresent(ValueClass.class) || f.isAnnotationPresent(DataProvider.class) || mdp != null || f.isAnnotationPresent(ManyToOne.class)) {
                            FieldInterfaced fName;
                            final ComboBox cb = new ComboBox();
                            boolean necesitaCaptionGenerator = false;
                            if (mdp == null) {
                                ValueClass a;
                                if (f.isAnnotationPresent(ValueClass.class)) {
                                    a = (ValueClass)f.getAnnotation(ValueClass.class);
                                    cb.setDataProvider((ListDataProvider)new JPQLListDataProvider(a.value()));
                                } else if (f.isAnnotationPresent(DataProvider.class)) {
                                    necesitaCaptionGenerator = true;
                                    try {
                                        a = (DataProvider)f.getAnnotation(DataProvider.class);
                                        ((HasDataProvider)cb).setDataProvider((com.vaadin.data.provider.DataProvider)a.dataProvider().newInstance());
                                        cb.setItemCaptionGenerator((ItemCaptionGenerator)a.itemCaptionGenerator().newInstance());
                                    }
                                    catch (InstantiationException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    necesitaCaptionGenerator = true;
                                    try {
                                        JPAHelper.notransact(em -> cb.setDataProvider((ListDataProvider)new JPQLListDataProvider(em, f)));
                                    }
                                    catch (Throwable throwable) {
                                        throwable.printStackTrace();
                                    }
                                }
                            }
                            if (necesitaCaptionGenerator && (fName = ReflectionHelper.getNameField((Class)f.getType())) != null) {
                                cb.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)i -> {
                                    try {
                                        return "" + ReflectionHelper.getValue((FieldInterfaced)fName, (Object)i);
                                    }
                                    catch (NoSuchMethodException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                    return "Error";
                                });
                            }
                            if (mdp != null) {
                                grid.getEditor().addOpenListener(new EditorOpenListener(){

                                    public void onEditorOpen(EditorOpenEvent editorOpenEvent) {
                                        try {
                                            Object object = editorOpenEvent.getBean();
                                            cb.setDataProvider((com.vaadin.data.provider.DataProvider)mdp.invoke(object, new Object[0]), (SerializableFunction & Serializable)fx -> new SerializablePredicate(){

                                                public boolean test(Object o) {
                                                    String s = (String)fx;
                                                    return o != null && (Strings.isNullOrEmpty((String)s) || cb.getItemCaptionGenerator().apply(o).toLowerCase().contains(s.toLowerCase()));
                                                }
                                            });
                                        }
                                        catch (Exception e) {
                                            Notifier.alert((Throwable)e);
                                        }
                                    }
                                });
                            }
                            col.setEditorComponent((HasValue)cb, (Setter & Serializable)(o, v) -> {
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            });
                            col.setEditable(true);
                        } else if (FareValue.class.equals((Object)f.getType())) {
                            nf = new TextField();
                            nf.setValueChangeMode(ValueChangeMode.EAGER);
                            col.setEditorBinding(grid.getEditor().getBinder().forField((HasValue)nf).bind((ValueProvider & Serializable)o -> ReflectionHelper.getValue((FieldInterfaced)f, (Object)o, (Object)""), (Setter & Serializable)(o, v) -> {
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)(v != null ? new FareValue((String)v) : null));
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            }));
                            col.setEditable(true);
                        } else if (f.isAnnotationPresent(WeekDays.class)) {
                            ArrayList days = Lists.newArrayList((Object[])new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"});
                            col.setEditorComponent((HasValue)new WeekDaysGridEditor(), (Setter & Serializable)(o, v) -> {
                                try {
                                    boolean[] array = new boolean[]{false, false, false, false, false, false, false};
                                    if (v != null) {
                                        for (int i = 0; i < days.size(); ++i) {
                                            if (i >= array.length) continue;
                                            array[i] = ((String)v).contains((CharSequence)days.get(i));
                                        }
                                    }
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)((boolean[])(v != null ? array : null)));
                                    if (binder != null) {
                                        binder.refresh();
                                    }
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            });
                            col.setEditable(true);
                        } else if (Boolean.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType())) {
                            col.setEditorComponent((HasValue)new CheckBox(), (Setter & Serializable)(o, v) -> {
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                                    if (binder != null) {
                                        binder.refresh();
                                    }
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            });
                            col.setEditable(true);
                        } else if (String.class.equals((Object)f.getType())) {
                            nf = new TextField();
                            if (eager) {
                                nf.setValueChangeMode(ValueChangeMode.EAGER);
                            }
                            col.setEditorBinding(grid.getEditor().getBinder().forField((HasValue)nf).bind((ValueProvider & Serializable)o -> ReflectionHelper.getValue((FieldInterfaced)f, (Object)o, (Object)""), (Setter & Serializable)(o, v) -> {
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            }));
                            col.setEditable(true);
                        } else if (Integer.class.equals((Object)f.getType()) || Integer.TYPE.equals(f.getType()) || Long.class.equals((Object)f.getType()) || Long.TYPE.equals(f.getType())) {
                            nf = new TextField();
                            if (eager) {
                                nf.setValueChangeMode(ValueChangeMode.EAGER);
                            }
                            col.setEditorBinding(grid.getEditor().getBinder().forField((HasValue)nf).bind((ValueProvider & Serializable)o -> "" + ReflectionHelper.getValue((FieldInterfaced)f, (Object)o, (Object)""), (Setter & Serializable)(o, v) -> {
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            }));
                            col.setEditable(true);
                        } else if (Double.class.equals((Object)f.getType()) || Double.TYPE.equals(f.getType())) {
                            nf = new TextField();
                            if (eager) {
                                nf.setValueChangeMode(ValueChangeMode.EAGER);
                            }
                            col.setEditorBinding(grid.getEditor().getBinder().forField((HasValue)nf).bind((ValueProvider & Serializable)o -> "" + ReflectionHelper.getValue((FieldInterfaced)f, (Object)o, (Object)""), (Setter & Serializable)(o, v) -> {
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            }));
                            col.setEditable(true);
                        } else if (LocalDate.class.equals((Object)f.getType())) {
                            nf = new DateField();
                            col.setEditorBinding(grid.getEditor().getBinder().forField((HasValue)nf).bind((ValueProvider & Serializable)o -> ReflectionHelper.getValue((FieldInterfaced)f, (Object)o, null), (Setter & Serializable)(o, v) -> {
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            }));
                            col.setEditable(true);
                        } else if (LocalDateTime.class.equals((Object)f.getType())) {
                            nf = new DateTimeField();
                            col.setEditorBinding(grid.getEditor().getBinder().forField((HasValue)nf).bind((ValueProvider & Serializable)o -> ReflectionHelper.getValue((FieldInterfaced)f, (Object)o, null), (Setter & Serializable)(o, v) -> {
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            }));
                            col.setEditable(true);
                        } else if (LocalTime.class.equals((Object)f.getType())) {
                            nf = new TextField();
                            col.setEditorBinding(grid.getEditor().getBinder().forField((HasValue)nf).bind((ValueProvider & Serializable)o -> "" + ReflectionHelper.getValue((FieldInterfaced)f, (Object)o, (Object)""), (Setter & Serializable)(o, v) -> {
                                try {
                                    String s;
                                    LocalTime t = null;
                                    if (v != null && v instanceof String && !"".equals(s = (String)v)) {
                                        try {
                                            t = LocalTime.parse(s, DateTimeFormatter.ofPattern("HHmm"));
                                        }
                                        catch (Exception e1) {
                                            try {
                                                t = LocalTime.parse(s, DateTimeFormatter.ofPattern("HH:mm"));
                                            }
                                            catch (Exception e2) {
                                                try {
                                                    t = LocalTime.parse(s, DateTimeFormatter.ofPattern("HH.mm"));
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                    }
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, t);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            }));
                            col.setEditable(true);
                        } else if (f.getType().isEnum()) {
                            ComboBox tf = new ComboBox();
                            tf.setDataProvider(new ListDataProvider(Arrays.asList(f.getType().getEnumConstants())));
                            col.setEditorComponent((HasValue)tf, (Setter & Serializable)(o, v) -> {
                                try {
                                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            });
                            col.setEditable(true);
                        }
                    }
                }
            }
            colBindings.add(col);
            fieldByCol.put(col, f);
            String caption = nombresColumnas.getOrDefault(columnId, Helper.capitalize((String)f.getName()));
            if (f instanceof FieldInterfacedForCheckboxColumn) {
                caption = ((FieldInterfacedForCheckboxColumn)f).getCaption();
            }
            if (f.isAnnotationPresent(Caption.class)) {
                caption = ((Caption)f.getAnnotation(Caption.class)).value();
            }
            col.setCaption(Translator.translate((String)caption));
            if (columnIds.size() == 1) {
                col.setExpandRatio(1);
            } else {
                col.setWidth(ListViewComponent.getColumnWidth(f, (String)extras.get(columnId)));
            }
            col.setSortOrderProvider(new SortOrderProvider(){

                public Stream<QuerySortOrder> apply(SortDirection sortDirection) {
                    return Stream.of(new QuerySortOrder(columnId, sortDirection));
                }
            }).setId(columnId);
        }
    }

    private static void setEditorAsRenderer(Grid.Column col, FieldInterfaced f, boolean eager, Grid grid, MDDBinder binder, FieldInterfaced collectionField) {
        Method mdp = ReflectionHelper.getMethod((Class)f.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)f.getName()) + "DataProvider"));
        Setter & Serializable setter = (Setter & Serializable)(o, v) -> {
            try {
                ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                ReflectionHelper.setValue((FieldInterfaced)collectionField, (Object)binder.getBean(), (Object)ReflectionHelper.getValue((FieldInterfaced)collectionField, (Object)binder.getBean()));
                binder.refresh();
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        };
        if (f.getType().isAnnotationPresent(UseIdToSelect.class)) {
            col.setRenderer((ValueProvider & Serializable)o -> {
                Object id = null;
                if (o != null) {
                    id = ReflectionHelper.getId((Object)o);
                }
                return id != null ? "" + id : "";
            }, (Renderer)new TextFieldRenderer((Setter & Serializable)(o, v) -> {
                Object[] w = new Object[]{null};
                try {
                    JPAHelper.notransact(em -> {
                        FieldInterfaced fid = ReflectionHelper.getIdField((Class)f.getType());
                        String sql = "select x from " + f.getType().getName() + " x where x." + fid.getName() + " = :i";
                        Object id = null;
                        id = Integer.TYPE.equals(fid.getType()) || Integer.class.equals((Object)fid.getType()) ? Integer.valueOf(Integer.parseInt((String)v)) : (Long.TYPE.equals(fid.getType()) || Long.class.equals((Object)fid.getType()) ? Long.valueOf(Long.parseLong((String)v)) : (String.class.equals((Object)fid.getType()) ? v : v));
                        Query q = em.createQuery(sql).setParameter("i", id);
                        List r = q.getResultList();
                        if (r.size() == 1) {
                            w[0] = r.get(0);
                        } else {
                            Notifier.alert((String)"Not found");
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InvocationTargetException) {
                        throwable = throwable.getCause();
                    }
                    String msg = throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName();
                    Notifier.alert((Throwable)throwable);
                }
                try {
                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)w[0]);
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }));
        } else if (f.isAnnotationPresent(ValueClass.class) || f.isAnnotationPresent(DataProvider.class) || mdp != null || f.isAnnotationPresent(ManyToOne.class)) {
            col.setRenderer((Renderer)new SimpleSelectRenderer((Setter & Serializable)(o, v) -> {
                try {
                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }, new ArrayList()));
        } else if (FareValue.class.equals((Object)f.getType())) {
            col.setRenderer((ValueProvider & Serializable)o -> ReflectionHelper.getValue((FieldInterfaced)f, (Object)o, (Object)""), (Renderer)new TextFieldRenderer((Setter & Serializable)(o, v) -> {
                try {
                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)(v != null ? new FareValue((String)v) : null));
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }));
        } else if (f.isAnnotationPresent(WeekDays.class)) {
            ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"});
        } else if (Boolean.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType())) {
            col.setRenderer((Renderer)new CheckboxRenderer((Setter)setter));
        } else if (String.class.equals((Object)f.getType())) {
            TextFieldRenderer r = new TextFieldRenderer((Setter)setter);
            col.setRenderer((Renderer)r);
            r.setConverter((Converter)new DummyConverter());
        } else if (Integer.class.equals((Object)f.getType()) || Integer.TYPE.equals(f.getType()) || Long.class.equals((Object)f.getType()) || Long.TYPE.equals(f.getType())) {
            TextFieldRenderer r = new TextFieldRenderer((Setter)setter);
            col.setRenderer((Renderer)r);
            r.setConverter((Converter)new DummyConverter());
        } else if (Double.class.equals((Object)f.getType()) || Double.TYPE.equals(f.getType())) {
            TextFieldRenderer r = new TextFieldRenderer((Setter)setter);
            col.setRenderer((Renderer)r);
            r.setConverter((Converter)new DummyConverter());
        } else if (LocalDate.class.equals((Object)f.getType())) {
            TextFieldRenderer r = new TextFieldRenderer((Setter)setter);
            col.setRenderer((Renderer)r);
            r.setConverter((Converter)new DummyConverter(null));
        } else if (LocalDateTime.class.equals((Object)f.getType())) {
            TextFieldRenderer r = new TextFieldRenderer((Setter)setter);
            col.setRenderer((Renderer)r);
            r.setConverter((Converter)new DummyConverter(null));
        } else if (LocalTime.class.equals((Object)f.getType())) {
            col.setRenderer((ValueProvider & Serializable)o -> "" + ReflectionHelper.getValue((FieldInterfaced)f, (Object)o, (Object)""), (Renderer)new DateFieldRenderer((Setter & Serializable)(o, v) -> {
                try {
                    String s;
                    LocalTime t = null;
                    if (v != null && v instanceof String && !"".equals(s = (String)v)) {
                        try {
                            t = LocalTime.parse(s, DateTimeFormatter.ofPattern("HHmm"));
                        }
                        catch (Exception e1) {
                            try {
                                t = LocalTime.parse(s, DateTimeFormatter.ofPattern("HH:mm"));
                            }
                            catch (Exception e2) {
                                try {
                                    t = LocalTime.parse(s, DateTimeFormatter.ofPattern("HH.mm"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, t);
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }));
        } else if (f.getType().isEnum()) {
            col.setRenderer((Renderer)new SimpleSelectRenderer((Setter & Serializable)(o, v) -> {
                try {
                    ReflectionHelper.setValue((FieldInterfaced)f, (Object)o, (Object)v);
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }, Arrays.asList(f.getType().getEnumConstants())));
        }
    }

    private static void refrescar(Grid.Column col, MDDBinder binder, FieldInterfaced f, Object o, Object v, List<Grid.Column> colBindings, Map<Grid.Column, FieldInterfaced> fieldByCol) {
        if (binder != null) {
            binder.refresh();
        }
    }

    public static double getColumnWidth(FieldInterfaced f) {
        return ListViewComponent.getColumnWidth(f, null);
    }

    public static double getColumnWidth(FieldInterfaced f, String overriden) {
        if (!Strings.isNullOrEmpty((String)overriden)) {
            return Double.parseDouble(overriden);
        }
        if (f.isAnnotationPresent(ColumnWidth.class)) {
            return ((ColumnWidth)f.getAnnotation(ColumnWidth.class)).value();
        }
        Class t = f.getType();
        if (Integer.TYPE.equals(t) || Integer.class.equals((Object)t) || Long.TYPE.equals(t) || Long.class.equals((Object)t) || Float.TYPE.equals(t) || Float.class.equals((Object)t) || Double.TYPE.equals(t) || Double.class.equals((Object)t) || Boolean.TYPE.equals(t) || Boolean.class.equals((Object)t) || BigInteger.class.equals((Object)t) || BigDecimal.class.equals((Object)t) || Number.class.equals((Object)t)) {
            return 120.0;
        }
        if (LocalDate.class.equals((Object)t)) {
            return 125.0;
        }
        if (LocalDateTime.class.equals((Object)t)) {
            return 225.0;
        }
        if (LocalTime.class.equals((Object)t)) {
            return 225.0;
        }
        if (FareValue.class.equals((Object)t)) {
            return 125.0;
        }
        if (f.isAnnotationPresent(WeekDays.class)) {
            return 200.0;
        }
        return 250.0;
    }

    public void search(Object filters) throws Throwable {
        this.setModelForSearchFilters(filters);
        this.resultsComponent.search(filters);
    }

    public ListViewComponent addListener(ListViewComponentListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public void edit(Object id) {
        for (ListViewComponentListener l : this.listeners) {
            l.onEdit(id);
        }
    }

    public void select(Object id) {
        for (ListViewComponentListener l : this.listeners) {
            l.onSelect(id);
        }
    }

    public Object getPrevious(Object current) {
        Object x;
        if (this.resultsComponent == null) {
            try {
                this.build();
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
        if ((x = this.resultsComponent.getPrevious()) == null) {
            return null;
        }
        if (this.getView().getViewComponent() instanceof RpcListViewComponent && ((RpcListViewComponent)this.getView().getViewComponent()).getRpcListView() instanceof AbstractJPQLListView) {
            try {
                return ReflectionHelper.getId((Object)((RpcListViewComponent)this.getView().getViewComponent()).getRpcListView().onEdit(x));
            }
            catch (Throwable throwable) {
                Notifier.alert((Throwable)throwable);
            }
        }
        return this.toId(x);
    }

    public Object getNext(Object current) {
        Object x;
        if (this.resultsComponent == null) {
            try {
                this.build();
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
        if ((x = this.resultsComponent.getNext()) == null) {
            return null;
        }
        if (this.getView().getViewComponent() instanceof RpcListViewComponent && ((RpcListViewComponent)this.getView().getViewComponent()).getRpcListView() instanceof AbstractJPQLListView) {
            try {
                return ReflectionHelper.getId((Object)((RpcListViewComponent)this.getView().getViewComponent()).getRpcListView().onEdit(x));
            }
            catch (Throwable throwable) {
                Notifier.alert((Throwable)throwable);
            }
        }
        return this.toId(x);
    }

    public abstract Collection findAll(Object var1, List<QuerySortOrder> var2, int var3, int var4);

    public int count(Object filters) throws Throwable {
        List<ChartData> charts;
        this.count = this.gatherCount(filters);
        String s = this.count == 1 ? "" + this.count + " match." : "" + this.count + " matches";
        s = s + this.toCountLabel(filters);
        s = s + ".";
        this.countLabel.setValue(s);
        List<SumData> sums = this.getSums(filters);
        this.getKpisContainer().removeAllComponents();
        if (sums != null && sums.size() > 0) {
            for (SumData d : sums) {
                this.getKpisContainer().addComponent(this.buildSum(d));
            }
        }
        if (MDDUIAccessor.getApp().isChartsEnabled() && (charts = this.getCharts(filters)) != null && charts.size() > 0) {
            for (ChartData d : charts) {
                this.getKpisContainer().addComponent(this.buildChart(d));
            }
        }
        return this.count;
    }

    private String toCountLabel(Object filters) {
        String s = "";
        if (filters != null) {
            for (FieldInterfaced f : this.getFilterFields()) {
                if (f.isAnnotationPresent(Version.class) || f.isAnnotationPresent(Ignored.class)) continue;
                try {
                    Object v = f.getValue(filters);
                    if (v == null || v instanceof String && Strings.isNullOrEmpty((String)((String)v))) continue;
                    if (!"".equals(s)) {
                        s = s + ", ";
                    }
                    s = s + ReflectionHelper.getCaption((FieldInterfaced)f) + " = " + v;
                    s = s + "";
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }
        }
        if (!"".equals(s)) {
            s = " where " + s;
        }
        return s;
    }

    @Override
    public String getPageTitle() {
        try {
            return super.getPageTitle() + this.toCountLabel(this.getModelForSearchFilters());
        }
        catch (Exception exception) {
            return super.getTitle();
        }
    }

    private Component buildChart(ChartData d) {
        DonutChartConfig config = new DonutChartConfig();
        config.data().labelsAsList(d.getValues().stream().map(v -> v.getTitle()).collect(Collectors.toList())).addDataset((Dataset)new PieDataset().label(d.getTitle())).and();
        ((PieChartOptions)((PieChartOptions)((PieChartOptions)config.options().rotation(Math.PI).circumference(Math.PI).responsive(true)).title().display(true).text(d.getTitle()).and()).animation().animateScale(false).animateRotate(true).and()).done();
        double total = 0.0;
        for (Object v2 : d.getValues()) {
            total += v2.getValue();
        }
        List labels = config.data().getLabels();
        for (Dataset ds : config.data().getDatasets()) {
            PieDataset lds = (PieDataset)ds;
            String[] colors = d.getValues().stream().map(v -> v.getStyle().toLowerCase().replaceAll("mdd-", "").replaceAll("-bgd", "")).collect(Collectors.toList()).toArray(new String[0]);
            if (colors.length > 0 && !Strings.isNullOrEmpty((String)colors[0])) {
                lds.backgroundColor(colors);
            } else {
                lds.randomBackgroundColors(true);
            }
            ArrayList<Double> data = new ArrayList<Double>();
            for (int i = 0; i < d.getValues().size(); ++i) {
                data.add(((ChartValue)d.getValues().get(i)).getValue());
            }
            lds.dataAsList(data);
        }
        ChartJs chart = new ChartJs((ChartConfig)config);
        chart.setJsLoggingEnabled(true);
        if (d.getField() != null) {
            chart.addClickListener((a, b) -> {
                Object bean = this.filtersComponent.getBinder().getBean();
                try {
                    ReflectionHelper.setValue((FieldInterfaced)d.getField(), (Object)bean, (Object)((ChartValue)d.getValues().get(b)).getKey());
                    this.filtersComponent.getBinder().setBean(bean);
                    this.search(bean);
                }
                catch (Throwable throwable) {
                    Notifier.alert((Throwable)throwable);
                }
            });
        }
        return chart;
    }

    private Component buildSum(SumData d) {
        VerticalLayout vl = new VerticalLayout();
        vl.addStyleName("kpi");
        vl.setWidthUndefined();
        vl.addComponent((Component)new Label(d.getTitle()));
        String v = d.getValue();
        Label l = new Label();
        vl.addComponent((Component)l);
        l.addStyleName("valor");
        l.setContentMode(ContentMode.HTML);
        String s = "";
        if (Double.TYPE.equals(v.getClass())) {
            DecimalFormat df = new DecimalFormat("##,###,###,###,##0.00");
            s = df.format(v != null ? v : Integer.valueOf(0));
            if (v != null && (Double)((Object)v) < 0.0) {
                l.addStyleName("negativo");
                l.removeStyleName("positivo");
            } else {
                l.addStyleName("positivo");
                l.removeStyleName("negativo");
            }
        } else if (v == null) {
            s = "";
        } else if (v instanceof Boolean) {
            if (((Boolean)((Object)v)).booleanValue()) {
                s = VaadinIcons.CHECK.getHtml();
                l.addStyleName("friendly");
            } else {
                s = VaadinIcons.CLOSE.getHtml();
                l.addStyleName("danger");
            }
            l.addStyleName("centered");
        } else {
            s = "" + v;
        }
        l.setValue(s);
        return vl;
    }

    protected abstract int gatherCount(Object var1) throws Throwable;

    protected abstract List<SumData> getSums(Object var1);

    protected abstract List<ChartData> getCharts(Object var1);

    public abstract Object deserializeId(String var1);

    public String getPathForEditor(Object id) {
        return "" + id;
    }

    public String getPathForFilters() {
        return "filters";
    }

    public abstract Object getModelForSearchFilters() throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException;

    public abstract void setModelForSearchFilters(Object var1);

    public Component getFiltersViewComponent() {
        return this.filtersComponent.getFiltersViewComponent();
    }

    public Class getModelType() {
        return ((Object)((Object)this)).getClass();
    }

    public Method getMethod(String methodName) {
        Method a = null;
        for (Method m : ReflectionHelper.getAllMethods((Class)this.getFiltersType())) {
            if (!RpcView.class.isAssignableFrom(this.getFiltersType()) || !m.getName().equals(methodName)) continue;
            a = m;
            break;
        }
        for (Method m : ReflectionHelper.getAllMethods((Class)this.getModelType())) {
            if (!Modifier.isStatic(m.getModifiers()) || !m.getName().equals(methodName)) continue;
            a = m;
            break;
        }
        return a;
    }

    public Set getSelection() {
        return this.resultsComponent.getSelection();
    }

    public static List<FieldInterfaced> getColumnFields(Class objectType) {
        return ListViewComponent.getColumnFields(objectType, false);
    }

    public static List<FieldInterfaced> getColumnFields(Class objectType, boolean forGrid) {
        return ListViewComponent.getColumnFields(objectType, forGrid, null, null, null);
    }

    public static List<FieldInterfaced> getColumnFields(Class objectType, boolean forGrid, String fieldsFilter, List<String> columNames, Map<String, FieldInterfaced> fieldsByColumnName) {
        List<Object> explicitColumns = null;
        if (Strings.isNullOrEmpty((String)fieldsFilter)) {
            explicitColumns = ReflectionHelper.getAllFields((Class)objectType).stream().filter(f -> f.isAnnotationPresent(ListColumn.class)).peek(f -> {
                if (columNames != null && fieldsByColumnName != null) {
                    String n = f.getName();
                    columNames.add(n);
                    fieldsByColumnName.put(n, (FieldInterfaced)f);
                }
            }).filter(f -> f != null).collect(Collectors.toList());
        } else {
            List<Object> fns = Lists.newArrayList((Object[])fieldsFilter.split(","));
            fns = fns.stream().map(n -> {
                n = n.trim();
                if ((n = n.replaceAll("\\(.*\\)", "")).contains(" ")) {
                    n = n.substring(0, n.indexOf(" "));
                }
                n = n.replaceAll(" ", "");
                return n;
            }).collect(Collectors.toList());
            explicitColumns = fns.stream().map(n -> {
                FieldInterfaced f = ReflectionHelper.getFieldByName((Class)objectType, (String)n);
                if (columNames != null && fieldsByColumnName != null) {
                    columNames.add((String)n);
                    fieldsByColumnName.put((String)n, f);
                }
                return f;
            }).filter(f -> f != null).collect(Collectors.toList());
        }
        if (explicitColumns.size() > 0) {
            return explicitColumns;
        }
        List<FieldInterfaced> cols = ReflectionHelper.getAllFields((Class)objectType).stream().filter(f -> !"_proxied".equalsIgnoreCase(f.getName()) && !"_possibleValues".equalsIgnoreCase(f.getName()) && !"_binder".equalsIgnoreCase(f.getName()) && !"_field".equalsIgnoreCase(f.getName()) && !Modifier.isTransient(f.getModifiers()) && !f.isAnnotationPresent(Transient.class) && !f.isAnnotationPresent(NotInList.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && !f.isAnnotationPresent(Password.class) && (!Collection.class.isAssignableFrom(f.getType()) || forGrid && f.isAnnotationPresent(UseCheckboxes.class) && ((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline()) && !Map.class.isAssignableFrom(f.getType()) && !f.isAnnotationPresent(GeneratedValue.class) && (ReflectionHelper.isBasico((Class)f.getType()) || BigDecimal.class.equals((Object)f.getType()) || f.getType().isEnum() || f.getType().isAnnotationPresent(Entity.class) || java.sql.Date.class.equals((Object)f.getType()) || FareValue.class.equals((Object)f.getType()) || f.isAnnotationPresent(WeekDays.class) || forGrid && f.isAnnotationPresent(UseCheckboxes.class) && ((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline())).filter(f -> f != null).collect(Collectors.toList());
        if (columNames != null && fieldsByColumnName != null) {
            cols.forEach(f -> {
                columNames.add(f.getName());
                fieldsByColumnName.put(f.getName(), (FieldInterfaced)f);
            });
        }
        return cols;
    }

    public abstract Class getColumnType();

    public List<FieldInterfaced> getFilterFields() {
        return this.getFilterFields(this.getFiltersType());
    }

    public List<FieldInterfaced> getFilterFields(Class filtersType) {
        List<FieldInterfaced> explicitFilters = ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Password.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && f.isAnnotationPresent(SearchFilter.class) || f.isAnnotationPresent(MainSearchFilter.class)).collect(Collectors.toList());
        if (explicitFilters.size() > 0) {
            return explicitFilters;
        }
        return ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Password.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && !f.isAnnotationPresent(Output.class) && !IResource.class.equals((Object)f.getType()) && (String.class.equals((Object)f.getType()) || LocalDate.class.equals((Object)f.getType()) || LocalDateTime.class.equals((Object)f.getType()) || LocalTime.class.equals((Object)f.getType()) || Date.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType()) || Boolean.class.equals((Object)f.getType()) || f.getType().isEnum() || f.isAnnotationPresent(ManyToOne.class) || f.getType().isAnnotationPresent(Entity.class))).collect(Collectors.toList());
    }

    public abstract Class getFiltersType();

    public boolean isAddEnabled() {
        return false;
    }

    public boolean isDeleteEnabled() {
        return false;
    }

    @Override
    public void addViewActionsMenuItems(CssLayout bar) {
        Button i;
        if (this.isAddEnabled()) {
            i = new Button("New", (Resource)VaadinIcons.PLUS);
            bar.addComponent((Component)i);
            i.addStyleName("quiet");
            i.addClickListener((Button.ClickListener & Serializable)e -> {
                try {
                    MDDUIAccessor.go((String)"new");
                }
                catch (Throwable throwable) {
                    Notifier.alert((Throwable)throwable);
                }
            });
            i.setClickShortcut(78, new int[]{17, 18});
        }
        if (this.isDeleteEnabled()) {
            i = new Button("Delete", (Resource)VaadinIcons.MINUS);
            bar.addComponent((Component)i);
            i.addStyleName("quiet");
            i.addClickListener((Button.ClickListener & Serializable)e -> VaadinHelper.confirm("Are you sure you want to delete the selected items?", new Runnable(){

                @Override
                public void run() {
                    try {
                        ListViewComponent.this.delete(ListViewComponent.this.getSelection());
                        ListViewComponent.this.resultsComponent.refresh();
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                }
            }));
            i.setClickShortcut(46, new int[]{17});
        }
        super.addViewActionsMenuItems(bar);
    }

    protected void delete(Set selection) {
    }

    public Object toId(Object row) {
        if (row != null && row.getClass().isAnnotationPresent(NativeJPQLResult.class)) {
            return row;
        }
        return ReflectionHelper.getId((Object)row);
    }

    public Grid getGrid() {
        return this.resultsComponent.getGrid();
    }

    public void decorateGridMain(Grid grid) {
        int pos = 2;
        for (FieldInterfaced f : ListViewComponent.getColumnFields(this.getColumnType())) {
            if (StyledEnum.class.isAssignableFrom(f.getType())) {
                Grid.Column col = grid.getColumn(f.getName());
                int finalPos = pos;
                col.setStyleGenerator((StyleGenerator & Serializable)o -> {
                    if (o instanceof Object[]) {
                        return ((StyledEnum)((Object[])o)[finalPos]).getStyle();
                    }
                    try {
                        return ((StyledEnum)ReflectionHelper.getValue((FieldInterfaced)f, (Object)o)).getStyle();
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                        return null;
                    }
                });
            }
            ++pos;
        }
        this.decorateGrid(grid);
    }

    public abstract void decorateGrid(Grid var1);

    public int getFrozenColumnCount() {
        return 0;
    }

    public void searched() {
        MDDUIAccessor.goTo((String)this.getUrl());
    }

    public String getUrl() {
        String s;
        String u = this.baseUrl;
        if (u == null) {
            u = MDDUIAccessor.getCurrentState();
        }
        if (u.contains("/") && (s = u.substring(u.lastIndexOf("/"))).contains("&")) {
            u = u.substring(0, u.length() - (s.length() - s.indexOf("&") - 1));
        }
        u = u + this.getModelForSearchFiltersSerialized();
        return u;
    }

    private String getModelForSearchFiltersSerialized() {
        Base64.Encoder b64 = Base64.getEncoder();
        String s = "";
        try {
            Object m = this.getModelForSearchFilters();
            for (FieldInterfaced f : ReflectionHelper.getAllFields(m.getClass())) {
                Object v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)m);
                if (v == null) continue;
                if (v.getClass().isAnnotationPresent(Entity.class)) {
                    v = ReflectionHelper.getValue((FieldInterfaced)ReflectionHelper.getIdField(v.getClass()), (Object)v);
                } else if (v.getClass().isEnum()) {
                    v = ((Enum)v).name();
                }
                s = s + "&";
                s = s + "" + f.getName() + "_" + b64.encodeToString(("" + v).getBytes("utf-8"));
            }
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
        return s;
    }

    private static /* synthetic */ void lambda$refrescar$5(Map fieldByCol, Object o, Grid.Column b) {
        try {
            Object w = ReflectionHelper.getValue((FieldInterfaced)((FieldInterfaced)fieldByCol.get(b)), (Object)o);
            if (b.getEditorBinding() != null && b.getEditorBinding().getField() != null) {
                if (b.getEditorBinding().getField() instanceof TextField) {
                    b.getEditorBinding().getField().setValue((Object)(w != null ? "" + w : ""));
                } else {
                    b.getEditorBinding().getField().setValue(w);
                }
            } else {
                log.debug("columna " + b.getId() + " no es editable");
                b.getValueProvider().apply(o);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ boolean lambda$refrescar$4(Grid.Column col, Grid.Column e) {
        return !e.equals((Object)col);
    }
}

