/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.vaadin.data.HasValue;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.app.Found;
import io.mateu.mdd.core.app.Searcher;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class SearchInMenuComponent
extends AbstractViewComponent {
    private final VerticalLayout resultsLayout = new VerticalLayout();
    private final Searcher searcher;

    @Override
    public VaadinIcons getIcon() {
        return VaadinIcons.SEARCH;
    }

    public String toString() {
        return "Search in " + MDDUIAccessor.getApp().getName();
    }

    public SearchInMenuComponent(Searcher searcher) {
        this.searcher = searcher;
        try {
            this.build();
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
    }

    public SearchInMenuComponent build() throws Exception {
        CssLayout marco;
        super.build();
        this.setSizeFull();
        if (this.getIcon() == null) {
            this.hideHeader();
        } else {
            this.addStyleName("searchinmenucomponent");
        }
        Object object = marco = MDDUIAccessor.isMobile() ? new CssLayout() : new HorizontalLayout();
        if (!MDDUIAccessor.isMobile()) {
            marco.setSizeFull();
        }
        this.addComponentsAndExpand(new Component[]{marco});
        VerticalLayout form = new VerticalLayout();
        marco.addComponent((Component)form);
        form.addStyleName("nopadding");
        form.setWidth("300px");
        boolean primero = true;
        for (final FieldInterfaced f : ReflectionHelper.getAllEditableFields(this.searcher.getClass())) {
            TextField t = new TextField(Helper.capitalize((String)f.getName()));
            form.addComponent((Component)t);
            t.setPlaceholder("Type to search");
            t.setValueChangeTimeout(100);
            if (primero) {
                t.focus();
                primero = false;
            }
            t.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){

                public void valueChange(HasValue.ValueChangeEvent<String> e) {
                    SearchInMenuComponent.this.search(f, (String)e.getValue());
                }
            });
        }
        Panel contentContainer = new Panel();
        contentContainer.addStyleName("borderless");
        contentContainer.addStyleName("contentcontainer");
        contentContainer.addStyleName("nopadding");
        contentContainer.setContent((Component)this.resultsLayout);
        this.resultsLayout.addStyleName("nopadding");
        marco.addComponent((Component)contentContainer);
        if (!MDDUIAccessor.isMobile()) {
            contentContainer.setSizeFull();
            ((HorizontalLayout)marco).setExpandRatio((Component)contentContainer, 1.0f);
        }
        this.addComponentsAndExpand(new Component[]{marco});
        this.search(ReflectionHelper.getFieldByName(this.searcher.getClass(), (String)"menu"), null);
        return this;
    }

    private void search(FieldInterfaced field, String text) {
        if (text == null) {
            text = "";
        }
        text = text.toLowerCase();
        this.resultsLayout.removeAllComponents();
        List found = new ArrayList();
        try {
            Method m = ReflectionHelper.getMethod(this.searcher.getClass(), (String)ReflectionHelper.getGetter((FieldInterfaced)field).replaceFirst("get", "findBy"));
            if (m != null) {
                found = (List)m.invoke((Object)this.searcher, text);
            }
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
        VerticalLayout contenedor = new VerticalLayout();
        this.resultsLayout.addComponent((Component)contenedor);
        contenedor.addStyleName("contenedor");
        contenedor.addStyleName("nopadding");
        if (found.size() == 0) {
            Label l = new Label("No match");
            contenedor.addComponent((Component)l);
            l.addStyleName("h3");
        } else {
            for (Found f : found) {
                HorizontalLayout hl = new HorizontalLayout();
                contenedor.addComponent((Component)hl);
                hl.setDefaultComponentAlignment(Alignment.MIDDLE_LEFT);
                hl.addStyleName("nopadding");
                Button b = new Button(f.getName());
                hl.addComponent((Component)b);
                b.addClickListener((Button.ClickListener & Serializable)ev -> {
                    this.close();
                    MDDUIAccessor.goTo((String)f.getPath());
                });
                b.addStyleName("link");
                Label l = new Label(f.getDescription());
                hl.addComponent((Component)l);
                b.addStyleName("submenuoption");
            }
        }
    }

    public abstract void close();
}

