/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.base.Strings;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.MDDRunnableAction;
import io.mateu.mdd.core.interfaces.PersistentPojo;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.interfaces.RpcView;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import io.mateu.mdd.vaadin.components.views.ActionGroupWindow;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.components.views.RpcListViewComponent;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import io.mateu.util.persistence.JPATransaction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.validation.constraints.Size;

public class ViewComponentHelper {
    public static AbstractAction createAction(final Method m, final AbstractViewComponent viewComponent) {
        AbstractAction action = viewComponent.getActionByMethod(m);
        if (action == null) {
            final Action aa = m.getAnnotation(Action.class);
            action = new MDDRunnableAction(!Strings.isNullOrEmpty((String)aa.value()) ? aa.value() : Helper.capitalize((String)m.getName())){

                public void run() {
                    block29: {
                        if (aa.isGroup()) {
                            UI.getCurrent().addWindow((Window)new ActionGroupWindow(m, viewComponent.menuItemsByGroup.get(m.getName())));
                        } else {
                            boolean needsValidation = aa.validateBefore();
                            if (!needsValidation && viewComponent instanceof EditorViewComponent) {
                                boolean bl = needsValidation = ((EditorViewComponent)viewComponent).getModelType().isAnnotationPresent(Entity.class) || PersistentPojo.class.isAssignableFrom(((EditorViewComponent)viewComponent).getModelType());
                            }
                            if (!needsValidation || ((EditorViewComponent)viewComponent).validate()) {
                                try {
                                    if (m.isAnnotationPresent(Action.class) && m.getAnnotation(Action.class).saveBefore() && viewComponent instanceof EditorViewComponent) {
                                        ((EditorViewComponent)viewComponent).save(false);
                                    }
                                    boolean allInjectable = true;
                                    boolean needsTransaction = false;
                                    boolean needsSelection = false;
                                    for (Parameter p : m.getParameters()) {
                                        Class pgc = ReflectionHelper.getGenericClass((Type)p.getParameterizedType());
                                        if (EntityManager.class.equals(p.getType())) {
                                            needsTransaction = true;
                                            continue;
                                        }
                                        if (viewComponent instanceof ListViewComponent && Set.class.isAssignableFrom(p.getType()) && (m.getDeclaringClass().equals(pgc) || viewComponent instanceof RpcListViewComponent && ReflectionHelper.getGenericClass(((RpcListViewComponent)viewComponent).getRpcListView().getClass(), RpcView.class, (String)"C").equals(pgc))) {
                                            if (p.isAnnotationPresent(Size.class) && p.getAnnotation(Size.class).min() <= 0) continue;
                                            needsSelection = true;
                                            continue;
                                        }
                                        allInjectable = false;
                                    }
                                    try {
                                        HashSet selection = new HashSet();
                                        if (viewComponent instanceof ListViewComponent) {
                                            ListViewComponent lvc = (ListViewComponent)viewComponent;
                                            JPAHelper.notransact(em -> {
                                                boolean jpa = lvc.getColumnType().isAnnotationPresent(Entity.class);
                                                lvc.getSelection().forEach(o -> {
                                                    if (jpa && o instanceof Object[]) {
                                                        selection.add(em.find(lvc.getColumnType(), lvc.deserializeId("" + lvc.toId(o))));
                                                    } else {
                                                        selection.add(o);
                                                    }
                                                });
                                            });
                                        } else if (viewComponent instanceof EditorViewComponent) {
                                            if (MDDUIAccessor.getPendingSelection() != null) {
                                                selection.addAll(MDDUIAccessor.getPendingSelection());
                                            }
                                            MDDUIAccessor.setPendingSelection(null);
                                        }
                                        if (needsSelection && selection.size() == 0) {
                                            throw new Exception("You must first select some records.");
                                        }
                                        if (!allInjectable) {
                                            MDDUIAccessor.open((Method)m, selection);
                                            break block29;
                                        }
                                        try {
                                            Object instance = null;
                                            if (viewComponent instanceof EditorViewComponent) {
                                                EditorViewComponent evc = (EditorViewComponent)viewComponent;
                                                instance = evc.getModel();
                                            } else if (viewComponent instanceof RpcListViewComponent) {
                                                instance = ((RpcListViewComponent)viewComponent).getRpcListView();
                                            }
                                            if (needsTransaction) {
                                                final Object finalInstance = instance;
                                                final HashSet finalSelection = selection;
                                                JPAHelper.transact((JPATransaction)new JPATransaction(){

                                                    public void run(EntityManager em) throws Throwable {
                                                        if (viewComponent instanceof EditorViewComponent) {
                                                            Object ni = em.merge(finalInstance);
                                                            ViewComponentHelper.invoke(viewComponent, m, ni, finalSelection, em, null);
                                                            if (viewComponent instanceof EditorViewComponent) {
                                                                ((EditorViewComponent)viewComponent).setModel(ni);
                                                            }
                                                        } else {
                                                            ViewComponentHelper.invoke(viewComponent, m, finalInstance, finalSelection, em, null);
                                                        }
                                                    }
                                                });
                                                if (viewComponent instanceof EditorViewComponent && instance.getClass().isAnnotationPresent(Entity.class)) {
                                                    EditorViewComponent evc = (EditorViewComponent)viewComponent;
                                                    Object i = evc.getModel();
                                                    JPAHelper.notransact(em -> evc.setModel(em.find(i.getClass(), ReflectionHelper.getId((Object)i))));
                                                }
                                            } else {
                                                ViewComponentHelper.invoke(viewComponent, m, instance, selection, null, null);
                                            }
                                            if (m.isAnnotationPresent(Action.class) && m.getAnnotation(Action.class).saveAfter() && viewComponent instanceof EditorViewComponent) {
                                                ((EditorViewComponent)viewComponent).save(false);
                                            } else if (viewComponent instanceof EditorViewComponent) {
                                                EditorViewComponent evc = (EditorViewComponent)viewComponent;
                                                evc.getBinder().update(evc.getModel());
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Notifier.alert((Throwable)throwable);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Notifier.alert((Throwable)throwable);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Notifier.alert((Throwable)throwable);
                                }
                            }
                        }
                    }
                }
            }.setStyle(aa.style()).setIcon(VaadinIcons.ADOBE_FLASH.equals((Object)aa.icon()) ? null : aa.icon()).setConfirmationMessage(aa.confirmationMessage()).setId(m.getName());
            action.setGroup(aa.group());
            viewComponent.setAction(m, action);
        }
        return action;
    }

    private static void invoke(AbstractViewComponent viewComponent, Method m, Object instance, Set selection, EntityManager em, Map<String, Object> parameterValues) throws InvocationTargetException, IllegalAccessException {
        boolean needsEm = false;
        for (Parameter p : m.getParameters()) {
            if (!EntityManager.class.equals(p.getType())) continue;
            needsEm = true;
            break;
        }
        ArrayList<Object> vs = new ArrayList<Object>();
        for (Parameter p : m.getParameters()) {
            Class pgc = ReflectionHelper.getGenericClass((Type)p.getParameterizedType());
            if (EntityManager.class.equals(p.getType())) {
                vs.add(em);
                continue;
            }
            if (viewComponent instanceof ListViewComponent && Set.class.isAssignableFrom(p.getType()) && (m.getDeclaringClass().equals(pgc) || viewComponent instanceof RpcListViewComponent && ReflectionHelper.getGenericClass(((RpcListViewComponent)viewComponent).getRpcListView().getClass(), RpcView.class, (String)"C").equals(pgc))) {
                if (needsEm && ReflectionHelper.getGenericClass((Type)p.getParameterizedType()).isAnnotationPresent(Entity.class)) {
                    HashSet<Object> aux = new HashSet<Object>();
                    for (Object e : selection) {
                        aux.add(em.find(ReflectionHelper.getGenericClass((Type)p.getParameterizedType()), ReflectionHelper.getId(e)));
                    }
                    selection = aux;
                }
                vs.add(selection);
                continue;
            }
            vs.add(parameterValues != null ? parameterValues.get(p.getName()) : null);
        }
        Object[] args = vs.toArray();
        Object r = m.invoke(instance, args);
        if (Void.TYPE.equals(m.getReturnType())) {
            if (viewComponent instanceof ListViewComponent) {
                ListViewComponent lvc = (ListViewComponent)viewComponent;
                try {
                    lvc.search(lvc.getModelForSearchFilters());
                }
                catch (Throwable throwable) {
                    Notifier.alert((Throwable)throwable);
                }
            }
        } else {
            MDDUIAccessor.open((Method)m, (Object)r);
        }
    }
}

